/*
 * $Id: HttpServerListenerProc.java,v 1.1 2008/10/05 01:33:42 nishimoto Exp $
 * TODO: based on http://xxx.upken.jp/report/honey/http/
 */

package galatea.httpserver;


import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Hashtable;

class HttpServerListenerProc implements Runnable {
	//private static final long serialVersionUID = 1L;
	private int serverport = 9999;
	private int clients = 0;
	private ServerSocket svsock;
	private IHttpServerResponse response;
	
	public HttpServerListenerProc(IHttpServerResponse r, int port) {
		response = r;
		serverport = port;
	}

	public void run() {
		HttpServer.addLogPrintLn("http://localhost:" + serverport + " listening...");
		try {
			svsock = new ServerSocket(serverport);
		} catch (IOException e) {
			// addLogln(e.getMessage());
			return;
		}
		while (true) {
			try {
				Socket cl = svsock.accept();
				clients++;
				// addLogln("Accept: " + clients);
				new Thread(new HttpServerProc(cl, clients, response)).start();
				// System.gc();
			} catch(IOException e) {
				// addLogln(e.getMessage());
			}
		}
	}
}


