/*
 * The Relaxer artifact
 * Copyright (c) 2000-2004, ASAMI Tomoharu, All rights reserved.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of this software and associated documentation files (the
 * "Software"), to deal in the Software without restriction, including
 * without limitation the rights to use, copy, modify, merge, publish,
 * distribute, sublicense, and/or sell copies of the Software, and to
 * permit persons to whom the Software is furnished to do so, subject to
 * the following conditions:
 *
 * - Redistributions of source code must retain the above copyright
 *   notice, this list of conditions and the following disclaimer. 
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE
 * LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
 * OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
 * WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */
package galatea.relaxer.event;

import java.io.*;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.URL;
import javax.xml.parsers.*;
import org.w3c.dom.*;
import org.xml.sax.*;

/**
 * <b>EventWHYPO</b> is generated from event.rng by Relaxer.
 * This class is derived from:
 * 
 * <!-- for programmer
 * <element name="WHYPO">
 *       <optional>
 *         <attribute name="CM">
 *           <data type="float"/>
 *         </attribute>
 *       </optional>
 *       <optional>
 *         <attribute name="PHONE">
 *           <data type="token"/>
 *         </attribute>
 *       </optional>
 *       <optional>
 *         <attribute name="WORD">
 *           <data type="token"/>
 *         </attribute>
 *       </optional>
 *     </element>-->
 * <!-- for javadoc -->
 * <pre> &lt;element name="WHYPO"&gt;
 *       &lt;optional&gt;
 *         &lt;attribute name="CM"&gt;
 *           &lt;data type="float"/&gt;
 *         &lt;/attribute&gt;
 *       &lt;/optional&gt;
 *       &lt;optional&gt;
 *         &lt;attribute name="PHONE"&gt;
 *           &lt;data type="token"/&gt;
 *         &lt;/attribute&gt;
 *       &lt;/optional&gt;
 *       &lt;optional&gt;
 *         &lt;attribute name="WORD"&gt;
 *           &lt;data type="token"/&gt;
 *         &lt;/attribute&gt;
 *       &lt;/optional&gt;
 *     &lt;/element&gt;</pre>
 *
 * @version event.rng (Thu Oct 02 00:02:10 JST 2008)
 * @author  Relaxer 1.1b (http://www.relaxer.org)
 */
public class EventWHYPO implements java.io.Serializable, Cloneable {
    private Float CM_;
    private String PHONE_;
    private String WORD_;
    private Element xmlElement;

    /**
     * Creates a <code>EventWHYPO</code>.
     *
     */
    public EventWHYPO() {
    }

    /**
     * Creates a <code>EventWHYPO</code>.
     *
     * @param source
     */
    public EventWHYPO(EventWHYPO source) {
        setup(source);
    }

    /**
     * Creates a <code>EventWHYPO</code> by the Stack <code>stack</code>
     * that contains Elements.
     * This constructor is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     */
    public EventWHYPO(RStack stack) {
        setup(stack);
    }

    /**
     * Creates a <code>EventWHYPO</code> by the Document <code>doc</code>.
     *
     * @param doc
     */
    public EventWHYPO(Document doc) {
        setup(doc.getDocumentElement());
    }

    /**
     * Creates a <code>EventWHYPO</code> by the Element <code>element</code>.
     *
     * @param element
     */
    public EventWHYPO(Element element) {
        setup(element);
    }

    /**
     * Creates a <code>EventWHYPO</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public EventWHYPO(File file) throws IOException, SAXException, ParserConfigurationException {
        setup(file);
    }

    /**
     * Creates a <code>EventWHYPO</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public EventWHYPO(String uri) throws IOException, SAXException, ParserConfigurationException {
        setup(uri);
    }

    /**
     * Creates a <code>EventWHYPO</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public EventWHYPO(URL url) throws IOException, SAXException, ParserConfigurationException {
        setup(url);
    }

    /**
     * Creates a <code>EventWHYPO</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public EventWHYPO(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        setup(in);
    }

    /**
     * Creates a <code>EventWHYPO</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public EventWHYPO(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        setup(is);
    }

    /**
     * Creates a <code>EventWHYPO</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public EventWHYPO(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        setup(reader);
    }

    /**
     * Initializes the <code>EventWHYPO</code> by the EventWHYPO <code>source</code>.
     *
     * @param source
     */
    public void setup(EventWHYPO source) {
        int size;
        CM_ = source.CM_;
        PHONE_ = source.PHONE_;
        WORD_ = source.WORD_;
    }

    /**
     * Initializes the <code>EventWHYPO</code> by the Document <code>doc</code>.
     *
     * @param doc
     */
    public void setup(Document doc) {
        setup(doc.getDocumentElement());
    }

    /**
     * Initializes the <code>EventWHYPO</code> by the Element <code>element</code>.
     *
     * @param element
     */
    public void setup(Element element) {
        init(element);
    }

    /**
     * Initializes the <code>EventWHYPO</code> by the Stack <code>stack</code>
     * that contains Elements.
     * This constructor is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     */
    public void setup(RStack stack) {
        init(stack.popElement());
    }

    /**
     * @param element
     */
    private void init(Element element) {
        xmlElement = element;
        RStack stack = new RStack(element);
        CM_ = URelaxer.getAttributePropertyAsFloatObject(element, "CM");
        PHONE_ = URelaxer.getAttributePropertyAsString(element, "PHONE");
        WORD_ = URelaxer.getAttributePropertyAsString(element, "WORD");
    }

    /**
     * @return Object
     */
    public Object clone() {
        return (new EventWHYPO((EventWHYPO)this));
    }

    /**
     * Creates a DOM representation of the object.
     * Result is appended to the Node <code>parent</code>.
     *
     * @param parent
     */
    public void makeElement(Node parent) {
        Document doc;
        if (parent instanceof Document) {
            doc = (Document)parent;
        } else {
            doc = parent.getOwnerDocument();
        }
        Element element = doc.createElement("WHYPO");
        int size;
        if (this.CM_ != null) {
            URelaxer.setAttributePropertyByFloat(element, "CM", this.CM_);
        }
        if (this.PHONE_ != null) {
            URelaxer.setAttributePropertyByString(element, "PHONE", this.PHONE_);
        }
        if (this.WORD_ != null) {
            URelaxer.setAttributePropertyByString(element, "WORD", this.WORD_);
        }
        parent.appendChild(element);
    }

    /**
     * Initializes the <code>EventWHYPO</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(File file) throws IOException, SAXException, ParserConfigurationException {
        setup(file.toURL());
    }

    /**
     * Initializes the <code>EventWHYPO</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(String uri) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(uri, UJAXP.FLAG_NONE));
    }

    /**
     * Initializes the <code>EventWHYPO</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(URL url) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(url, UJAXP.FLAG_NONE));
    }

    /**
     * Initializes the <code>EventWHYPO</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(in, UJAXP.FLAG_NONE));
    }

    /**
     * Initializes the <code>EventWHYPO</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(is, UJAXP.FLAG_NONE));
    }

    /**
     * Initializes the <code>EventWHYPO</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(reader, UJAXP.FLAG_NONE));
    }

    /**
     * Creates a DOM document representation of the object.
     *
     * @exception ParserConfigurationException
     * @return Document
     */
    public Document makeDocument() throws ParserConfigurationException {
        Document doc = UJAXP.makeDocument();
        makeElement(doc);
        return (doc);
    }

    /**
     * Gets the float property <b>CM</b>.
     *
     * @return float
     */
    public float getCM() {
        if (CM_ == null) {
            return(Float.NaN);
        }
        return (CM_.floatValue());
    }

    /**
     * Gets the float property <b>CM</b>.
     *
     * @param CM
     * @return float
     */
    public float getCM(float CM) {
        if (CM_ == null) {
            return(CM);
        }
        return (this.CM_.floatValue());
    }

    /**
     * Gets the float property <b>CM</b>.
     *
     * @return Float
     */
    public Float getCMAsFloat() {
        return (CM_);
    }

    /**
     * Check the float property <b>CM</b>.
     *
     * @return boolean
     */
    public boolean checkCM() {
        return (CM_ != null);
    }

    /**
     * Sets the float property <b>CM</b>.
     *
     * @param CM
     */
    public void setCM(float CM) {
        this.CM_ = new Float(CM);
    }

    /**
     * Sets the float property <b>CM</b>.
     *
     * @param CM
     */
    public void setCM(Float CM) {
        this.CM_ = CM;
    }

    /**
     * Gets the String property <b>PHONE</b>.
     *
     * @return String
     */
    public String getPHONE() {
        return (PHONE_);
    }

    /**
     * Sets the String property <b>PHONE</b>.
     *
     * @param PHONE
     */
    public void setPHONE(String PHONE) {
        this.PHONE_ = PHONE;
    }

    /**
     * Gets the String property <b>WORD</b>.
     *
     * @return String
     */
    public String getWORD() {
        return (WORD_);
    }

    /**
     * Sets the String property <b>WORD</b>.
     *
     * @param WORD
     */
    public void setWORD(String WORD) {
        this.WORD_ = WORD;
    }

    /**
     * Gets the element to be used in the object construction.
     *
     * @return Element
     */
    public Element rGetElement() {
        return (xmlElement);
    }

    /**
     * Makes an XML text representation.
     *
     * @return String
     */
    public String makeTextDocument() {
        StringBuffer buffer = new StringBuffer();
        makeTextElement(buffer);
        return (new String(buffer));
    }

    /**
     * Makes an XML text representation.
     *
     * @param buffer
     */
    public void makeTextElement(StringBuffer buffer) {
        int size;
        buffer.append("<WHYPO");
        if (CM_ != null) {
            buffer.append(" CM=\"");
            buffer.append(URelaxer.getString(getCM()));
            buffer.append("\"");
        }
        if (PHONE_ != null) {
            buffer.append(" PHONE=\"");
            buffer.append(URelaxer.escapeAttrQuot(URelaxer.getString(getPHONE())));
            buffer.append("\"");
        }
        if (WORD_ != null) {
            buffer.append(" WORD=\"");
            buffer.append(URelaxer.escapeAttrQuot(URelaxer.getString(getWORD())));
            buffer.append("\"");
        }
        buffer.append(">");
        buffer.append("</WHYPO>");
    }

    /**
     * Makes an XML text representation.
     *
     * @param buffer
     * @exception IOException
     */
    public void makeTextElement(Writer buffer) throws IOException {
        int size;
        buffer.write("<WHYPO");
        if (CM_ != null) {
            buffer.write(" CM=\"");
            buffer.write(URelaxer.getString(getCM()));
            buffer.write("\"");
        }
        if (PHONE_ != null) {
            buffer.write(" PHONE=\"");
            buffer.write(URelaxer.escapeAttrQuot(URelaxer.getString(getPHONE())));
            buffer.write("\"");
        }
        if (WORD_ != null) {
            buffer.write(" WORD=\"");
            buffer.write(URelaxer.escapeAttrQuot(URelaxer.getString(getWORD())));
            buffer.write("\"");
        }
        buffer.write(">");
        buffer.write("</WHYPO>");
    }

    /**
     * Makes an XML text representation.
     *
     * @param buffer
     */
    public void makeTextElement(PrintWriter buffer) {
        int size;
        buffer.print("<WHYPO");
        if (CM_ != null) {
            buffer.print(" CM=\"");
            buffer.print(URelaxer.getString(getCM()));
            buffer.print("\"");
        }
        if (PHONE_ != null) {
            buffer.print(" PHONE=\"");
            buffer.print(URelaxer.escapeAttrQuot(URelaxer.getString(getPHONE())));
            buffer.print("\"");
        }
        if (WORD_ != null) {
            buffer.print(" WORD=\"");
            buffer.print(URelaxer.escapeAttrQuot(URelaxer.getString(getWORD())));
            buffer.print("\"");
        }
        buffer.print(">");
        buffer.print("</WHYPO>");
    }

    /**
     * Makes an XML text representation.
     *
     * @param buffer
     */
    public void makeTextAttribute(StringBuffer buffer) {
    }

    /**
     * Makes an XML text representation.
     *
     * @param buffer
     * @exception IOException
     */
    public void makeTextAttribute(Writer buffer) throws IOException {
    }

    /**
     * Makes an XML text representation.
     *
     * @param buffer
     */
    public void makeTextAttribute(PrintWriter buffer) {
    }

    /**
     * Gets the property value as String.
     *
     * @return String
     */
    public String getCMAsString() {
        return (URelaxer.getString(getCM()));
    }

    /**
     * Gets the property value as String.
     *
     * @return String
     */
    public String getPHONEAsString() {
        return (URelaxer.getString(getPHONE()));
    }

    /**
     * Gets the property value as String.
     *
     * @return String
     */
    public String getWORDAsString() {
        return (URelaxer.getString(getWORD()));
    }

    /**
     * Sets the property value by String.
     *
     * @param string
     */
    public void setCMByString(String string) {
        setCM(Float.parseFloat(string));
    }

    /**
     * Sets the property value by String.
     *
     * @param string
     */
    public void setPHONEByString(String string) {
        setPHONE(string);
    }

    /**
     * Sets the property value by String.
     *
     * @param string
     */
    public void setWORDByString(String string) {
        setWORD(string);
    }

    /**
     * Returns a String representation of this object.
     * While this method informs as XML format representaion, 
     *  it's purpose is just information, not making 
     * a rigid XML documentation.
     *
     * @return String
     */
    public String toString() {
        try {
            return (makeTextDocument());
        } catch (Exception e) {
            return (super.toString());
        }
    }

    /**
     * Tests if a Element <code>element</code> is valid
     * for the <code>EventWHYPO</code>.
     *
     * @param element
     * @return boolean
     */
    public static boolean isMatch(Element element) {
        if (!URelaxer.isTargetElement(element, "WHYPO")) {
            return (false);
        }
        RStack target = new RStack(element);
        boolean $match$ = false;
        Element child;
        if (!target.isEmptyElement()) {
            return (false);
        }
        return (true);
    }

    /**
     * Tests if elements contained in a Stack <code>stack</code>
     * is valid for the <code>EventWHYPO</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return boolean
     */
    public static boolean isMatch(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return (false);
        }
        return (isMatch(element));
    }

    /**
     * Tests if elements contained in a Stack <code>stack</code>
     * is valid for the <code>EventWHYPO</code>.
     * This method consumes the stack contents during matching operation.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return boolean
     */
    public static boolean isMatchHungry(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return (false);
        }
        if (isMatch(element)) {
            stack.popElement();
            return (true);
        } else {
            return (false);
        }
    }
}
