/*
 * $Id: JuliusServerRunner.java,v 1.4 2009/02/16 05:35:59 nishimoto Exp $
 */
package galatea.io.julius;

import galatea.logger.Logger;
import galatea.util.Property;
import galatea.util.SubProcess;
import galatea.util.Util;

public class JuliusServerRunner {
	
	private Logger logger_ = new Logger(this.getClass()); // Logger("JulianServerRunner");
	private String errors_ = "";
	private String outputs_ = "";
	private String exception_ = "";
	private SubProcess subProcess_;
	
	/**
	 * command_ and dirpath_ must be with full path.
	 * otherwise, Runtime.exec() error occurs.
	 */
	private String command_ = "C:/work/galatea4win/engine/SRM/bin/julian.exe";
	private String config_ = "-C ../jconf-default.txt";
	private String dirpath_ = "C:/work/galatea4win/engine/SRM/test";
	private boolean running_ = false;

	public JuliusServerRunner() {
		super();
		dirpath_ = Property.getForPlatformAsStr("JuliusServerRunner.Dir", "");
		command_ = Property.getForPlatformAsStr("JuliusServerRunner.Exe", "");
		config_  = Property.getForPlatformAsStr("JuliusServerRunner.Arg", "");
	}

	public static void main(String args[]) {
		final JuliusServerRunner runner = new JuliusServerRunner();
		runner.run();
		Runtime.getRuntime().addShutdownHook(new Thread() {
		    public void run() { 
				System.out.println("shutdown hook");
		    	runner.setRunning(false);
		    }
		});
		while (runner.isRunning()) {
			try {
				Thread.sleep(1);
			} catch (InterruptedException e) {
				e.printStackTrace();
			}
			if (runner.hasErrors()) {
				System.out.print("[E] " + runner.getErrors());
				runner.clearErrors();
			}
			if (runner.hasOutputs()) {
				System.out.print("[O] " + runner.getOutputs());
				runner.clearOutputs();
			}
			System.out.flush();
		}
	}
	
	public boolean hasOutputs() {
		return outputs_.length() > 0;
	}

	public boolean hasErrors() {
		return errors_.length() > 0;
	}

	public boolean isRunning() {
		return running_;
	}

	public void setRunning(boolean b) {
		running_ = b;
	}

	public boolean run() {
    	logger_.print(command_ + " " + config_);
		subProcess_ = new SubProcess(command_ + " " + config_, dirpath_);
		if (subProcess_ == null) {
			return false;
		}
    	logger_.print("starting..");
		if (subProcess_.run() == false) {
			logger_.print(subProcess_.getError());
	    	return false;
		}
		logger_.print("started.");
		errors_ = "";
		outputs_ = "";
		exception_ = "";
		Thread th = new Thread(new Runnable() {
			public void run() {
				while (running_) {
					String er = subProcess_.receiveFromStderrNB();
					if (er.length() > 0) {
						logger_.print("[E]" + er);
						errors_ += er + "\n";
					}
					String out = subProcess_.receiveFromStdoutNB();
					if (out.length() > 0) {
						logger_.print("[O]" + out);
						outputs_ += out + "\n";
					}
					try {
						Thread.sleep(1);
					} catch (InterruptedException e) {
						e.printStackTrace();
					}
				}
				subProcess_.destroy();
				try {
					Thread.sleep(1000);
				} catch (InterruptedException e) {
					e.printStackTrace();
				}
			}
		});
		running_ = true;
		th.start();
		return true;
	}
	
	public String getErrors() {
		return errors_; 
	}

	public String getOutputs() {
		return outputs_; 
	}
	
	public String getException() {
		return exception_;
	}

	public void clearErrors() {
		errors_ = "";
	}
	
	public void clearOutputs() {
		outputs_ = "";
	}
	
	public void destroy() {
		subProcess_.destroy();
	}
	
}
