/*
 * The Relaxer artifact
 * Copyright (c) 2000-2004, ASAMI Tomoharu, All rights reserved.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of this software and associated documentation files (the
 * "Software"), to deal in the Software without restriction, including
 * without limitation the rights to use, copy, modify, merge, publish,
 * distribute, sublicense, and/or sell copies of the Software, and to
 * permit persons to whom the Software is furnished to do so, subject to
 * the following conditions:
 *
 * - Redistributions of source code must retain the above copyright
 *   notice, this list of conditions and the following disclaimer. 
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE
 * LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
 * OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
 * WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */
package galatea.relaxer.event;

import java.io.*;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.URL;
import javax.xml.parsers.*;
import org.w3c.dom.*;
import org.xml.sax.*;

/**
 * <b>EventPHYPO</b> is generated from event.rng by Relaxer.
 * This class is derived from:
 * 
 * <!-- for programmer
 * <element name="PHYPO">
 *       <attribute name="FRAME">
 *         <data type="int"/>
 *       </attribute>
 *       <attribute name="PASS">
 *         <data type="int"/>
 *       </attribute>
 *       <attribute name="SCORE">
 *         <data type="float"/>
 *       </attribute>
 *       <attribute name="TIME">
 *         <data type="int"/>
 *       </attribute>
 *       <zeroOrMore>
 *         <ref name="WHYPO"/>
 *       </zeroOrMore>
 *     </element>-->
 * <!-- for javadoc -->
 * <pre> &lt;element name="PHYPO"&gt;
 *       &lt;attribute name="FRAME"&gt;
 *         &lt;data type="int"/&gt;
 *       &lt;/attribute&gt;
 *       &lt;attribute name="PASS"&gt;
 *         &lt;data type="int"/&gt;
 *       &lt;/attribute&gt;
 *       &lt;attribute name="SCORE"&gt;
 *         &lt;data type="float"/&gt;
 *       &lt;/attribute&gt;
 *       &lt;attribute name="TIME"&gt;
 *         &lt;data type="int"/&gt;
 *       &lt;/attribute&gt;
 *       &lt;zeroOrMore&gt;
 *         &lt;ref name="WHYPO"/&gt;
 *       &lt;/zeroOrMore&gt;
 *     &lt;/element&gt;</pre>
 *
 * @version event.rng (Thu Oct 02 00:02:10 JST 2008)
 * @author  Relaxer 1.1b (http://www.relaxer.org)
 */
public class EventPHYPO implements java.io.Serializable, Cloneable, IEventRECOGOUTChoice {
    private int FRAME_;
    private int PASS_;
    private float SCORE_;
    private int TIME_;
    // List<EventWHYPO>
    private java.util.List WHYPO_ = new java.util.ArrayList();
    private Element xmlElement;

    /**
     * Creates a <code>EventPHYPO</code>.
     *
     */
    public EventPHYPO() {
    }

    /**
     * Creates a <code>EventPHYPO</code>.
     *
     * @param source
     */
    public EventPHYPO(EventPHYPO source) {
        setup(source);
    }

    /**
     * Creates a <code>EventPHYPO</code> by the Stack <code>stack</code>
     * that contains Elements.
     * This constructor is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     */
    public EventPHYPO(RStack stack) {
        setup(stack);
    }

    /**
     * Creates a <code>EventPHYPO</code> by the Document <code>doc</code>.
     *
     * @param doc
     */
    public EventPHYPO(Document doc) {
        setup(doc.getDocumentElement());
    }

    /**
     * Creates a <code>EventPHYPO</code> by the Element <code>element</code>.
     *
     * @param element
     */
    public EventPHYPO(Element element) {
        setup(element);
    }

    /**
     * Creates a <code>EventPHYPO</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public EventPHYPO(File file) throws IOException, SAXException, ParserConfigurationException {
        setup(file);
    }

    /**
     * Creates a <code>EventPHYPO</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public EventPHYPO(String uri) throws IOException, SAXException, ParserConfigurationException {
        setup(uri);
    }

    /**
     * Creates a <code>EventPHYPO</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public EventPHYPO(URL url) throws IOException, SAXException, ParserConfigurationException {
        setup(url);
    }

    /**
     * Creates a <code>EventPHYPO</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public EventPHYPO(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        setup(in);
    }

    /**
     * Creates a <code>EventPHYPO</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public EventPHYPO(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        setup(is);
    }

    /**
     * Creates a <code>EventPHYPO</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public EventPHYPO(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        setup(reader);
    }

    /**
     * Initializes the <code>EventPHYPO</code> by the EventPHYPO <code>source</code>.
     *
     * @param source
     */
    public void setup(EventPHYPO source) {
        int size;
        FRAME_ = source.FRAME_;
        PASS_ = source.PASS_;
        SCORE_ = source.SCORE_;
        TIME_ = source.TIME_;
        this.WHYPO_.clear();
        size = source.WHYPO_.size();
        for (int i = 0;i < size;i++) {
            addWHYPO((EventWHYPO)source.getWHYPO(i).clone());
        }
    }

    /**
     * Initializes the <code>EventPHYPO</code> by the Document <code>doc</code>.
     *
     * @param doc
     */
    public void setup(Document doc) {
        setup(doc.getDocumentElement());
    }

    /**
     * Initializes the <code>EventPHYPO</code> by the Element <code>element</code>.
     *
     * @param element
     */
    public void setup(Element element) {
        init(element);
    }

    /**
     * Initializes the <code>EventPHYPO</code> by the Stack <code>stack</code>
     * that contains Elements.
     * This constructor is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     */
    public void setup(RStack stack) {
        init(stack.popElement());
    }

    /**
     * @param element
     */
    private void init(Element element) {
        xmlElement = element;
        RStack stack = new RStack(element);
        FRAME_ = URelaxer.getAttributePropertyAsInt(element, "FRAME");
        PASS_ = URelaxer.getAttributePropertyAsInt(element, "PASS");
        SCORE_ = URelaxer.getAttributePropertyAsFloat(element, "SCORE");
        TIME_ = URelaxer.getAttributePropertyAsInt(element, "TIME");
        WHYPO_.clear();
        while (true) {
            if (EventWHYPO.isMatch(stack)) {
                addWHYPO(new EventWHYPO(stack));
            } else {
                break;
            }
        }
    }

    /**
     * @return Object
     */
    public Object clone() {
        return (new EventPHYPO((EventPHYPO)this));
    }

    /**
     * Creates a DOM representation of the object.
     * Result is appended to the Node <code>parent</code>.
     *
     * @param parent
     */
    public void makeElement(Node parent) {
        Document doc;
        if (parent instanceof Document) {
            doc = (Document)parent;
        } else {
            doc = parent.getOwnerDocument();
        }
        Element element = doc.createElement("PHYPO");
        int size;
        URelaxer.setAttributePropertyByInt(element, "FRAME", this.FRAME_);
        URelaxer.setAttributePropertyByInt(element, "PASS", this.PASS_);
        URelaxer.setAttributePropertyByFloat(element, "SCORE", this.SCORE_);
        URelaxer.setAttributePropertyByInt(element, "TIME", this.TIME_);
        size = this.WHYPO_.size();
        for (int i = 0;i < size;i++) {
            EventWHYPO value = (EventWHYPO)this.WHYPO_.get(i);
            value.makeElement(element);
        }
        parent.appendChild(element);
    }

    /**
     * Initializes the <code>EventPHYPO</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(File file) throws IOException, SAXException, ParserConfigurationException {
        setup(file.toURL());
    }

    /**
     * Initializes the <code>EventPHYPO</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(String uri) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(uri, UJAXP.FLAG_NONE));
    }

    /**
     * Initializes the <code>EventPHYPO</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(URL url) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(url, UJAXP.FLAG_NONE));
    }

    /**
     * Initializes the <code>EventPHYPO</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(in, UJAXP.FLAG_NONE));
    }

    /**
     * Initializes the <code>EventPHYPO</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(is, UJAXP.FLAG_NONE));
    }

    /**
     * Initializes the <code>EventPHYPO</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(reader, UJAXP.FLAG_NONE));
    }

    /**
     * Creates a DOM document representation of the object.
     *
     * @exception ParserConfigurationException
     * @return Document
     */
    public Document makeDocument() throws ParserConfigurationException {
        Document doc = UJAXP.makeDocument();
        makeElement(doc);
        return (doc);
    }

    /**
     * Gets the int property <b>FRAME</b>.
     *
     * @return int
     */
    public int getFRAME() {
        return (FRAME_);
    }

    /**
     * Sets the int property <b>FRAME</b>.
     *
     * @param FRAME
     */
    public void setFRAME(int FRAME) {
        this.FRAME_ = FRAME;
    }

    /**
     * Gets the int property <b>FRAME</b>.
     *
     * @return Integer
     */
    public Integer getFRAMEAsInteger() {
        return (new Integer(FRAME_));
    }

    /**
     * Sets the int property <b>FRAME</b>.
     *
     * @param FRAME
     */
    public void setFRAME(Integer FRAME) {
        this.FRAME_ = FRAME.intValue();
    }

    /**
     * Gets the int property <b>PASS</b>.
     *
     * @return int
     */
    public int getPASS() {
        return (PASS_);
    }

    /**
     * Sets the int property <b>PASS</b>.
     *
     * @param PASS
     */
    public void setPASS(int PASS) {
        this.PASS_ = PASS;
    }

    /**
     * Gets the int property <b>PASS</b>.
     *
     * @return Integer
     */
    public Integer getPASSAsInteger() {
        return (new Integer(PASS_));
    }

    /**
     * Sets the int property <b>PASS</b>.
     *
     * @param PASS
     */
    public void setPASS(Integer PASS) {
        this.PASS_ = PASS.intValue();
    }

    /**
     * Gets the float property <b>SCORE</b>.
     *
     * @return float
     */
    public float getSCORE() {
        return (SCORE_);
    }

    /**
     * Sets the float property <b>SCORE</b>.
     *
     * @param SCORE
     */
    public void setSCORE(float SCORE) {
        this.SCORE_ = SCORE;
    }

    /**
     * Gets the float property <b>SCORE</b>.
     *
     * @return Float
     */
    public Float getSCOREAsFloat() {
        return (new Float(SCORE_));
    }

    /**
     * Sets the float property <b>SCORE</b>.
     *
     * @param SCORE
     */
    public void setSCORE(Float SCORE) {
        this.SCORE_ = SCORE.floatValue();
    }

    /**
     * Gets the int property <b>TIME</b>.
     *
     * @return int
     */
    public int getTIME() {
        return (TIME_);
    }

    /**
     * Sets the int property <b>TIME</b>.
     *
     * @param TIME
     */
    public void setTIME(int TIME) {
        this.TIME_ = TIME;
    }

    /**
     * Gets the int property <b>TIME</b>.
     *
     * @return Integer
     */
    public Integer getTIMEAsInteger() {
        return (new Integer(TIME_));
    }

    /**
     * Sets the int property <b>TIME</b>.
     *
     * @param TIME
     */
    public void setTIME(Integer TIME) {
        this.TIME_ = TIME.intValue();
    }

    /**
     * Gets the EventWHYPO property <b>WHYPO</b>.
     *
     * @return EventWHYPO[]
     */
    public EventWHYPO[] getWHYPO() {
        EventWHYPO[] array = new EventWHYPO[WHYPO_.size()];
        return ((EventWHYPO[])WHYPO_.toArray(array));
    }

    /**
     * Sets the EventWHYPO property <b>WHYPO</b>.
     *
     * @param WHYPO
     */
    public void setWHYPO(EventWHYPO[] WHYPO) {
        this.WHYPO_.clear();
        for (int i = 0;i < WHYPO.length;i++) {
            addWHYPO(WHYPO[i]);
        }
    }

    /**
     * Sets the EventWHYPO property <b>WHYPO</b>.
     *
     * @param WHYPO
     */
    public void setWHYPO(EventWHYPO WHYPO) {
        this.WHYPO_.clear();
        addWHYPO(WHYPO);
    }

    /**
     * Adds the EventWHYPO property <b>WHYPO</b>.
     *
     * @param WHYPO
     */
    public void addWHYPO(EventWHYPO WHYPO) {
        this.WHYPO_.add(WHYPO);
    }

    /**
     * Adds the EventWHYPO property <b>WHYPO</b>.
     *
     * @param WHYPO
     */
    public void addWHYPO(EventWHYPO[] WHYPO) {
        for (int i = 0;i < WHYPO.length;i++) {
            addWHYPO(WHYPO[i]);
        }
    }

    /**
     * Gets number of the EventWHYPO property <b>WHYPO</b>.
     *
     * @return int
     */
    public int sizeWHYPO() {
        return (WHYPO_.size());
    }

    /**
     * Gets the EventWHYPO property <b>WHYPO</b> by index.
     *
     * @param index
     * @return EventWHYPO
     */
    public EventWHYPO getWHYPO(int index) {
        return ((EventWHYPO)WHYPO_.get(index));
    }

    /**
     * Sets the EventWHYPO property <b>WHYPO</b> by index.
     *
     * @param index
     * @param WHYPO
     */
    public void setWHYPO(int index, EventWHYPO WHYPO) {
        this.WHYPO_.set(index, WHYPO);
    }

    /**
     * Adds the EventWHYPO property <b>WHYPO</b> by index.
     *
     * @param index
     * @param WHYPO
     */
    public void addWHYPO(int index, EventWHYPO WHYPO) {
        this.WHYPO_.add(index, WHYPO);
    }

    /**
     * Remove the EventWHYPO property <b>WHYPO</b> by index.
     *
     * @param index
     */
    public void removeWHYPO(int index) {
        this.WHYPO_.remove(index);
    }

    /**
     * Remove the EventWHYPO property <b>WHYPO</b> by object.
     *
     * @param WHYPO
     */
    public void removeWHYPO(EventWHYPO WHYPO) {
        this.WHYPO_.remove(WHYPO);
    }

    /**
     * Clear the EventWHYPO property <b>WHYPO</b>.
     *
     */
    public void clearWHYPO() {
        this.WHYPO_.clear();
    }

    /**
     * Gets the element to be used in the object construction.
     *
     * @return Element
     */
    public Element rGetElement() {
        return (xmlElement);
    }

    /**
     * Makes an XML text representation.
     *
     * @return String
     */
    public String makeTextDocument() {
        StringBuffer buffer = new StringBuffer();
        makeTextElement(buffer);
        return (new String(buffer));
    }

    /**
     * Makes an XML text representation.
     *
     * @param buffer
     */
    public void makeTextElement(StringBuffer buffer) {
        int size;
        buffer.append("<PHYPO");
        buffer.append(" FRAME=\"");
        buffer.append(URelaxer.getString(getFRAME()));
        buffer.append("\"");
        buffer.append(" PASS=\"");
        buffer.append(URelaxer.getString(getPASS()));
        buffer.append("\"");
        buffer.append(" SCORE=\"");
        buffer.append(URelaxer.getString(getSCORE()));
        buffer.append("\"");
        buffer.append(" TIME=\"");
        buffer.append(URelaxer.getString(getTIME()));
        buffer.append("\"");
        buffer.append(">");
        size = this.WHYPO_.size();
        for (int i = 0;i < size;i++) {
            EventWHYPO value = (EventWHYPO)this.WHYPO_.get(i);
            value.makeTextElement(buffer);
        }
        buffer.append("</PHYPO>");
    }

    /**
     * Makes an XML text representation.
     *
     * @param buffer
     * @exception IOException
     */
    public void makeTextElement(Writer buffer) throws IOException {
        int size;
        buffer.write("<PHYPO");
        buffer.write(" FRAME=\"");
        buffer.write(URelaxer.getString(getFRAME()));
        buffer.write("\"");
        buffer.write(" PASS=\"");
        buffer.write(URelaxer.getString(getPASS()));
        buffer.write("\"");
        buffer.write(" SCORE=\"");
        buffer.write(URelaxer.getString(getSCORE()));
        buffer.write("\"");
        buffer.write(" TIME=\"");
        buffer.write(URelaxer.getString(getTIME()));
        buffer.write("\"");
        buffer.write(">");
        size = this.WHYPO_.size();
        for (int i = 0;i < size;i++) {
            EventWHYPO value = (EventWHYPO)this.WHYPO_.get(i);
            value.makeTextElement(buffer);
        }
        buffer.write("</PHYPO>");
    }

    /**
     * Makes an XML text representation.
     *
     * @param buffer
     */
    public void makeTextElement(PrintWriter buffer) {
        int size;
        buffer.print("<PHYPO");
        buffer.print(" FRAME=\"");
        buffer.print(URelaxer.getString(getFRAME()));
        buffer.print("\"");
        buffer.print(" PASS=\"");
        buffer.print(URelaxer.getString(getPASS()));
        buffer.print("\"");
        buffer.print(" SCORE=\"");
        buffer.print(URelaxer.getString(getSCORE()));
        buffer.print("\"");
        buffer.print(" TIME=\"");
        buffer.print(URelaxer.getString(getTIME()));
        buffer.print("\"");
        buffer.print(">");
        size = this.WHYPO_.size();
        for (int i = 0;i < size;i++) {
            EventWHYPO value = (EventWHYPO)this.WHYPO_.get(i);
            value.makeTextElement(buffer);
        }
        buffer.print("</PHYPO>");
    }

    /**
     * Makes an XML text representation.
     *
     * @param buffer
     */
    public void makeTextAttribute(StringBuffer buffer) {
    }

    /**
     * Makes an XML text representation.
     *
     * @param buffer
     * @exception IOException
     */
    public void makeTextAttribute(Writer buffer) throws IOException {
    }

    /**
     * Makes an XML text representation.
     *
     * @param buffer
     */
    public void makeTextAttribute(PrintWriter buffer) {
    }

    /**
     * Gets the property value as String.
     *
     * @return String
     */
    public String getFRAMEAsString() {
        return (URelaxer.getString(getFRAME()));
    }

    /**
     * Gets the property value as String.
     *
     * @return String
     */
    public String getPASSAsString() {
        return (URelaxer.getString(getPASS()));
    }

    /**
     * Gets the property value as String.
     *
     * @return String
     */
    public String getSCOREAsString() {
        return (URelaxer.getString(getSCORE()));
    }

    /**
     * Gets the property value as String.
     *
     * @return String
     */
    public String getTIMEAsString() {
        return (URelaxer.getString(getTIME()));
    }

    /**
     * Sets the property value by String.
     *
     * @param string
     */
    public void setFRAMEByString(String string) {
        setFRAME(Integer.parseInt(string));
    }

    /**
     * Sets the property value by String.
     *
     * @param string
     */
    public void setPASSByString(String string) {
        setPASS(Integer.parseInt(string));
    }

    /**
     * Sets the property value by String.
     *
     * @param string
     */
    public void setSCOREByString(String string) {
        setSCORE(Float.parseFloat(string));
    }

    /**
     * Sets the property value by String.
     *
     * @param string
     */
    public void setTIMEByString(String string) {
        setTIME(Integer.parseInt(string));
    }

    /**
     * Returns a String representation of this object.
     * While this method informs as XML format representaion, 
     *  it's purpose is just information, not making 
     * a rigid XML documentation.
     *
     * @return String
     */
    public String toString() {
        try {
            return (makeTextDocument());
        } catch (Exception e) {
            return (super.toString());
        }
    }

    /**
     * Tests if a Element <code>element</code> is valid
     * for the <code>EventPHYPO</code>.
     *
     * @param element
     * @return boolean
     */
    public static boolean isMatch(Element element) {
        if (!URelaxer.isTargetElement(element, "PHYPO")) {
            return (false);
        }
        RStack target = new RStack(element);
        boolean $match$ = false;
        Element child;
        if (!URelaxer.hasAttributeHungry(target, "FRAME")) {
            return (false);
        }
        $match$ = true;
        if (!URelaxer.hasAttributeHungry(target, "PASS")) {
            return (false);
        }
        $match$ = true;
        if (!URelaxer.hasAttributeHungry(target, "SCORE")) {
            return (false);
        }
        $match$ = true;
        if (!URelaxer.hasAttributeHungry(target, "TIME")) {
            return (false);
        }
        $match$ = true;
        while (true) {
            if (!EventWHYPO.isMatchHungry(target)) {
                break;
            }
            $match$ = true;
        }
        if (!target.isEmptyElement()) {
            return (false);
        }
        return (true);
    }

    /**
     * Tests if elements contained in a Stack <code>stack</code>
     * is valid for the <code>EventPHYPO</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return boolean
     */
    public static boolean isMatch(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return (false);
        }
        return (isMatch(element));
    }

    /**
     * Tests if elements contained in a Stack <code>stack</code>
     * is valid for the <code>EventPHYPO</code>.
     * This method consumes the stack contents during matching operation.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return boolean
     */
    public static boolean isMatchHungry(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return (false);
        }
        if (isMatch(element)) {
            stack.popElement();
            return (true);
        } else {
            return (false);
        }
    }
}
