/*
 * The Relaxer artifact
 * Copyright (c) 2000-2004, ASAMI Tomoharu, All rights reserved.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of this software and associated documentation files (the
 * "Software"), to deal in the Software without restriction, including
 * without limitation the rights to use, copy, modify, merge, publish,
 * distribute, sublicense, and/or sell copies of the Software, and to
 * permit persons to whom the Software is furnished to do so, subject to
 * the following conditions:
 *
 * - Redistributions of source code must retain the above copyright
 *   notice, this list of conditions and the following disclaimer. 
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE
 * LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
 * OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
 * WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */
package galatea.relaxer.pdoc;

import java.io.*;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.URL;
import javax.xml.parsers.*;
import org.w3c.dom.*;
import org.xml.sax.*;

/**
 * <b>PdocState</b> is generated from pdoc.rng by Relaxer.
 * This class is derived from:
 * 
 * <!-- for programmer
 * <element name="state">
 *       <attribute name="id">
 *         <data type="token"/>
 *       </attribute>
 * 
 *       <zeroOrMore>
 *         <ref name="catch"/>
 *       </zeroOrMore>
 *       <ref name="cmd"/>
 *     </element>-->
 * <!-- for javadoc -->
 * <pre> &lt;element name="state"&gt;
 *       &lt;attribute name="id"&gt;
 *         &lt;data type="token"/&gt;
 *       &lt;/attribute&gt;
 * 
 *       &lt;zeroOrMore&gt;
 *         &lt;ref name="catch"/&gt;
 *       &lt;/zeroOrMore&gt;
 *       &lt;ref name="cmd"/&gt;
 *     &lt;/element&gt;</pre>
 *
 * @version pdoc.rng (Thu Oct 02 00:02:08 JST 2008)
 * @author  Relaxer 1.1b (http://www.relaxer.org)
 */
public class PdocState implements java.io.Serializable, Cloneable {
    private String id_;
    // List<PdocCatch>
    private java.util.List catch_ = new java.util.ArrayList();
    private PdocCmd cmd_;
    private Element xmlElement;

    /**
     * Creates a <code>PdocState</code>.
     *
     */
    public PdocState() {
        id_ = "";
    }

    /**
     * Creates a <code>PdocState</code>.
     *
     * @param source
     */
    public PdocState(PdocState source) {
        setup(source);
    }

    /**
     * Creates a <code>PdocState</code> by the Stack <code>stack</code>
     * that contains Elements.
     * This constructor is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     */
    public PdocState(RStack stack) {
        setup(stack);
    }

    /**
     * Creates a <code>PdocState</code> by the Document <code>doc</code>.
     *
     * @param doc
     */
    public PdocState(Document doc) {
        setup(doc.getDocumentElement());
    }

    /**
     * Creates a <code>PdocState</code> by the Element <code>element</code>.
     *
     * @param element
     */
    public PdocState(Element element) {
        setup(element);
    }

    /**
     * Creates a <code>PdocState</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public PdocState(File file) throws IOException, SAXException, ParserConfigurationException {
        setup(file);
    }

    /**
     * Creates a <code>PdocState</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public PdocState(String uri) throws IOException, SAXException, ParserConfigurationException {
        setup(uri);
    }

    /**
     * Creates a <code>PdocState</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public PdocState(URL url) throws IOException, SAXException, ParserConfigurationException {
        setup(url);
    }

    /**
     * Creates a <code>PdocState</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public PdocState(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        setup(in);
    }

    /**
     * Creates a <code>PdocState</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public PdocState(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        setup(is);
    }

    /**
     * Creates a <code>PdocState</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public PdocState(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        setup(reader);
    }

    /**
     * Initializes the <code>PdocState</code> by the PdocState <code>source</code>.
     *
     * @param source
     */
    public void setup(PdocState source) {
        int size;
        id_ = source.id_;
        this.catch_.clear();
        size = source.catch_.size();
        for (int i = 0;i < size;i++) {
            addCatch((PdocCatch)source.getCatch(i).clone());
        }
        if (source.cmd_ != null) {
            setCmd((PdocCmd)source.getCmd().clone());
        }
    }

    /**
     * Initializes the <code>PdocState</code> by the Document <code>doc</code>.
     *
     * @param doc
     */
    public void setup(Document doc) {
        setup(doc.getDocumentElement());
    }

    /**
     * Initializes the <code>PdocState</code> by the Element <code>element</code>.
     *
     * @param element
     */
    public void setup(Element element) {
        init(element);
    }

    /**
     * Initializes the <code>PdocState</code> by the Stack <code>stack</code>
     * that contains Elements.
     * This constructor is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     */
    public void setup(RStack stack) {
        init(stack.popElement());
    }

    /**
     * @param element
     */
    private void init(Element element) {
        xmlElement = element;
        RStack stack = new RStack(element);
        id_ = URelaxer.getAttributePropertyAsString(element, "id");
        catch_.clear();
        while (true) {
            if (PdocCatch.isMatch(stack)) {
                addCatch(new PdocCatch(stack));
            } else {
                break;
            }
        }
        setCmd(new PdocCmd(stack));
    }

    /**
     * @return Object
     */
    public Object clone() {
        return (new PdocState((PdocState)this));
    }

    /**
     * Creates a DOM representation of the object.
     * Result is appended to the Node <code>parent</code>.
     *
     * @param parent
     */
    public void makeElement(Node parent) {
        Document doc;
        if (parent instanceof Document) {
            doc = (Document)parent;
        } else {
            doc = parent.getOwnerDocument();
        }
        Element element = doc.createElement("state");
        int size;
        if (this.id_ != null) {
            URelaxer.setAttributePropertyByString(element, "id", this.id_);
        }
        size = this.catch_.size();
        for (int i = 0;i < size;i++) {
            PdocCatch value = (PdocCatch)this.catch_.get(i);
            value.makeElement(element);
        }
        this.cmd_.makeElement(element);
        parent.appendChild(element);
    }

    /**
     * Initializes the <code>PdocState</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(File file) throws IOException, SAXException, ParserConfigurationException {
        setup(file.toURL());
    }

    /**
     * Initializes the <code>PdocState</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(String uri) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(uri, UJAXP.FLAG_NONE));
    }

    /**
     * Initializes the <code>PdocState</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(URL url) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(url, UJAXP.FLAG_NONE));
    }

    /**
     * Initializes the <code>PdocState</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(in, UJAXP.FLAG_NONE));
    }

    /**
     * Initializes the <code>PdocState</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(is, UJAXP.FLAG_NONE));
    }

    /**
     * Initializes the <code>PdocState</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(reader, UJAXP.FLAG_NONE));
    }

    /**
     * Creates a DOM document representation of the object.
     *
     * @exception ParserConfigurationException
     * @return Document
     */
    public Document makeDocument() throws ParserConfigurationException {
        Document doc = UJAXP.makeDocument();
        makeElement(doc);
        return (doc);
    }

    /**
     * Gets the String property <b>id</b>.
     *
     * @return String
     */
    public String getId() {
        return (id_);
    }

    /**
     * Sets the String property <b>id</b>.
     *
     * @param id
     */
    public void setId(String id) {
        this.id_ = id;
    }

    /**
     * Gets the PdocCatch property <b>catch</b>.
     *
     * @return PdocCatch[]
     */
    public PdocCatch[] getCatch() {
        PdocCatch[] array = new PdocCatch[catch_.size()];
        return ((PdocCatch[])catch_.toArray(array));
    }

    /**
     * Sets the PdocCatch property <b>catch</b>.
     *
     * @param catchValue
     */
    public void setCatch(PdocCatch[] catchValue) {
        this.catch_.clear();
        for (int i = 0;i < catchValue.length;i++) {
            addCatch(catchValue[i]);
        }
    }

    /**
     * Sets the PdocCatch property <b>catch</b>.
     *
     * @param catchValue
     */
    public void setCatch(PdocCatch catchValue) {
        this.catch_.clear();
        addCatch(catchValue);
    }

    /**
     * Adds the PdocCatch property <b>catch</b>.
     *
     * @param catchValue
     */
    public void addCatch(PdocCatch catchValue) {
        this.catch_.add(catchValue);
    }

    /**
     * Adds the PdocCatch property <b>catch</b>.
     *
     * @param catchValue
     */
    public void addCatch(PdocCatch[] catchValue) {
        for (int i = 0;i < catchValue.length;i++) {
            addCatch(catchValue[i]);
        }
    }

    /**
     * Gets number of the PdocCatch property <b>catch</b>.
     *
     * @return int
     */
    public int sizeCatch() {
        return (catch_.size());
    }

    /**
     * Gets the PdocCatch property <b>catch</b> by index.
     *
     * @param index
     * @return PdocCatch
     */
    public PdocCatch getCatch(int index) {
        return ((PdocCatch)catch_.get(index));
    }

    /**
     * Sets the PdocCatch property <b>catch</b> by index.
     *
     * @param index
     * @param catchValue
     */
    public void setCatch(int index, PdocCatch catchValue) {
        this.catch_.set(index, catchValue);
    }

    /**
     * Adds the PdocCatch property <b>catch</b> by index.
     *
     * @param index
     * @param catchValue
     */
    public void addCatch(int index, PdocCatch catchValue) {
        this.catch_.add(index, catchValue);
    }

    /**
     * Remove the PdocCatch property <b>catch</b> by index.
     *
     * @param index
     */
    public void removeCatch(int index) {
        this.catch_.remove(index);
    }

    /**
     * Remove the PdocCatch property <b>catch</b> by object.
     *
     * @param catchValue
     */
    public void removeCatch(PdocCatch catchValue) {
        this.catch_.remove(catchValue);
    }

    /**
     * Clear the PdocCatch property <b>catch</b>.
     *
     */
    public void clearCatch() {
        this.catch_.clear();
    }

    /**
     * Gets the PdocCmd property <b>cmd</b>.
     *
     * @return PdocCmd
     */
    public PdocCmd getCmd() {
        return (cmd_);
    }

    /**
     * Sets the PdocCmd property <b>cmd</b>.
     *
     * @param cmd
     */
    public void setCmd(PdocCmd cmd) {
        this.cmd_ = cmd;
    }

    /**
     * Gets the element to be used in the object construction.
     *
     * @return Element
     */
    public Element rGetElement() {
        return (xmlElement);
    }

    /**
     * Makes an XML text representation.
     *
     * @return String
     */
    public String makeTextDocument() {
        StringBuffer buffer = new StringBuffer();
        makeTextElement(buffer);
        return (new String(buffer));
    }

    /**
     * Makes an XML text representation.
     *
     * @param buffer
     */
    public void makeTextElement(StringBuffer buffer) {
        int size;
        buffer.append("<state");
        if (id_ != null) {
            buffer.append(" id=\"");
            buffer.append(URelaxer.escapeAttrQuot(URelaxer.getString(getId())));
            buffer.append("\"");
        }
        buffer.append(">");
        size = this.catch_.size();
        for (int i = 0;i < size;i++) {
            PdocCatch value = (PdocCatch)this.catch_.get(i);
            value.makeTextElement(buffer);
        }
        cmd_.makeTextElement(buffer);
        buffer.append("</state>");
    }

    /**
     * Makes an XML text representation.
     *
     * @param buffer
     * @exception IOException
     */
    public void makeTextElement(Writer buffer) throws IOException {
        int size;
        buffer.write("<state");
        if (id_ != null) {
            buffer.write(" id=\"");
            buffer.write(URelaxer.escapeAttrQuot(URelaxer.getString(getId())));
            buffer.write("\"");
        }
        buffer.write(">");
        size = this.catch_.size();
        for (int i = 0;i < size;i++) {
            PdocCatch value = (PdocCatch)this.catch_.get(i);
            value.makeTextElement(buffer);
        }
        cmd_.makeTextElement(buffer);
        buffer.write("</state>");
    }

    /**
     * Makes an XML text representation.
     *
     * @param buffer
     */
    public void makeTextElement(PrintWriter buffer) {
        int size;
        buffer.print("<state");
        if (id_ != null) {
            buffer.print(" id=\"");
            buffer.print(URelaxer.escapeAttrQuot(URelaxer.getString(getId())));
            buffer.print("\"");
        }
        buffer.print(">");
        size = this.catch_.size();
        for (int i = 0;i < size;i++) {
            PdocCatch value = (PdocCatch)this.catch_.get(i);
            value.makeTextElement(buffer);
        }
        cmd_.makeTextElement(buffer);
        buffer.print("</state>");
    }

    /**
     * Makes an XML text representation.
     *
     * @param buffer
     */
    public void makeTextAttribute(StringBuffer buffer) {
    }

    /**
     * Makes an XML text representation.
     *
     * @param buffer
     * @exception IOException
     */
    public void makeTextAttribute(Writer buffer) throws IOException {
    }

    /**
     * Makes an XML text representation.
     *
     * @param buffer
     */
    public void makeTextAttribute(PrintWriter buffer) {
    }

    /**
     * Gets the property value as String.
     *
     * @return String
     */
    public String getIdAsString() {
        return (URelaxer.getString(getId()));
    }

    /**
     * Sets the property value by String.
     *
     * @param string
     */
    public void setIdByString(String string) {
        setId(string);
    }

    /**
     * Returns a String representation of this object.
     * While this method informs as XML format representaion, 
     *  it's purpose is just information, not making 
     * a rigid XML documentation.
     *
     * @return String
     */
    public String toString() {
        try {
            return (makeTextDocument());
        } catch (Exception e) {
            return (super.toString());
        }
    }

    /**
     * Gets attribute.
     *
     * @return String
     */
    public String getCmd_Cond() {
        if (cmd_ == null) {
            return (null);
        }
        return (cmd_.getCond());
    }

    /**
     * Gets attribute.
     *
     * @param cond
     */
    public void setCmd_Cond(String cond) {
        if (cmd_ == null) {
            cmd_ = new PdocCmd();
        }
        cmd_.setCond(cond);
    }

    /**
     * Tests if a Element <code>element</code> is valid
     * for the <code>PdocState</code>.
     *
     * @param element
     * @return boolean
     */
    public static boolean isMatch(Element element) {
        if (!URelaxer.isTargetElement(element, "state")) {
            return (false);
        }
        RStack target = new RStack(element);
        boolean $match$ = false;
        Element child;
        if (!URelaxer.hasAttributeHungry(target, "id")) {
            return (false);
        }
        $match$ = true;
        while (true) {
            if (!PdocCatch.isMatchHungry(target)) {
                break;
            }
            $match$ = true;
        }
        if (!PdocCmd.isMatchHungry(target)) {
            return (false);
        }
        $match$ = true;
        if (!target.isEmptyElement()) {
            return (false);
        }
        return (true);
    }

    /**
     * Tests if elements contained in a Stack <code>stack</code>
     * is valid for the <code>PdocState</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return boolean
     */
    public static boolean isMatch(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return (false);
        }
        return (isMatch(element));
    }

    /**
     * Tests if elements contained in a Stack <code>stack</code>
     * is valid for the <code>PdocState</code>.
     * This method consumes the stack contents during matching operation.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return boolean
     */
    public static boolean isMatchHungry(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return (false);
        }
        if (isMatch(element)) {
            stack.popElement();
            return (true);
        } else {
            return (false);
        }
    }
}
