#!/usr/bin/ruby -Ku
# coding: utf-8
# (c) Takuya NISHIMOTO 

require 'fileutils'

class GalateaConfigMaker < ConfigMaker
  attr_reader :errors
  attr_accessor :runner_skel_path
  attr_accessor :verbose
  attr_writer :preprocess_only
  attr_accessor :runner_tmp_dir
  
  def initialize(file_array)
    super
    if $skel_dir
      @runner_skel_path = $skel_dir
    else
      @runner_skel_path = File.expand_path(File.join(File.dirname(__FILE__), '..',  'skel'))
    end
    if $tmp_dir
      @runner_tmp_dir = $tmp_dir
    else
      @runner_tmp_dir = p('dm.tmp_dir')
    end
    @errors = []
  end

  def set_dm_options(options, files)
    file = files.pop
    if file
      dm_arg = expand_path(file)
    else
      dm_arg = p('dm.default_vxml')
    end
    @dm_options = options.join(' ') 
    if dm_arg
      @dm_options += ' ' + dm_arg
    end
  end

  def mkdir_tmppath
    unless File.exists?(@runner_tmp_dir)
      FileUtils.mkdir_p @runner_tmp_dir
    end
    File.chmod 0755, @runner_tmp_dir
  end

  def set_lang(lang)
    @srm_lang = lang
    @dm_language = lang
    #if lang == 'ja'
    #  # @srm_binhmm = 'hmmdefs,ptm,gid.binhmm'
    #  # @am_commands_ssm = "cd #{p('enginepath')}/SSM/gtalk ; ./gtalk -C #{@tmppath}/ssm.conf"
    #else # 'en'
    #  # @srm_binhmm = 'hmmdefs_mix16_gid.binhmm'
    #  # @am_commands_ssm = "#{p('ruby.bin')} ./SSM-espeak.rb"
    #end
  end  

  def make(file)
    begin
      File.open("#{@runner_tmp_dir}/#{file}", "w") do |outfile|
        str = File.open("#{runner_skel_path}/#{file}.txt", "r").read
        outfile.write translate(str)
     end
    rescue => error
      puts "in " + file + " : " + error.message
      exit
    end
  end
  
  #def env_ok?
  #  files = [ 
  #    "#{p('srm.julius.engine_dir')}/bin/julius",
  #    "#{p('ssm.gtalk.engine_dir')}/gtalk",
  #    "#{p('ssm.gtalk.chasen_dir')}/bin/chasen",
  #    "#{p('ssm.gtalk.chaone_dir')}/chaone",
  #    "#{p('fsm.galateafsm.engine_dir')}/fsm",
  #  ]
  #  files.each do |f|
  #    unless File.stat(f).executable?
  #      @errors << "#{f} is not executable"    
  #    end
  #  end
  #  return false if @errors.size > 0
  #  true
  #end
  
  def runner_cmd
    if @preprocess_only
		classpath = p('javascript.jar') + ":" + p('dm.jar') 
		java_bin = p('java.bin')
		c = "#{java_bin} -cp #{classpath} galatea.dialog.DialogManager -c #{@runner_tmp_dir}/gdm.conf" + " -p " + @dm_options
		puts c
		return c
    end
    perl_bin = p('perl.bin')
    # encoding = p('dm.encoding')
    am_perl = "./AgentManager-gdm.pl"
    "#{p('runner.env')}; cd #{p('dm.modules_dir')}; #{perl_bin} #{am_perl} -C #{@runner_tmp_dir}/am.conf"
  end

end
