#!/usr/bin/ruby -Ku
# coding: utf-8
# (c) Takuya NISHIMOTO 

require 'optparse'
require 'thread'
%w[ helper.rb yaml_reader.rb config_maker.rb galatea_config_maker.rb ].each do |f|
  require File.join($library_dir, f)
end

dm_conf_options = []
galatea_lang = 'ja'
rails_server = nil
dry_run = false
preprocess_only = false

config_yml_array = []

puts "[runner_dir] " + $runner_dir
ar = [ File.join($runner_dir, 'runner.yml'), File.join($runner_dir, 'config', 'runner.yml') ]
if $generator_dir
  ar << File.join($generator_dir, 'runner.yml')
end
ar << "/usr/local/galatea-dialog/runner.yml"
puts "[config candidate] " + ar.join(' ')
ar.each do |f|
  if File.exist?(f)
    config_yml_array << f
  end
end
puts "[config] " + config_yml_array.join(' ')

ARGV.options do |opt|
  opt.on('-D attr=value') do |v|
    dm_conf_options.push "-D #{v}"
  end
  opt.on('--rails-server path') do |v|
    rails_server = v       
  end
  opt.on('--config file.yml') do |v|
    file = File.expand_path(v)
    if File.exists?(file)
      config_yml_array.unshift file
    end
  end
  opt.on('--lang (ja|en)') do |v|
    galatea_lang = v
  end
  opt.on('-n', '--dry-run') do |v|
    dry_run = true
  end
  opt.on('-P', '--preprocess-only') do 
    preprocess_only = true
  end
  opt.parse!
end

m = GalateaConfigMaker.new(config_yml_array)
m.verbose = true
m.set_dm_options dm_conf_options, ARGV
m.set_lang galatea_lang
m.mkdir_tmppath
m.preprocess_only = preprocess_only
%w[ julius.conf gdm.conf fsm.conf ssm.conf chasenrc-euc-jp gtalk-euc-jp.dic am.conf am_mcl.conf ].each do |f|
  m.make f
end
#unless m.env_ok?
#  puts m.errors.join("\n")
#  exit
#end
if rails_server
  server_cmd = "#{m.p('rails.ruby.bin')} #{rails_server}/script/server"
else
  server_cmd = nil
end
if dry_run
  # puts '[config] ' + config_yml_array.join(' ')
  puts '[server] ' + server_cmd if server_cmd
  puts '[runner] ' + m.runner_cmd
else
  #system server_cmd if server_cmd
  if server_cmd
    Thread.start do
      system server_cmd
    end
  end
  system m.runner_cmd
end
exit

# end of file
