#ifndef HISTORYDIALOG_H
#define HISTORYDIALOG_H

#include <QDialog>
class FolderModel;

namespace Ui {
class HistoryDialog;
}

class HistoryDialog : public QDialog
{
    Q_OBJECT

public:
    explicit HistoryDialog(QWidget *parent = 0);
    ~HistoryDialog();

    void setModel(const FolderModel *left,
                  const FolderModel *right,
                  FolderModel *active);

private slots:
    void on_radioLeft_clicked();
    void on_radioRight_clicked();

private:
    Ui::HistoryDialog *ui;
    const FolderModel *m_leftModel;
    const FolderModel *m_rightModel;
    FolderModel *m_activeModel;

    // QDialog interface
public slots:
    void accept();
};

#endif // HISTORYDIALOG_H
