#ifndef PREFERENCEDIALOG_H
#define PREFERENCEDIALOG_H

#include <QDialog>
#include <QLabel>
class Preferences;

namespace Ui {
class PreferenceDialog;
}

class PreferenceDialog : public QDialog
{
    Q_OBJECT

public:
    explicit PreferenceDialog(QWidget *parent = 0);
    ~PreferenceDialog();

private:
    Ui::PreferenceDialog *ui;

    void    loadAppearance(Preferences &prefs);
    void    saveAppearance(Preferences &prefs);
    void    setFont(QLabel *label, const QFont &font);
    void    setPalette(QWidget *w, QPalette::ColorRole role, const QColor &color);

private slots:
    void    chooseColor();
    void    chooseFont();
    void    choosePath();
    void    exportAppearance();
    void    importAppearance();

    // QDialog interface
public slots:
    void accept();

    // QObject interface
public:
    bool eventFilter(QObject *obj, QEvent *event);
};

#endif // PREFERENCEDIALOG_H
