#include "renameworker.h"

#include <QFile>
#include <QFileInfo>
#include <QThread>

const int SLEEP_TIME = 1;

///////////////////////////////////////////////////////////////////////////////
/// \brief RenameWorker::RenameWorker
///
/// コンストラクタ
///
RenameWorker::RenameWorker() :
    OperationWorker(),
    m_RenameMap(NULL)
{
}

///////////////////////////////////////////////////////////////////////////////
/// \brief RenameWorker::run
///
/// リネーム処理を行います。
///
void RenameWorker::run()
{
    StringMap::const_iterator it;
    bool ret;
    int successCount = 0;
    int errorCount = 0;
    QString msg;
    for (it = m_RenameMap->begin(); it != m_RenameMap->end(); it++) {
        this->thread()->msleep(SLEEP_TIME);
        if (isAborted()) {
            emit finished(true);
            return;
        }

        emit progress(tr("名前変更：%1 -> %2")
                      .arg(QFileInfo(it.key()).fileName())
                      .arg(QFileInfo(it.value()).fileName()));
        ret = QFile::rename(it.key(), it.value());
        if (ret) {
            successCount++;
            emit success(tr("成功"));
        }
        else {
            errorCount++;
            emit error(tr("失敗"));
        }
        msg = tr("%1アイテム成功。").arg(successCount);
        if (errorCount > 0) {
            msg += tr("%1アイテム失敗。").arg(errorCount);
        }
        emit information(msg);
    }

    emit finished();
}

///////////////////////////////////////////////////////////////////////////////
/// \brief RenameWorker::initialText
/// \return 初期表示テキストを返します。
///
QString RenameWorker::initialText() const
{
    return tr("名前を変更しています...");
}
