#include "mainwindow.h"
#include "thumbnaildelegate.h"
#include "thumbnailview.h"

#include <QApplication>
#include <QDebug>
#include <QDrag>
#include <QMimeData>
#include <QMouseEvent>

///////////////////////////////////////////////////////////////////////////////
/// \brief ThumbnailView::ThumbnailView
/// \param parent   親ウィジェット
///
/// コンストラクタ
///
ThumbnailView::ThumbnailView(QWidget *parent) :
    QListView(parent),
    m_p(this)
{
    setItemDelegate(new ThumbnailDelegate(this));
    setSpacing(12);
}

///////////////////////////////////////////////////////////////////////////////
/// \brief ThumbnailView::initialize
/// \param w    メインウィンドウオブジェクト
///
/// 初期化処理を行います。
///
void ThumbnailView::initialize(MainWindow *w)
{
    qDebug() << "ThumbnailView::initialize()";

    connect(this, SIGNAL(doubleClicked(QModelIndex)), w, SLOT(onOpen(QModelIndex)));
    connect(&m_p, SIGNAL(copyItems(QStringList,QString)), w, SLOT(copyItems(QStringList,QString)));
    connect(&m_p, SIGNAL(moveItems(QStringList,QString)), w, SLOT(moveItems(QStringList,QString)));

    installEventFilter(w);
    viewport()->installEventFilter(&m_p);
    viewport()->installEventFilter(w);
}

///////////////////////////////////////////////////////////////////////////////
/// \brief ThumbnailView::onScaleDown
///
/// サムネイルサイズを小さくします。
///
void ThumbnailView::onScaleDown()
{
    qDebug() << "ThumbnailView::onScaleDown()";

    static_cast<ThumbnailDelegate*>(itemDelegate())->scaleDown();
    folderModel()->clearPixmapCache();
}

///////////////////////////////////////////////////////////////////////////////
/// \brief ThumbnailView::onScaleUp
///
/// サムネイルサイズを大きくします。
///
void ThumbnailView::onScaleUp()
{
    qDebug() << "ThumbnailView::onScaleUp()";

    static_cast<ThumbnailDelegate*>(itemDelegate())->scaleUp();
    folderModel()->clearPixmapCache();
}

///////////////////////////////////////////////////////////////////////////////
/// \brief ThumbnailView::setModel
/// \param model    モデル
///
/// モデルを設定します。
///
void ThumbnailView::setModel(QAbstractItemModel *model)
{
    if (this->model()) {
        this->model()->disconnect(this);
    }

    QListView::setModel(model);

    if (this->model()) {
        connect(this->model(), SIGNAL(modelAboutToBeReset()), &m_p, SLOT(model_PreReset()));
        connect(this->model(), SIGNAL(modelReset()), &m_p, SLOT(model_PostReset()));
    }
}

///////////////////////////////////////////////////////////////////////////////
/// \brief ThumbnailView::setVisible
/// \param visible  表示(true)/非表示(false)
///
/// サムネイルサイズを初期化します。
///
void ThumbnailView::setVisible(bool visible)
{
    if (visible) {
        static_cast<ThumbnailDelegate*>(itemDelegate())->resetScale();
        folderModel()->clearPixmapCache();
    }

    QListView::setVisible(visible);
}
