#ifndef THUMBNAILVIEW_H
#define THUMBNAILVIEW_H

#include "folderview_private.h"
#include "foldermodel.h"

#include <QListView>
class MainWindow;

class ThumbnailView : public QListView
{
    Q_OBJECT

public:
    explicit ThumbnailView(QWidget *parent = 0);

    void            initialize(MainWindow *w);
    FolderModel*    folderModel() const;

private:
    FolderView_Private  m_p;

signals:

private slots:
    void onScaleUp();
    void onScaleDown();

    // QAbstractItemView interface
public:
    void setModel(QAbstractItemModel *model);

    // QWidget interface
public slots:
    void setVisible(bool visible);
};

inline FolderModel *ThumbnailView::folderModel() const
{
    return static_cast<FolderModel*>(model());
}

#endif // THUMBNAILVIEW_H
