//#define Q_OS_WIN

#include "win32.h"

#ifdef Q_OS_WIN
    #include <windows.h>
#endif

///////////////////////////////////////////////////////////////////////////////
/// \brief Win32::hasSystemAttribute
/// \param path パス
/// \return システム属性ファイルであればtrueを返します。
///
bool Win32::hasSystemAttribute(const QString &path)
{
#ifdef Q_OS_WIN
    DWORD dwFlags = ::GetFileAttributes(path.toStdWString().c_str());
    if (dwFlags != DWORD(-1) &&
        (dwFlags & FILE_ATTRIBUTE_SYSTEM) == FILE_ATTRIBUTE_SYSTEM)
    {
        return true;
    }
#else
    Q_UNUSED(path);
#endif
    return false;
}
