/*
 * Decompiled with CFR 0.152.
 */
package ow.ipmulticast;

import java.net.Inet4Address;
import java.net.UnknownHostException;

public class Utilities {
    public static Inet4Address intToInet4Address(int v) {
        Inet4Address addr = null;
        try {
            addr = (Inet4Address)Inet4Address.getByAddress(Utilities.intToByteArray(v));
        }
        catch (UnknownHostException e) {
            System.err.println("Inet4Address.getByAddress() throws an UnknownHostException.");
        }
        return addr;
    }

    public static byte[] intToByteArray(int v) {
        byte[] result = new byte[4];
        for (int i = 0; i < 4; ++i) {
            result[i] = (byte)(v >>> (3 - i) * 8);
        }
        return result;
    }

    public static int byteArrayToInt(byte[] bArray, int start, int len) {
        int result = 0;
        for (int i = 0; i < len; ++i) {
            result <<= 8;
            result |= bArray[start + i] & 0xFF;
        }
        return result;
    }

    public static int Inet4AddressToInt(Inet4Address addr) {
        int result = 0;
        if (addr != null) {
            byte[] bytes = addr.getAddress();
            for (int i = 0; i < 4; ++i) {
                result |= (bytes[i] & 0xFF) << (3 - i) * 8;
            }
        }
        return result;
    }

    public static long Inet4AddressToLong(Inet4Address addr) {
        long result = 0L;
        if (addr != null) {
            byte[] bytes = addr.getAddress();
            for (int i = 0; i < 4; ++i) {
                result |= ((long)bytes[i] & 0xFFL) << (3 - i) * 8;
            }
        }
        return result;
    }
}

