/*
 * Decompiled with CFR 0.152.
 */
package ow.routing.tapestry;

import java.io.IOException;
import java.io.Serializable;
import java.math.BigInteger;
import java.security.InvalidAlgorithmParameterException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.logging.Level;
import ow.id.ID;
import ow.id.IDAddressPair;
import ow.messaging.ExtendedMessageHandler;
import ow.messaging.Message;
import ow.messaging.MessageHandler;
import ow.messaging.Tag;
import ow.routing.RoutingAlgorithmConfiguration;
import ow.routing.RoutingService;
import ow.routing.plaxton.Plaxton;
import ow.routing.plaxton.RoutingTableRow;
import ow.routing.tapestry.TapestryConfiguration;
import ow.routing.tapestry.TapestryMessageFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Tapestry
extends Plaxton {
    private final Message notifyJoiningNodeMessage;
    private final Message multicastAckMessage;
    private TapestryConfiguration config;
    private JoinStatus joinStatus = JoinStatus.NOT_YET;
    private Object joinCompletedLock = new Object();

    protected Tapestry(RoutingAlgorithmConfiguration conf, RoutingService routingSvc) throws InvalidAlgorithmParameterException {
        super(conf, routingSvc);
        this.config = (TapestryConfiguration)conf;
        this.notifyJoiningNodeMessage = TapestryMessageFactory.getNotifyJoiningNodeMessage(this.selfIDAddress);
        this.multicastAckMessage = TapestryMessageFactory.getMulticastAckMessage(this.selfIDAddress);
        this.prepareHandlers();
    }

    @Override
    public BigInteger distance(ID to, ID from) {
        if (to.equals(from)) {
            return BigInteger.ZERO;
        }
        int nMatchBits = ID.matchLengthFromMSB(to, from);
        int nMatchDigits = nMatchBits / this.digitSize;
        BigInteger distance = BigInteger.ZERO;
        for (int i = nMatchDigits; i < this.idSizeInDigit; ++i) {
            int toDigit = this.getDigit(to, i);
            int fromDigit = this.getDigit(from, i);
            int digitDistance = this.digitDistanceInTapestry(toDigit, fromDigit);
            BigInteger digitDistanceBigInteger = BigInteger.valueOf(digitDistance).shiftLeft((this.idSizeInDigit - 1 - i) * this.digitSize);
            distance = distance.add(digitDistanceBigInteger);
        }
        return distance;
    }

    private int digitDistanceInTapestry(int toDigit, int fromDigit) {
        int distance = fromDigit - toDigit;
        if (distance < 0) {
            distance += 1 << this.digitSize;
        }
        return distance;
    }

    @Override
    protected List<IDAddressPair> traverseDownward(int rowIndex, int startingCol, ID target, int maxNum) {
        ArrayList<IDAddressPair> results = new ArrayList<IDAddressPair>();
        this.traverseDownward(results, rowIndex, startingCol, target, maxNum);
        return results;
    }

    private void traverseDownward(List<IDAddressPair> results, int rowIndex, int startingCol, ID target, int maxNum) {
        RoutingTableRow row = this.routingTable.getRow(rowIndex);
        int rowSize = row.size();
        for (int i = 0; i < rowSize; ++i) {
            int colIndex = (startingCol + i) % rowSize;
            IDAddressPair entry = row.get(colIndex);
            if (entry == null) continue;
            if (entry.equals(this.selfIDAddress) && rowIndex + 1 < this.idSizeInDigit) {
                this.traverseDownward(results, rowIndex + 1, colIndex, target, maxNum - results.size());
                if (results.size() < maxNum) continue;
                break;
            }
            results.add(entry);
            if (results.size() >= maxNum) break;
        }
    }

    @Override
    protected List<IDAddressPair> traverseUpward(int rowIndex, int maxNum) {
        ArrayList<IDAddressPair> results = new ArrayList<IDAddressPair>();
        ID selfID = this.selfIDAddress.getID();
        block0: for (int i = rowIndex - 1; i >= 0; --i) {
            RoutingTableRow row = this.routingTable.getRow(i);
            int rowSize = row.size();
            int digit = this.getDigit(selfID, i);
            for (int j = 1; j < rowSize; ++j) {
                int colIndex = (digit + j) % rowSize;
                IDAddressPair entry = row.get(colIndex);
                if (entry == null) continue;
                results.add(entry);
                if (results.size() >= maxNum) break block0;
            }
        }
        return results;
    }

    @Override
    public void join(IDAddressPair joiningNode, IDAddressPair lastHop, boolean isFinalHop) {
        super.join(joiningNode, lastHop, isFinalHop);
        if (lastHop == null) {
            this.startJoining();
        }
        if (!isFinalHop) {
            return;
        }
        this.waitForJoinCompletion();
        int nMatchBits = ID.matchLengthFromMSB(this.selfIDAddress.getID(), joiningNode.getID());
        int nMatchDigits = nMatchBits / this.digitSize;
        this.sendAcknowledgedMulticast(joiningNode.getID(), nMatchDigits, joiningNode);
        int nRowsToBeSent = nMatchDigits + 1;
        if (nRowsToBeSent > this.idSizeInDigit) {
            nRowsToBeSent = this.idSizeInDigit;
        }
        HashSet<IDAddressPair> nodeSet = new HashSet<IDAddressPair>();
        for (int i = 0; i < nRowsToBeSent; ++i) {
            RoutingTableRow row = this.routingTable.getRow(i);
            nodeSet.addAll(row.getAllNodes());
        }
        nodeSet.remove(joiningNode);
        nodeSet.remove(this.selfIDAddress);
        IDAddressPair[] nodes = new IDAddressPair[nodeSet.size()];
        nodeSet.toArray(nodes);
        Message reqMsg = TapestryMessageFactory.getUpdateRoutingTableMessage(this.selfIDAddress, nodes);
        try {
            this.sender.send(joiningNode.getAddress(), reqMsg);
        }
        catch (IOException e) {
            logger.log(Level.WARNING, "Failed to send a UPDATE_ROUNTING_TABLE message: " + joiningNode.getAddress(), e);
            this.fail(joiningNode);
        }
    }

    private void sendAcknowledgedMulticast(ID prefix, int prefixLen, IDAddressPair joiningNode) {
        logger.log(Level.INFO, "On " + this.selfIDAddress.getAddress() + ", sendAck'edMulticast() called: prefixLen: " + prefixLen + ", joining node: " + joiningNode.getAddress() + ".");
        while (prefixLen < this.idSizeInDigit) {
            RoutingTableRow row = this.routingTable.getRow(prefixLen);
            if (!row.isEmpty()) {
                for (int i = 0; i < 1 << this.digitSize; ++i) {
                    IDAddressPair childOnMulticastTree = row.get(i);
                    if (childOnMulticastTree == null || childOnMulticastTree.equals(this.selfIDAddress) || childOnMulticastTree.equals(joiningNode)) continue;
                    ID childPrefix = this.setDigit(prefix, prefixLen, i);
                    Message reqMsg = TapestryMessageFactory.getMulticastJoiningNodeMessage(this.selfIDAddress, childPrefix, prefixLen + 1, joiningNode);
                    boolean succeedToSend = true;
                    try {
                        logger.log(Level.INFO, "send ack'd multicast from " + this.selfIDAddress.getAddress() + " to " + childOnMulticastTree.getAddress() + " with prefix len " + prefixLen);
                        if (this.config.getReturnAckInAcknowledgedMulticast()) {
                            Message repMsg = this.sender.sendAndReceive(childOnMulticastTree.getAddress(), reqMsg);
                            if (repMsg.getTag() != Tag.MULTICAST_ACK.getNumber()) {
                                succeedToSend = false;
                            }
                        } else {
                            this.sender.send(childOnMulticastTree.getAddress(), reqMsg);
                        }
                    }
                    catch (IOException e) {
                        succeedToSend = false;
                        logger.log(Level.WARNING, "Failed to send an ack'ed multicast message: " + childOnMulticastTree.getAddress(), e);
                    }
                    if (succeedToSend) continue;
                    this.fail(childOnMulticastTree);
                }
            }
            ++prefixLen;
        }
    }

    @Override
    protected void prepareHandlers() {
        super.prepareHandlers();
        MessageHandler handler = new AcknowledgedMulticastMessageHandler();
        this.runtime.addMessageHandler(Tag.MULTICAST_JOINING_NODE.getNumber(), handler);
        handler = new MessageHandler(){

            public Message process(Message msg) {
                Serializable[] contents = msg.getContents();
                IDAddressPair[] nodes = (IDAddressPair[])contents[0];
                logger.log(Level.INFO, "UPDATE_ROUTING_TABLE received: # of nodes: " + nodes.length + " on " + Tapestry.this.selfIDAddress.getAddress() + " from " + msg.getSource().getAddress());
                Tapestry.this.touch(msg.getSource());
                for (IDAddressPair p : nodes) {
                    Tapestry.this.touch(p);
                }
                Tapestry.this.finishJoining();
                for (IDAddressPair node : nodes) {
                    if (node.equals(Tapestry.this.selfIDAddress)) continue;
                    logger.log(Level.INFO, Tapestry.this.selfIDAddress.getAddress() + " send a NOTIFY_JOINING msg to " + node.getAddress());
                    boolean notifySucceeded = true;
                    try {
                        Message notifyMsg = Tapestry.this.notifyJoiningNodeMessage;
                        Tapestry.this.sender.send(node.getAddress(), notifyMsg);
                    }
                    catch (IOException e) {
                        notifySucceeded = false;
                        logger.log(Level.WARNING, "An IOException thrown while sending NOTIFY_JOINING_NODE.", e);
                    }
                    if (notifySucceeded) continue;
                    Tapestry.this.forget(node);
                }
                return null;
            }
        };
        this.runtime.addMessageHandler(Tag.UPDATE_ROUTING_TABLE.getNumber(), handler);
        handler = new MessageHandler(){

            public Message process(Message msg) {
                Tapestry.this.touch(msg.getSource());
                return null;
            }
        };
        this.runtime.addMessageHandler(Tag.NOTIFY_JOINING_NODE.getNumber(), handler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startJoining() {
        Object object = this.joinCompletedLock;
        synchronized (object) {
            if (this.joinStatus == JoinStatus.NOT_YET) {
                this.joinStatus = JoinStatus.JOINING;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void finishJoining() {
        Object object = this.joinCompletedLock;
        synchronized (object) {
            this.joinStatus = JoinStatus.COMPLETED;
            this.joinCompletedLock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForJoinCompletion() {
        Object object = this.joinCompletedLock;
        synchronized (object) {
            if (this.joinStatus == JoinStatus.NOT_YET) {
                this.joinStatus = JoinStatus.COMPLETED;
            }
            if (this.joinStatus != JoinStatus.COMPLETED) {
                try {
                    this.joinCompletedLock.wait(this.config.getWaitingTimeForJoinCompletes());
                }
                catch (InterruptedException e) {
                    logger.log(Level.WARNING, "Interruted when waiting for this node itself completes the join process.", e);
                }
            }
        }
        if (this.joinStatus != JoinStatus.COMPLETED) {
            logger.log(Level.WARNING, "Joining status of " + this.selfIDAddress.getAddress() + " could not become COMPLETED.");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum JoinStatus {
        NOT_YET,
        JOINING,
        COMPLETED;

    }

    private class AcknowledgedMulticastMessageHandler
    implements ExtendedMessageHandler {
        private AcknowledgedMulticastMessageHandler() {
        }

        public Message process(Message msg) {
            if (Tapestry.this.config.getReturnAckInAcknowledgedMulticast()) {
                return Tapestry.this.multicastAckMessage;
            }
            return null;
        }

        public void postProcess(Message msg) {
            Serializable[] contents = msg.getContents();
            ID prefix = (ID)contents[0];
            int prefixLen = (Integer)contents[1];
            IDAddressPair joiningNode = (IDAddressPair)contents[2];
            Tapestry.this.sendAcknowledgedMulticast(prefix, prefixLen, joiningNode);
            Tapestry.this.touch(joiningNode);
            Tapestry.this.touch(msg.getSource());
        }
    }
}

