/*
 * Decompiled with CFR 0.152.
 */
package ow.directory.expiration;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import ow.directory.MultiValueDirectory;
import ow.directory.expiration.AbstractExpiringDirectory;
import ow.directory.expiration.Expirable;
import ow.directory.expiration.ExpiringValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExpiringMultiValueDirectory<K, V>
extends AbstractExpiringDirectory<K, V>
implements MultiValueDirectory<K, V>,
Serializable {
    private MultiValueDirectory<K, ExpiringValue<V>> dir;

    public ExpiringMultiValueDirectory(MultiValueDirectory<K, ExpiringValue<V>> dir, long defaultTTL) {
        super(dir, defaultTTL);
        this.dir = dir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V put(K key, V value, long ttl) throws Exception {
        try {
            ((Expirable)value).setTTL(ttl);
        }
        catch (ClassCastException e) {
            // empty catch block
        }
        ExpiringValue<V> entry = new ExpiringValue<V>(value, ttl);
        long expiringTime = entry.getExpiringTime();
        ExpiringMultiValueDirectory expiringMultiValueDirectory = this;
        synchronized (expiringMultiValueDirectory) {
            entry = this.dir.put(key, entry);
            super.initExpiringTask(expiringTime + 100L);
        }
        V ret = null;
        if (entry != null) {
            ret = entry.getValue();
            ttl = (int)(entry.getExpiringTime() - System.currentTimeMillis());
            if (ttl < 0L) {
                ttl = 0L;
            }
            try {
                ((Expirable)ret).setTTL(ttl);
            }
            catch (ClassCastException e) {
                // empty catch block
            }
        }
        return ret;
    }

    @Override
    public V put(K key, V value) throws Exception {
        long ttl = 0L;
        try {
            ttl = ((Expirable)value).getTTL();
        }
        catch (ClassCastException e) {
            // empty catch block
        }
        if (ttl <= 0L) {
            ttl = this.defaultTTL;
        }
        return this.put(key, value, ttl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<V> getAndRemove(K key, boolean remove) throws Exception {
        Set<ExpiringValue<V>> c;
        if (remove) {
            ExpiringMultiValueDirectory expiringMultiValueDirectory = this;
            synchronized (expiringMultiValueDirectory) {
                c = this.dir.remove(key);
                if (this.dir.isEmpty()) {
                    super.stopExpiringTask();
                }
            }
        } else {
            c = this.dir.get(key);
        }
        HashSet<V> ret = null;
        if (c != null) {
            ret = new HashSet<V>();
            long curTime = System.currentTimeMillis();
            for (ExpiringValue<V> entry : c) {
                V v = entry.getValue();
                int ttl = (int)(entry.getExpiringTime() - curTime);
                if ((long)ttl < 0L) {
                    ttl = 0;
                }
                try {
                    ((Expirable)v).setTTL(ttl);
                }
                catch (ClassCastException e) {
                    // empty catch block
                }
                ret.add(v);
            }
        }
        return ret;
    }

    @Override
    public Set<V> get(K key) throws Exception {
        return this.getAndRemove(key, false);
    }

    @Override
    public Set<V> remove(K key) throws Exception {
        return this.getAndRemove(key, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V remove(K key, V value) throws Exception {
        ExpiringValue<V> entry = new ExpiringValue<V>(value, this.defaultTTL);
        ExpiringMultiValueDirectory expiringMultiValueDirectory = this;
        synchronized (expiringMultiValueDirectory) {
            entry = this.dir.remove(key, entry);
            if (this.dir.isEmpty()) {
                super.stopExpiringTask();
            }
        }
        V ret = null;
        if (entry != null) {
            ret = entry.getValue();
            int ttl = (int)(entry.getExpiringTime() - System.currentTimeMillis());
            if (ttl < 0) {
                ttl = 0;
            }
            try {
                ((Expirable)ret).setTTL(ttl);
            }
            catch (ClassCastException e) {
                // empty catch block
            }
        }
        return ret;
    }

    @Override
    public boolean isEmpty() {
        return this.dir.isEmpty();
    }

    @Override
    public Set<K> keySet() {
        return this.dir.keySet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        ExpiringMultiValueDirectory expiringMultiValueDirectory = this;
        synchronized (expiringMultiValueDirectory) {
            super.stopExpiringTask();
            this.dir.clear();
        }
    }

    @Override
    public void close() {
        super.close();
        this.dir.close();
    }
}

