/*
 * Decompiled with CFR 0.152.
 */
package ow.tool.dhtshell.commands;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import ow.dht.ByteArray;
import ow.dht.DHT;
import ow.dht.ValueInfo;
import ow.id.ID;
import ow.id.IDUtility;
import ow.tool.util.shellframework.Command;
import ow.tool.util.shellframework.CommandUtil;
import ow.tool.util.shellframework.ShellContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class GetCommand
implements Command<DHT<String>> {
    private static final String[] NAMES = new String[]{"get"};

    @Override
    public String[] getNames() {
        return NAMES;
    }

    @Override
    public String getHelp() {
        return "get [-status] <key> [<key> ...]";
    }

    @Override
    public boolean execute(ShellContext<DHT<String>> context) {
        DHT<String> dht = context.getOpaqueData();
        PrintStream out = context.getOutputStream();
        String[] args = context.getArguments();
        boolean showStatus = false;
        int argIndex = 0;
        if (argIndex < args.length && args[argIndex].startsWith("-")) {
            showStatus = true;
            ++argIndex;
        }
        if (argIndex >= args.length) {
            out.print("usage: " + this.getHelp() + "\r\n");
            out.flush();
            return false;
        }
        ConcurrentLinkedQueue<ID> requestQueue = new ConcurrentLinkedQueue<ID>();
        ArrayList<String> keyList = new ArrayList<String>();
        while (argIndex < args.length) {
            ID key = IDUtility.parseID(args[argIndex], dht.getRoutingAlgorithmConfiguration().getIDSizeInByte());
            keyList.add(args[argIndex]);
            requestQueue.offer(key);
            ++argIndex;
        }
        ID[] keys = new ID[requestQueue.size()];
        for (int i = 0; i < keys.length; ++i) {
            keys[i] = (ID)requestQueue.poll();
        }
        Set<ValueInfo<String>>[] values = dht.get(keys);
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < keys.length; ++i) {
            ID key = keys[i];
            sb.append("key:   ").append(key).append("\r\n");
            if (values[i] != null) {
                if (!values[i].isEmpty()) {
                    for (ValueInfo<String> v : values[i]) {
                        sb.append("value: ").append(v.getValue()).append(" ").append(v.getTTL() / 1000L);
                        ByteArray secret = v.getHashedSecret();
                        if (secret != null) {
                            sb.append(" ").append(secret);
                        }
                        sb.append("\r\n");
                    }
                    continue;
                }
                sb.append("value:").append("\r\n");
                continue;
            }
            sb.append("routing failed: ").append((String)keyList.get(i)).append("\r\n");
        }
        if (showStatus) {
            sb.append((CharSequence)CommandUtil.buildStatusMessage(context.getOpaqueData(), -1));
        }
        out.print(sb);
        out.flush();
        return false;
    }
}

