/*
 * Decompiled with CFR 0.152.
 */
package mx4j.tools.adaptor.http;

import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.management.JMException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanConstructorInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.ObjectName;
import javax.management.modelmbean.ModelMBeanInfo;
import mx4j.tools.adaptor.http.CommandProcessorUtil;
import mx4j.tools.adaptor.http.HttpCommandProcessorAdaptor;
import mx4j.tools.adaptor.http.HttpInputStream;
import mx4j.tools.adaptor.http.HttpUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class MBeanCommandProcessor
extends HttpCommandProcessorAdaptor {
    public Document executeRequest(HttpInputStream in) throws IOException, JMException {
        Document document = this.builder.newDocument();
        String name = in.getVariable("objectname");
        ObjectName objectName = null;
        if (name != null) {
            objectName = new ObjectName(name);
            if (!objectName.isPattern()) {
                if (this.server.isRegistered(objectName)) {
                    Element mb = this.createMBeanElement(document, objectName, in);
                    document.appendChild(mb);
                }
            } else {
                TreeSet<ObjectName> names = new TreeSet<ObjectName>(CommandProcessorUtil.createObjectNameComparator());
                names.addAll(this.server.queryNames(objectName, null));
                Element root = document.createElement("Server");
                root.setAttribute("pattern", objectName.toString());
                Iterator it = names.iterator();
                while (it.hasNext()) {
                    Element mb = this.createMBeanElement(document, (ObjectName)it.next(), in);
                    root.appendChild(mb);
                }
                document.appendChild(root);
            }
        }
        return document;
    }

    private Element createMBeanElement(Document document, ObjectName objectName, HttpInputStream in) throws JMException {
        MBeanNotificationInfo[] notifications;
        MBeanOperationInfo[] operations;
        MBeanConstructorInfo[] constructors;
        MBeanAttributeInfo[] attributes;
        Element root = document.createElement("MBean");
        MBeanInfo info = this.server.getMBeanInfo(objectName);
        root.setAttribute("description", info.getDescription());
        root.setAttribute("classname", info.getClassName());
        root.setAttribute("objectname", objectName.toString());
        if (info instanceof ModelMBeanInfo) {
            root.setAttribute("model", "true");
        }
        if (HttpUtil.booleanVariableValue(in, "attributes", true) && (attributes = info.getAttributes()) != null) {
            TreeMap<String, Element> sortedAttributes = new TreeMap<String, Element>();
            for (int i = 0; i < attributes.length; ++i) {
                Element attribute = document.createElement("Attribute");
                attribute.setAttribute("name", attributes[i].getName());
                attribute.setAttribute("type", attributes[i].getType());
                attribute.setAttribute("description", attributes[i].getDescription());
                attribute.setAttribute("strinit", String.valueOf(CommandProcessorUtil.canCreateParameterValue(attributes[i].getType())));
                if (attributes[i].isReadable() && attributes[i].isWritable()) {
                    attribute.setAttribute("availability", "RW");
                }
                if (attributes[i].isReadable() && !attributes[i].isWritable()) {
                    attribute.setAttribute("availability", "RO");
                }
                if (!attributes[i].isReadable() && attributes[i].isWritable()) {
                    attribute.setAttribute("availability", "WO");
                }
                try {
                    Object attributeValue = this.server.getAttribute(objectName, attributes[i].getName());
                    attribute.setAttribute("isnull", attributeValue == null ? "true" : "false");
                    if (attributeValue != null) {
                        attribute.setAttribute("value", attributeValue.toString());
                        if (attributeValue.getClass().isArray()) {
                            attribute.setAttribute("aggregation", "array");
                        }
                        if (attributeValue instanceof Collection) {
                            attribute.setAttribute("aggregation", "collection");
                        }
                        if (attributeValue instanceof Map) {
                            attribute.setAttribute("aggregation", "map");
                        }
                    } else {
                        attribute.setAttribute("value", "null");
                    }
                }
                catch (JMException e) {
                    attribute.setAttribute("value", e.getMessage());
                }
                sortedAttributes.put(attributes[i].getName(), attribute);
            }
            Iterator keys = sortedAttributes.keySet().iterator();
            while (keys.hasNext()) {
                root.appendChild((Element)sortedAttributes.get(keys.next()));
            }
        }
        if (HttpUtil.booleanVariableValue(in, "constructors", true) && (constructors = info.getConstructors()) != null) {
            for (int i = 0; i < constructors.length; ++i) {
                Element constructor = document.createElement("Constructor");
                constructor.setAttribute("name", constructors[i].getName());
                constructor.setAttribute("description", constructors[i].getDescription());
                this.addParameters(constructor, document, constructors[i].getSignature());
                root.appendChild(constructor);
            }
        }
        if (HttpUtil.booleanVariableValue(in, "operations", true) && (operations = info.getOperations()) != null) {
            for (int i = 0; i < operations.length; ++i) {
                Element operation = document.createElement("Operation");
                operation.setAttribute("name", operations[i].getName());
                operation.setAttribute("description", operations[i].getDescription());
                operation.setAttribute("return", operations[i].getReturnType());
                switch (operations[i].getImpact()) {
                    case 3: {
                        operation.setAttribute("impact", "unknown");
                        break;
                    }
                    case 1: {
                        operation.setAttribute("impact", "action");
                        break;
                    }
                    case 0: {
                        operation.setAttribute("impact", "info");
                        break;
                    }
                    case 2: {
                        operation.setAttribute("impact", "action_info");
                    }
                }
                this.addParameters(operation, document, operations[i].getSignature());
                root.appendChild(operation);
            }
        }
        if (HttpUtil.booleanVariableValue(in, "notifications", true) && (notifications = info.getNotifications()) != null) {
            for (int i = 0; i < notifications.length; ++i) {
                Element notification = document.createElement("Notification");
                notification.setAttribute("name", notifications[i].getName());
                notification.setAttribute("description", notifications[i].getDescription());
                String[] types = notifications[i].getNotifTypes();
                for (int j = 0; j < types.length; ++j) {
                    Element type = document.createElement("Type");
                    type.setAttribute("name", types[j]);
                    notification.appendChild(type);
                }
                root.appendChild(notification);
            }
        }
        return root;
    }

    protected void addParameters(Element node, Document document, MBeanParameterInfo[] parameters) {
        for (int j = 0; j < parameters.length; ++j) {
            Element parameter = document.createElement("Parameter");
            parameter.setAttribute("name", parameters[j].getName());
            parameter.setAttribute("description", parameters[j].getDescription());
            parameter.setAttribute("type", parameters[j].getType());
            parameter.setAttribute("strinit", String.valueOf(CommandProcessorUtil.canCreateParameterValue(parameters[j].getType())));
            parameter.setAttribute("id", "" + j);
            node.appendChild(parameter);
        }
    }
}

