/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.utilint;

import com.sleepycat.bind.tuple.LongBinding;
import com.sleepycat.bind.tuple.TupleBinding;
import com.sleepycat.bind.tuple.TupleInput;
import com.sleepycat.bind.tuple.TupleOutput;
import com.sleepycat.je.Database;
import com.sleepycat.je.DatabaseEntry;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.OperationStatus;
import com.sleepycat.je.log.LogEntryType;
import com.sleepycat.je.utilint.DbLsn;
import com.sleepycat.je.utilint.VLSN;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileMapper {
    private long fileNumber;
    private VLSN lastSyncVLSN;
    private VLSN lastCommitVLSN;
    private Map<Long, Long> vlsnToFileOffsetMap;
    private boolean dirty;

    public FileMapper(long fileNumber) {
        this.fileNumber = fileNumber;
        this.vlsnToFileOffsetMap = new HashMap<Long, Long>();
        this.lastSyncVLSN = VLSN.NULL_VLSN;
        this.lastCommitVLSN = VLSN.NULL_VLSN;
    }

    private FileMapper() {
    }

    public void setFileNumber(long fileNumber) {
        this.fileNumber = fileNumber;
    }

    public long getFileNumber() {
        return this.fileNumber;
    }

    public VLSN getLastSyncVLSN() {
        return this.lastSyncVLSN;
    }

    public VLSN getLastCommitVLSN() {
        return this.lastCommitVLSN;
    }

    public void writeToDatabase(Database fileMapperDb) throws DatabaseException {
        if (this.dirty) {
            DatabaseEntry key = new DatabaseEntry();
            DatabaseEntry data = new DatabaseEntry();
            LongBinding.longToEntry(this.fileNumber, key);
            FileMapperBinding mapperBinding = new FileMapperBinding();
            mapperBinding.objectToEntry(this, data);
            OperationStatus status = fileMapperDb.put(null, key, data);
            if (status != OperationStatus.SUCCESS) {
                throw new DatabaseException("Unable to write VLSN mapping  for file " + this.fileNumber + " status=" + status);
            }
            this.dirty = false;
        }
    }

    public static FileMapper readFromDatabase(DatabaseEntry data) {
        FileMapperBinding mapperBinding = new FileMapperBinding();
        FileMapper mapper = (FileMapper)mapperBinding.entryToObject(data);
        return mapper;
    }

    public void putLSN(long vlsn, long lsn, LogEntryType entryType) {
        VLSN thisVLSN;
        assert (DbLsn.getFileNumber(lsn) == this.fileNumber) : "unexpected lsn file num=" + DbLsn.getFileNumber(lsn) + " while file mapper file number=" + this.fileNumber;
        this.vlsnToFileOffsetMap.put(vlsn, DbLsn.getFileOffset(lsn));
        if (entryType.isSyncPoint() && this.lastSyncVLSN.compareTo(thisVLSN = new VLSN(vlsn)) < 0) {
            this.lastSyncVLSN = thisVLSN;
        }
        if (LogEntryType.LOG_TXN_COMMIT.equals(entryType) && this.lastCommitVLSN.compareTo(thisVLSN = new VLSN(vlsn)) < 0) {
            this.lastCommitVLSN = thisVLSN;
        }
        this.dirty = true;
    }

    public void putAll(FileMapper other) {
        assert (other.fileNumber == this.fileNumber) : "bad file number = " + other.fileNumber;
        this.vlsnToFileOffsetMap.putAll(other.vlsnToFileOffsetMap);
        if (this.lastSyncVLSN.compareTo(other.lastSyncVLSN) < 0) {
            this.lastSyncVLSN = other.lastSyncVLSN;
        }
        if (this.lastCommitVLSN.compareTo(other.lastCommitVLSN) < 0) {
            this.lastCommitVLSN = other.lastCommitVLSN;
        }
        this.dirty = true;
    }

    public long getLSN(long vlsn) {
        return DbLsn.makeLsn(this.fileNumber, this.vlsnToFileOffsetMap.get(vlsn));
    }

    public void removeLSN(long vlsn) {
        this.vlsnToFileOffsetMap.remove(vlsn);
        this.dirty = true;
    }

    public Set<Long> getVLSNs() {
        return this.vlsnToFileOffsetMap.keySet();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("<FileMapper fileNumber=");
        sb.append(this.fileNumber).append(" ");
        sb.append(" lastSync=").append(this.lastSyncVLSN).append(" ");
        sb.append(" lastCommit=").append(this.lastCommitVLSN).append(" ");
        sb.append(this.vlsnToFileOffsetMap);
        sb.append("/>");
        return sb.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class FileMapperBinding
    extends TupleBinding<FileMapper> {
        private FileMapperBinding() {
        }

        @Override
        public FileMapper entryToObject(TupleInput ti) {
            FileMapper mapper = new FileMapper();
            mapper.lastSyncVLSN = new VLSN(ti.readPackedLong());
            mapper.lastCommitVLSN = new VLSN(ti.readPackedLong());
            mapper.vlsnToFileOffsetMap = new HashMap();
            int nEntries = ti.readInt();
            for (int i = 0; i < nEntries; ++i) {
                long vlsnSeq = ti.readLong();
                long fileOffset = ti.readUnsignedInt();
                mapper.vlsnToFileOffsetMap.put(vlsnSeq, fileOffset);
            }
            return mapper;
        }

        @Override
        public void objectToEntry(FileMapper mapper, TupleOutput to) {
            to.writePackedLong(mapper.lastSyncVLSN.getSequence());
            to.writePackedLong(mapper.lastCommitVLSN.getSequence());
            int nEntries = mapper.vlsnToFileOffsetMap.size();
            to.writeInt(nEntries);
            for (Map.Entry entry : mapper.vlsnToFileOffsetMap.entrySet()) {
                to.writeLong((Long)entry.getKey());
                to.writeUnsignedInt((Long)entry.getValue());
            }
        }
    }
}

