/*
 * Decompiled with CFR 0.152.
 */
package org.h2.expression;

import java.sql.SQLException;
import org.h2.command.Parser;
import org.h2.engine.Session;
import org.h2.expression.Expression;
import org.h2.expression.ExpressionVisitor;
import org.h2.message.Message;
import org.h2.table.ColumnResolver;
import org.h2.table.TableFilter;
import org.h2.value.Value;

public class Variable
extends Expression {
    private final String name;
    private Value lastValue;

    public Variable(Session session, String name) {
        this.name = name;
        this.lastValue = session.getVariable(name);
    }

    public int getCost() {
        return 0;
    }

    public int getDisplaySize() {
        return this.lastValue.getDisplaySize();
    }

    public long getPrecision() {
        return this.lastValue.getPrecision();
    }

    public String getSQL() {
        return "@" + Parser.quoteIdentifier(this.name);
    }

    public int getScale() {
        return this.lastValue.getScale();
    }

    public int getType() {
        return this.lastValue.getType();
    }

    public Value getValue(Session session) throws SQLException {
        this.lastValue = session.getVariable(this.name);
        return this.lastValue;
    }

    public boolean isEverything(ExpressionVisitor visitor) {
        switch (visitor.type) {
            case 1: {
                return true;
            }
            case 2: {
                return false;
            }
            case 5: {
                return true;
            }
            case 0: {
                return true;
            }
            case 3: {
                return true;
            }
            case 4: {
                return true;
            }
            case 6: {
                return true;
            }
            case 7: {
                return true;
            }
        }
        throw Message.getInternalError("type=" + visitor.type);
    }

    public void mapColumns(ColumnResolver resolver, int level) throws SQLException {
    }

    public Expression optimize(Session session) throws SQLException {
        return this;
    }

    public void setEvaluatable(TableFilter tableFilter, boolean value) {
    }

    public void updateAggregate(Session session) throws SQLException {
    }

    public String getName() {
        return this.name;
    }
}

