package org.positrium.ui.chikarawo;

import java.awt.PopupMenu;
import java.awt.Toolkit;
import java.awt.TrayIcon;
import java.io.FileNotFoundException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.positrium.ui.FileResource;

/**
 * append Genkidama controller to System Tray
 * 
 * @author token , 2009 CC BY-SA
 * @version $Rev: 210 $
 * 
 */

public class MyTrayIcon extends TrayIcon implements StateChangeListener {
	public static Log logger = LogFactory.getLog(MyTrayIcon.class);

	public MyTrayIcon(String tooltip, PopupMenu popup)
			throws FileNotFoundException {
		// TASK: FileResourceɈˑȂ`Ń\[XĂяo
		super(Toolkit.getDefaultToolkit().getImage(
				new FileResource("genkidama_initial.png").toPath()), tooltip,
				popup);
	}

	@Deprecated
	@Override
	/*
	 * @author token Cxg͎gĂȂDeprecatedwɂĂB<br/> genkidama ver 0.3.2
	 */
	public void serverStateChanged(StateChangeEvent e) {
		try{
		switch (e.getStatus()) {
		case INITIAL:
			super.setImage(Toolkit.getDefaultToolkit().getImage(
					new FileResource("resource/genkidama_initial.png").toURL()));
			logger.info("tray icon initial");
		case START:
			super.setImage(Toolkit.getDefaultToolkit()
					.getImage(
							new FileResource("resource/genkidama_begin.png")
									.toURL()));
			logger.info("tray icon begin");
		}
		}catch(FileNotFoundException ex){
			logger.fatal(ex);
		}
	}
}
