/*
 * Copyright (C) 2011 OgakiSoft
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package ogakisoft.android.gestureime;

import android.text.InputFilter;
import android.text.Spanned;
import android.text.TextUtils;

/**
 * Filter for EditTextPreference, accept only numeric(digit) string
 * 
 * @author noritoshi ogaki
 * @version 1.0
 */
public class DigitInputFilter implements InputFilter {
	@Override
	public CharSequence filter(CharSequence source, int start, int end,
			Spanned dest, int dstart, int dend) {
		String str = null; // null means 'keep original input string'
		int pos = -1;
		final String allow = "1234567890.";
		char[] buf = new char[end - start];
		TextUtils.getChars(source, start, end, buf, 0);
		final int count = buf.length;
		for (int i = 0; i < count; i++) {
			if (allow.indexOf(buf[i]) < 0) {
				pos = i;
				break;
			}
		}
		if (pos > 0) {
			buf = new char[pos - start];
			TextUtils.getChars(source, start, pos, buf, 0);
			str = new String(buf);
		} else if (0 == pos) {
			str = "";
		}
		return str;
	}
}
