/*
 * Copyright (C) 2011 OgakiSoft
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package ogakisoft.android.gestureime;

import ogakisoft.android.gestureime.R;
import android.app.Activity;
import android.os.Bundle;
import android.view.View;
import android.widget.TextView;

/**
 * Show version and copyright
 * 
 * @version 1.0
 * @author noritoshi ogaki
 */
public class VersionActivity extends Activity {
	/** LOG tag */
//	private static final String TAG = "VersionActivity";

	public void onClickCloseButton(View v) {
		finish();
	}

	@Override
	public void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);
		setContentView(R.layout.version_activity);
		
		String xmltext = getResources().getString(R.string.version);
		String text = xmltext.replaceAll("@", "\n");

		TextView view = (TextView) findViewById(R.id.version_text);
		view.setText(text);
	}
}
