package ogakisoft.gesture.tools;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

import ogakisoft.util.LOG;

public class MergeData {
	private static final String TAG = "MergeData";
	private static final String[] source_file = {
			"/Users/ogakinoritoshi/Documents/temp/gestureime/gesture_data.1",
			"/Users/ogakinoritoshi/Documents/temp/gestureime/gesture_data.2",
			"/Users/ogakinoritoshi/Documents/temp/gestureime/gesture_data.3",
			"/Users/ogakinoritoshi/Documents/temp/gestureime/gesture_data.4" };
	private static final String dest_file = "gesture_data.all";
	private static final String file_dir = "/Users/ogakinoritoshi/Documents/temp/";
	private static Comparator<GestureHolder.Entry> mSorter = new Comparator<GestureHolder.Entry>() {
		public int compare(GestureHolder.Entry object1,
				GestureHolder.Entry object2) {
			int result = 0;
			// int s1 = object1.gestures.size();
			// int s2 = object2.gestures.size();
			// if (s1 < s2)
			// result = 1;
			// else if (s1 > s2)
			// result = -1;
			// else if (s1 == s2)
			result = object1.entryName.compareTo(object2.entryName);
			return result;
		}
	};

	public static void main(String[] args) {
		LoadGesture load = new LoadGesture();
		SaveGesture save = new SaveGesture();
		FileInputStream fi = null;
		FileOutputStream fo = null;
		GestureHolder holder = null;
		List<GestureHolder.Entry> entries = null;
		GestureHolder result_holder = new GestureHolder();
		int count = 0;
		int count_entries = 0;
		try {
			count = source_file.length;
			for (int i = 0; i < count; i++) {
				holder = new GestureHolder();
				fi = new FileInputStream(new File(source_file[i]));
				load.load(fi, holder);
				entries = holder.getEntries();
				count_entries = entries.size();
				for (int j = 0; j < count_entries; j++) {
					result_holder.addEntry(entries.get(j));
				}
			}
			Collections.sort(entries, mSorter);
			fo = new FileOutputStream(new File(file_dir, dest_file));
			save.save(fo, result_holder);
			LOG.d(TAG, "total count={0,number,#}", result_holder.getEntries()
					.size());
		} catch (Exception e) {
			e.printStackTrace();
		} finally {
			try {
				if (null != fi)
					fi.close();
				if (null != fo)
					fo.close();
			} catch (IOException e) {
				e.printStackTrace();
			}
		}
	}

}
