package ogakisoft.gesture.tools;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

import ogakisoft.util.LOG;

public class CompactData {
	private static final String TAG = "CompactData";
	private static final String source_file = "/Users/ogakinoritoshi/Documents/temp/gesture_data.all";
	private static final String dest_file = "/Users/ogakinoritoshi/Documents/temp/gesture_data.compact";
	private static final int GESTURE_WIDTH = 200;
	private static final int GESTURE_HEIGHT = 200;

	public static void main(String[] args) {
		LoadGesture load = new LoadGesture();
		SaveGesture save = new SaveGesture();
		FileInputStream fi = null;
		FileOutputStream fo = null;
		final GestureHolder holder = new GestureHolder();
		GestureHolder result_holder = new GestureHolder();
		final List<GestureHolder.Entry> entries;
		GestureHolder.Entry entry;
		try {
			fi = new FileInputStream(new File(source_file));
			load.load(fi, holder);

			entries = holder.getEntries();
			int count = entries.size();
			fo = new FileOutputStream(new File(dest_file));

			for (int i = 0; i < count; i++) {
				entry = entries.get(i);
				LOG.d(TAG, "label={0}", entry.entryName);
				compact(entry);
				result_holder.addEntry(entry);
			}
			save.save(fo, result_holder);

		} catch (Exception e) {
			e.printStackTrace();
		} finally {
			try {
				if (null != fi)
					fi.close();
				if (null != fo)
					fo.close();
			} catch (IOException e) {
				e.printStackTrace();
			}
		}
	}

	private static void compact(GestureHolder.Entry entry) {
		GestureHolder.Gesture gesture;
		GestureHolder.Stroke stroke;
		GestureHolder.Point point;
		int count_gestures = 0;
		int count_strokes = 0;
		int count_points = 0;
		count_gestures = entry.gestures.size();
		// scaling
		for (int i = 0; i < count_gestures; i++) {
			gesture = entry.gestures.get(i);
			float[] box = computeMinimumBoundingBox(GestureHolder
					.toArray(getAllStroke(gesture).points));
			float minx = box[0];
			float miny = box[1];
			float maxx = box[2];
			float maxy = box[3];
			float zoomX = GESTURE_WIDTH / maxx;
			float zoomY = GESTURE_HEIGHT / maxy;
			count_strokes = gesture.strokes.size();
			float x, y;
			for (int j = 0; j < count_strokes; j++) {
				stroke = gesture.strokes.get(j);
				count_points = stroke.points.size();
				for (int k = 0; k < count_points; k++) {
					point = stroke.points.get(k);
					x = point.x;
					y = point.y;
					point.x *= zoomX;
					point.y *= zoomY;
					if (point.x < 0 || point.y < 0) {
						LOG.e(TAG, "scale before point.x={0,number,#}, point.y={1,number,#}",x, y);
						LOG.e(TAG, "scale after point.x={0,number,#}, point.y={1,number,#}",point.x,point.y);
					}
					if ((int)point.x > GESTURE_WIDTH || (int)point.y > GESTURE_HEIGHT) {
						LOG.e(TAG, "scale before point.x={0,number,#}, point.y={1,number,#}",x, y);
						LOG.e(TAG, "scale after point.x={0,number,#}, point.y={1,number,#}",point.x,point.y);
					}
				}
				stroke.numberOfPoints = stroke.points.size();
			}
			gesture.numberOfStrokes = gesture.strokes.size();
		}
		// centering
		for (int i = 0; i < count_gestures; i++) {
			gesture = entry.gestures.get(i);
			float[] box = computeMinimumBoundingBox(GestureHolder
					.toArray(getAllStroke(gesture).points));
			float minx = box[0];
			float miny = box[1];
			float maxx = box[2];
			float maxy = box[3];
			float shiftX = (GESTURE_WIDTH - maxx - minx) / 2;
			float shiftY = (GESTURE_HEIGHT - maxy - miny) / 2;
			shiftX = (shiftX < 0) ? 0 : shiftX;
			shiftY = (shiftY < 0) ? 0 : shiftY;
			LOG.d(TAG, "centering: shiftX={0,number,#},shiftY={1,number,#}",
					shiftX, shiftY);
			count_strokes = gesture.strokes.size();
			float x, y;
			for (int j = 0; j < count_strokes; j++) {
				stroke = gesture.strokes.get(j);
				count_points = stroke.points.size();
				for (int k = 0; k < count_points; k++) {
					point = stroke.points.get(k);
					x = point.x;
					y = point.y;
					point.x += shiftX;
					point.y += shiftY;
					if (point.x < 0 || point.y < 0) {
						LOG.e(TAG, "shift before point.x={0,number,#}, point.y={1,number,#}",x, y);
						LOG.e(TAG, "shift after point.x={0,number,#}, point.y={1,number,#}",point.x,point.y);
					}
				}
				stroke.numberOfPoints = stroke.points.size();
			}
			gesture.numberOfStrokes = gesture.strokes.size();
		}
		entry.numberOfGestures = entry.gestures.size();
	}

	
	private static GestureHolder.Stroke getAllStroke(
			GestureHolder.Gesture gesture) {
		final List<GestureHolder.Point> points = new ArrayList<GestureHolder.Point>();
		if (null != gesture && null != gesture.strokes) {
			final List<GestureHolder.Stroke> strokes = gesture.strokes;
			final int strokes_count = strokes.size();
			int points_count = 0;
			GestureHolder.Stroke stroke = null;
			for (int index = 0; index < strokes_count; index++) {
				stroke = strokes.get(index);
				points_count = stroke.points.size();
				for (int i = 0; i < points_count; i++) {
					points.add(stroke.points.get(i));
				}
			}
		}
		GestureHolder holder = new GestureHolder();
		return holder.new Stroke(points);
	}

	private static float[] computeMinimumBoundingBox(float[] points) {
		float minx = Float.MAX_VALUE;
		float miny = Float.MAX_VALUE;
		float maxx = Float.MIN_VALUE;
		float maxy = Float.MIN_VALUE;
		int count = points.length;
		for (int i = 0; i < count; i++) {
			minx = Math.min(minx, points[i]);
			maxx = Math.max(maxx, points[i]);
			i++;
			miny = Math.min(miny, points[i]);
			maxy = Math.max(maxy, points[i]);
		}
		float[] results = { minx, miny, maxx, maxy };
		return results;
	}

	/*
	 * private static boolean computeStraightness(List<GestureHolder.Point>
	 * points) { boolean changed = false; int count = points.size();
	 * List<GestureHolder.Point> result = new ArrayList<GestureHolder.Point>();
	 * double inc1 = 0f; double inc2 = 0f; GestureHolder.Point p1, p2, p3; if
	 * (count > 3) { for (int i = 0; i < count; i += 2) { if (i >= count - 3) {
	 * for (int j = i; j < count; j++) { result.add(points.get(j)); } break; }
	 * p1 = points.get(i); p2 = points.get(i + 1); p3 = points.get(i + 2); inc1
	 * = computeIncline(p1.x, p1.y, p2.x, p2.y); inc2 = computeIncline(p1.x,
	 * p1.y, p3.x, p3.y); if (inc1 - inc2 == 0) { LOG.d(TAG,
	 * "remove middle point ({0,number,#.#},{1,number,#.#})," +
	 * "({2,number,#.#},{3,number,#.#})," + "({4,number,#.#},{5,number,#.#})",
	 * p1.x, p1.y, p2.x, p2.y, p3.x, p3.y); result.add(p1); changed = true; }
	 * else { result.add(p1); result.add(p2); } } }
	 * 
	 * synchronized (points) { points.clear(); points.addAll(result); } return
	 * changed; }
	 * 
	 * private static double computeIncline(float x1, float y1, float x2, float
	 * y2) { final float dx = x2 - x1; final float dy = y2 - y1; return dy / dx;
	 * }
	 */
}
