package ogakisoft.gesture.tools;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;

import ogakisoft.gesture.tools.GestureHolder.Entry;
import ogakisoft.gesture.tools.GestureHolder.Gesture;
import ogakisoft.gesture.tools.GestureHolder.Header;
import ogakisoft.gesture.tools.GestureHolder.Stroke;
import ogakisoft.util.LOG;

public class LoadGesture {
	private static final String TAG = "LoadGesture";
	private static String[] mFilter;
	private static final String filter_file = "/Users/ogakinoritoshi/Documents/workspace/GestureIME_utils/raw/jyouyokanji.txt";

	public void load(InputStream stream, GestureHolder holder)
			throws IOException {
		DataInputStream in = null;
		try {
			in = new DataInputStream(new BufferedInputStream(stream, 32 * 1024));
			final short versionNumber = in.readShort();
			switch (versionNumber) {
			case 1:
				readFormatV1(in, holder);
				break;
			}
		} finally {
			try {
				stream.close();
			} catch (IOException e) {
				e.printStackTrace();
			}
		}
	}

	private void readFormatV1(DataInputStream in, GestureHolder holder)
			throws IOException {
		final int count_entries = in.readInt();
		int count_gestures;
		int count_strokes;
		int count_points;
		String name;
		long gesture_id;
		float x;
		float y;
		long timestamp;
		Header header = holder.new Header();
		Entry entry;
		Gesture gesture;
		Stroke stroke;
		LOG.d(TAG, "Number of entries:{0,number,#}", count_entries);
		boolean skip = false;
		for (int i = 0; i < count_entries; i++) {
			name = in.readUTF();
			if (!existFilter(name))
				skip = true;
			else
				skip = false;
			entry = null;
			if (!skip) {
				LOG.d(TAG, "Entry name:{0}", name);
				entry = holder.new Entry(name);
			}
			count_gestures = in.readInt();
			// LOG.d(TAG, "Number of gestures:{0,number,#}", count_gestures);
			for (int j = 0; j < count_gestures; j++) {
				gesture_id = in.readLong();
				// LOG.d(TAG, "gesture id:{0,number,#}", gesture_id);
				gesture = null;
				if (!skip) {
					gesture = holder.new Gesture();
					gesture.setId(gesture_id);
				}
				count_strokes = in.readInt();
				// LOG.d(TAG, "Number of strokes:{0,number,#}", count_strokes);
				for (int k = 0; k < count_strokes; k++) {
					count_points = in.readInt();
					// LOG.d(TAG, "Number of points:{0,number,#}",
					// count_points);
					stroke = null;
					if (!skip) {
						stroke = holder.new Stroke();
					}
					for (int m = 0; m < count_points; m++) {
						x = in.readFloat();
						y = in.readFloat();
						timestamp = in.readLong();
						// LOG.d(TAG,
						// "x={0,number,#}, y={1,number,#}, timestamp={2,number,#}",
						// x, y, timestamp);
						if (!skip) {
							stroke.add(holder.new Point(x, y, timestamp));
						}
					}
					if (!skip)
						gesture.add(stroke);
				}
				if (!skip)
					entry.add(gesture);
			}
			if (!skip)
				header.add(entry);
		}
		holder.set(header);
	}

	public void loadFilter() {
		BufferedReader in = null;
		try {
			in = new BufferedReader(new InputStreamReader(new FileInputStream(
					filter_file), Charset.forName("UTF-8")));
			int count = -1;
			String str;
			while ((str = in.readLine()) != null) {
				if (count == -1) {
					int n = Integer.parseInt(str);
					mFilter = new String[n];
					count++;
				} else {
					mFilter[count++] = str;
					LOG.d(TAG, "mFilter put {0}", str);
				}
			}
		} catch (IOException e) {
			e.printStackTrace();
		} finally {
			try {
				in.close();
			} catch (IOException e) {
				e.printStackTrace();
			}
		}
	}

	private boolean existFilter(String str) {
		if (null == mFilter) return true;
		int count = mFilter.length;
		for (int i = 0; i < count; i++) {
			if (str.equals(mFilter[i])) {
				return true;
			}
		}
		return false;
	}

}