package ogakisoft.gesture.tools;

import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;

import ogakisoft.gesture.tools.GestureHolder.Entry;
import ogakisoft.gesture.tools.GestureHolder.Gesture;
import ogakisoft.gesture.tools.GestureHolder.Point;
import ogakisoft.gesture.tools.GestureHolder.Stroke;
import ogakisoft.util.LOG;
import ogakisoft.util.Utils;

public class SaveGesture {
	private static final String TAG = "SaveGesture";
//	private static final String input_file = "/Users/ogakinoritoshi/Documents/temp/jyouyokanji.txt";
	private Map<Integer, Long> mId = new HashMap<Integer, Long>();
	private static final int MAX_NUM_OF_INDEX = 100000;

	public void save(OutputStream stream, GestureHolder holder) throws IOException {
		DataOutputStream out = null;
		try {
			out = new DataOutputStream(new BufferedOutputStream(stream,
					32 * 1024));
			final short versionNumber = 1;
			out.writeShort(versionNumber);
			switch (versionNumber) {
			case 1:
				writeFormatV1(out, holder);
				break;
			}
		} finally {
			try {
				out.flush();
				out.close();
			} catch (IOException e) {
				e.printStackTrace();
			}
		}
	}

	private void writeFormatV1(DataOutputStream out, GestureHolder holder)
			throws IOException {
		final List<Entry> entries = holder.getEntries();
		final int count_entries = entries.size(); //.numberOfEntries;
		int count_gestures;
		int count_strokes;
		int count_points;
		String name;
		Gesture g;
		Stroke s;
		Point p;
		float x;
		float y;
		long timestamp;
		out.writeInt(count_entries);
		LOG.d(TAG, "Number of entries:{0,number,#}", count_entries);
		for (int i = 0; i < count_entries; i++) {
			name = entries.get(i).entryName;
			out.writeUTF(name);
			LOG.d(TAG, "Entry name:{0}", name);
			count_gestures = entries.get(i).gestures.size(); //.numberOfGestures;
			out.writeInt(count_gestures);
//			LOG.d(TAG, "Number of gestures:{0,number,#}", count_gestures);
			for (int j = 0; j < count_gestures; j++) {
				g = entries.get(i).gestures.get(j);
				out.writeLong(g.gestureId);
//				LOG.d(TAG, "gesture id:{0,number,#}", g.gestureId);
				count_strokes = g.strokes.size(); //.numberOfStrokes;
				out.writeInt(count_strokes);
//				LOG.d(TAG, "Number of strokes:{0,number,#}", count_strokes);
				for (int k = 0; k < count_strokes; k++) {
					s = g.strokes.get(k);
					count_points = s.points.size(); //.numberOfPoints;
					out.writeInt(count_points);
//					LOG.d(TAG, "Number of points:{0,number,#}", count_points);
					for (int m = 0; m < count_points; m++) {
						p = s.points.get(m);
						x = p.x;
						out.writeFloat(x);
						y = p.y;
						out.writeFloat(y);
						timestamp = p.timeStamp;
						out.writeLong(timestamp);
//						LOG.d(TAG,
//								"x={0,number,#},y={1,number,#},timestamp={2,number,#}",
//								x, y, timestamp);
					}
				}
			}
		}
	}

	public void saveForSvm(GestureHolder holder, File index_file, File data_file) {
		FileOutputStream data = null;
		OutputStreamWriter index = null;
		try {
			data = new FileOutputStream(data_file);
			index = new OutputStreamWriter(new FileOutputStream(index_file),
					Charset.forName("UTF-8"));
			final List<Entry> entries = holder.getEntries();
			final int entries_count = entries.size();
			String str;
			Entry entry;
			Stroke stroke;
			Point point;
			List<Gesture> gestures;
			Gesture gesture;
			List<Stroke> strokes;
			List<Point> points;
			int gestures_count;
			int strokes_count;
			int points_count;
			int count;
			int intId;
			for (int i = 0; i < entries_count; i++) {
				entry = entries.get(i);
				gestures = entry.gestures;
				gestures_count = gestures.size();
				for (int j = 0; j < gestures_count; j++) {
					gesture = gestures.get(j);
					intId = convertId(gesture.gestureId);
					mId.put(Integer.valueOf(intId),
							Long.valueOf(gesture.gestureId));
					// String str = intId + " " + gesture.gestureId + " "
					// + entry.entryName + "\n";
					str = Utils.concat(String.valueOf(intId), " ",
							String.valueOf(gesture.gestureId), " ",
							entry.entryName, "\n");
					index.write(str, 0, str.length());
					data.write(String.valueOf(intId).getBytes());
					data.write(" ".getBytes());
					strokes = gesture.strokes;
					strokes_count = strokes.size();
					count = 0;
					for (int k = 0; k < strokes_count; k++) {
						stroke = strokes.get(k);
						points = stroke.points;
						points_count = points.size();
						for (int l = 0; l < points_count; l++) {
							point = points.get(l);
//							count++;
							// data.write((count + ":" + point.x +
							// " ").getBytes());
							str = Utils.concat(++count, ":", point.x, " ");
							data.write(str.getBytes());
//							count++;
							// data.write((count + ":" + point.y +
							// " ").getBytes());
							str = Utils.concat(++count, ":", point.y, " ");
							data.write(str.getBytes());
						}
					}
					data.write("\n".getBytes());
				}
			}

		} catch (IOException e) {
			e.printStackTrace();
		} finally {
			try {
				if (null != data) {
					data.close();
				}
				if (null != index) {
					index.close();
				}
			} catch (IOException e) {
				e.printStackTrace();
			}
		}
	}

	private int convertId(long id) {
		int intId = -1;
		if (null != mId) {
			intId = containsId(id);
		}
		if (intId == -1) {
			final String str = String.valueOf(id);
			intId = Integer.parseInt(str.substring(str.length() - 5));
			while (mId.containsKey(Integer.valueOf(intId))) {
				intId = randomNumber();
			}
		}
		return intId;
	}

	private int containsId(long id) {
		int intId = -1;
		synchronized (mId) {
			Map.Entry<Integer, Long> entry;
			for (final Iterator<Map.Entry<Integer, Long>> it = mId.entrySet()
					.iterator(); it.hasNext();) {
				entry = it.next();
				if (entry.getValue().longValue() == id) {
					intId = entry.getKey().intValue();
					break;
				}
			}
		}
		return intId;
	}

	private int randomNumber() {
		final Random random = new Random();
		int i = 0;
		do {
			i = random.nextInt();
		} while (i <= 0 || i > MAX_NUM_OF_INDEX);
		return i;
	}
}
