package ogakisoft.tomoe;

import java.util.ArrayList;

public class GestureHolder {

    private ArrayList<Entry> entries;

    public GestureHolder() {
        entries = new ArrayList<Entry>(0);
    }

    public void addEntry(Entry entry) {
        entries.add(entry);
    }

    public String getNameAt(int index) {
        if (index < 0 || index >= entries.size()) {
            return null;
        }
        return entries.get(index).getName();
    }

    public int getEntryListSize() {
        entries.trimToSize();
        return entries.size();
    }

    public int getStrokesListSize(int index) {
        return entries.get(index).getSize();
    }

    public int getStrokeListSize(int index, int strokesIndex) {
        if (index < 0 || index >= getEntryListSize()) {
            return -1;
        }
        if (strokesIndex < 0 || strokesIndex >= getStrokesListSize(index)) {
            return -1;
        }
        int count = 0;
        count = entries.get(index).getStrokes(strokesIndex).getSize();
        return count;
    }

    public int getPointListSize(int index, int strokesIndex, int strokeIndex) {
        if (index < 0 || index >= getEntryListSize()) {
            return -1;
        }
        if (strokesIndex < 0 || strokesIndex >= getStrokesListSize(index)) {
            return -1;
        }
        if (strokeIndex < 0 || strokeIndex >= getStrokeListSize(index,strokesIndex)){
            return -1;
        }
        int count = 0;
        count = entries.get(index).getStrokes(strokesIndex).getStroke(strokeIndex).getSize();
        return count;
    }

    public String getStrokeAt(int index, int strokesIndex, int strokeIndex) {
        if (index < 0 || index >= getEntryListSize()) {
            return null;
        }
        if (strokesIndex < 0 || strokesIndex >= getStrokesListSize(index)) {
            return null;
        }
        if (strokeIndex < 0 || strokeIndex >= getStrokeListSize(index,strokesIndex)){
            return null;
        }
        StringBuffer sb = new StringBuffer();
        sb.append(entries.get(index).getStrokes(strokesIndex).getStroke(strokeIndex).toString());
        return sb.toString();
    }

    public Point getPointAt(int index, int strokesIndex, int strokeIndex, int seq) {
        Point point = null;
        point = entries.get(index).getStrokes(strokesIndex).getStroke(strokeIndex).getPointAt(seq);
        return point;
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < entries.size(); i++) {
            sb.append("/");
            sb.append(entries.get(i).toString());
            sb.append("/");
        }
        return sb.toString();
    }
}
