package ogakisoft.tomoe;

import java.util.ArrayList;

public class Stroke {

    private ArrayList<Point> points;

    public Stroke() {
        points = new ArrayList<Point>(0);
    }

    public void addPoint(int x, int y) {
        points.add(new Point(x, y));
    }

    public Point getPointAt(int index) {
        return points.get(index);
    }

    public int getSize() {
        points.trimToSize();
        return points.size();
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < points.size(); i++) {
            sb.append("(");
            sb.append(points.get(i).toString());
            sb.append(")");
            if (i + 1 < points.size()) {
                sb.append(",");
            }
        }
        return sb.toString();
    }
}
