package ogakisoft.tomoe;

import org.xml.sax.AttributeList;
import org.xml.sax.SAXException;

public class DictHandlerImpl implements DictHandler {
    public static final boolean DEBUG = false;
    public GestureHolder mHolder;
    private Entry mEntry;
    private Strokes mStrokes;
    private Stroke mStroke;
    private String mName;

    public GestureHolder getHolder() {
        return mHolder;
    }

    @Override
    public void handle_reading(final String data, final AttributeList meta) throws SAXException {
//        if (DEBUG) {
//            System.err.println("handle_reading: " + meta);
//        }
    }

    @Override
    public void handle_utf8(final String data, final AttributeList meta) throws SAXException {
//        if (DEBUG) {
//            System.err.println("handle_utf8: " + meta);
//        }
        mName = data;
        mEntry = new Entry(mName);
    }

    @Override
    public void start_dictionary(final AttributeList meta) throws SAXException {
//        if (DEBUG) {
//            System.err.println("start_dictionary: " + meta);
//        }
        mHolder = new GestureHolder();
    }

    @Override
    public void end_dictionary() throws SAXException {
//        if (DEBUG) {
//            System.err.println("end_dictionary()");
//        }
//        System.out.println(mHolder.toString());
    }

    @Override
    public void handle_variant(final String data, final AttributeList meta) throws SAXException {
//        if (DEBUG) {
//            System.err.println("handle_variant: " + meta);
//        }
    }

    @Override
    public void handle_meta(final String data, final AttributeList meta) throws SAXException {
//        if (DEBUG) {
//            System.err.println("handle_meta: " + meta);
//        }
    }

    @Override
    public void start_meta(final AttributeList meta) throws SAXException {
//        if (DEBUG) {
//            System.err.println("start_meta: " + meta);
//        }
    }

    @Override
    public void end_meta() throws SAXException {
//        if (DEBUG) {
//            System.err.println("end_meta()");
//        }
    }

    @Override
    public void start_character(final AttributeList meta) throws SAXException {
//        if (DEBUG) {
//            System.err.println("start_character: " + meta);
//        }
    }

    @Override
    public void end_character() throws SAXException {
//        if (DEBUG) {
//            System.err.println("end_character()");
//        }
        mHolder.addEntry(mEntry);
    }

    @Override
    public void start_stroke(final AttributeList meta) throws SAXException {
//        if (DEBUG) {
//            System.err.println("start_stroke: " + meta);
//        }
        mStroke = new Stroke();
    }

    @Override
    public void end_stroke() throws SAXException {
//        if (DEBUG) {
//            System.err.println("end_stroke()");
//        }
        mStrokes.addStroke(mStroke);
    }

    @Override
    public void handle_point(final AttributeList meta) throws SAXException {
//        if (DEBUG) {
//            System.err.println("handle_point: " + meta);
//        }
        int x = Integer.parseInt(meta.getValue("x"));
        int y = Integer.parseInt(meta.getValue("y"));
        mStroke.addPoint(x, y);
    }

    @Override
    public void start_radicals(final AttributeList meta) throws SAXException {
//        if (DEBUG) {
//            System.err.println("start_radicals: " + meta);
//        }
    }

    @Override
    public void end_radicals() throws SAXException {
//        if (DEBUG) {
//            System.err.println("end_radicals()");
//        }
    }

    @Override
    public void start_readings(final AttributeList meta) throws SAXException {
//        if (DEBUG) {
//            System.err.println("start_readings: " + meta);
//        }
    }

    @Override
    public void end_readings() throws SAXException {
//        if (DEBUG) {
//            System.err.println("end_readings()");
//        }
    }

    @Override
    public void handle_radical(final String data, final AttributeList meta) throws SAXException {
//        if (DEBUG) {
//            System.err.println("handle_radical: " + meta);
//        }
    }

    @Override
    public void start_strokes(final AttributeList meta) throws SAXException {
//        if (DEBUG) {
//            System.err.println("start_strokes: " + meta);
//        }
        mStrokes = new Strokes();
    }

    @Override
    public void end_strokes() throws SAXException {
//        if (DEBUG) {
//            System.err.println("end_strokes()");
//        }
        mEntry.addStrokes(mStrokes);
    }

    @Override
    public void handle_number_of_strokes(final String data, final AttributeList meta) throws SAXException {
//        if (DEBUG) {
//            System.err.println("handle_number_of_strokes: " + meta);
//        }
    }
}
