#ifndef GIKOMONA_CORE_GIKOMONA_HPP
#define GIKOMONA_CORE_GIKOMONA_HPP

#include <type_traits>

#include <boost/config.hpp>
#include <boost/filesystem/path.hpp>

/// @breif libbbs で string に関わる typedef を抑制する。@link libbbs/settings.hpp @endlink を見よ。
#define LIBBBS_USED_BY_GIKOMONA
#define LIBSQLITEXX_USED_BY_GIKOMONA

#include "string.hpp"

#include <sqlitexx.hpp>

#if __cplusplus < 201103L
    #error "[GikoMona.libcore @pp-time] : sorry, this compiler does NOT support C++11."
#endif

namespace monazilla { namespace GikoMona {

namespace core {

namespace sqlite = caprice::sqlitexx;

bool init_core(const mona_string& app_name);
void done_core(const mona_string& app_name) noexcept ;
void optimize_database(const boost::filesystem::path& db_path);

// for std::enable_if<T>
extern void *enabler;
    
template <typename T, typename U>
using enable_if_T_is_same_as_U
    = typename std::enable_if<std::is_same<T, U>::value>::type*& ;

// for communication.hpp
typedef int communicate_id;
std::string to_string(const communicate_id val);
    

}

} }


#define PROJECT_NAME "GikoMona project, powered by monazilla.org."
#define PROJECT_URL "http://sourceforge.jp/projects/gikomona/"

#endif
