
#ifndef GIKOMONA_CORE_APPLICATION_TYPE_HPP
#define GIKOMONA_CORE_APPLICATION_TYPE_HPP

#include "GikoMona.hpp"

namespace monazilla { namespace GikoMona { namespace core {

enum class application_type : communicate_id {
    COMMUNICATE_ID_APP = -1,
    GM_U2, // GikoMona Update Utility
    
    GIKOMONA,
    PNUTS,
    
    END_OF_COMMUNICATE_ID_APP = 100,
    
    /* 100-1000 は予約されている */
    
    COMMUNICATE_ID_USER = 1000
};

communicate_id to_communicate_id(const application_type val) {
    return static_cast<communicate_id>(val);
}

std::string to_string(const application_type val) {
    switch (val) {
        case application_type::GM_U2:
            return "update-utility";
            
        case application_type::GIKOMONA:
            return "gikomona";
            
        case application_type::PNUTS:
            return "pnuts";
    }
}

} } }

#endif // GIKOMONA_CORE_APPLICATION_TYPE_HPP
