
#ifndef GIKOMONA_CORE_COMMUNICATION_MAIL_HPP
#define GIKOMONA_CORE_COMMUNICATION_MAIL_HPP

#include <vector>
#include <memory>

#include "message.hpp"

namespace monazilla { namespace GikoMona { namespace core { namespace communication {

typedef mona_string post_code;

struct mail {
    post_code from;
    post_code to_app_name;
    post_code to_class_id;
    
    message msg;
};

typedef std::shared_ptr<std::vector<mail>> mailbox;

class mail_container {
    mail_container();
    ~mail_container();
    
    bool post(const mail&);
    mail recieve();
    
    bool empty();
    std::size_t size();
};

mailbox create_mailbox();
void destroy_mailbox(mailbox&& mb);


} } } }

#endif // GIKOMONA_CORE_COMMUNICATION_MAIL_HPP
