
#ifndef GIKOMONA_CORE_COMMUNICATION_MESSAGE_HPP
#define GIKOMONA_CORE_COMMUNICATION_MESSAGE_HPP

#include <sstream>

#include <boost/type_erasure/any.hpp>
#include <boost/type_erasure/constructible.hpp>
#include <boost/type_erasure/member.hpp>
#include <boost/mpl/vector.hpp>

#include "string.hpp"

namespace monazilla { namespace GikoMona { namespace core { namespace communication {
    
BOOST_TYPE_ERASURE_MEMBER(has_to_raw, to_raw, 0)
BOOST_TYPE_ERASURE_MEMBER(has_msg_type, get_type, 0)

typedef mona_string raw_message;
    
enum class message_type {
    FAILURE,
    REQUEST,
    SUCCEED
};

typedef
    boost::mpl::vector<
        has_to_raw<raw_message()>,
        has_msg_type<message_type()>
    > message_requirements
    ;
    
typedef boost::type_erasure::any<message_requirements> message;

#define DEFINE_MESSAGE(type_, name, message)            \
    class name {                                        \
    public:                                             \
        explicit                                        \
        name (const mona_string& str) : detail(str) {}  \
        ~name() = default;                              \
        raw_message to_raw() const {                    \
            std::ostringstream str_builder;             \
            str_builder << #type_ << ":"                \
                        << message << "("               \
                        << detail  << ").";             \
            return static_cast<raw_message>(            \
                convert_from(str_builder.str())         \
            );                                          \
        }                                               \
        message_type get_type() { return type; }        \
    private:                                            \
        const mona_string detail;                       \
        const message_type type = message_type::type_;  \
};

} } } }

#endif // GIKOMONA_CORE_COMMUNICATION_MESSAGE_HPP
