
#ifndef GIKOMONA_CORE_COMMUNICATION_POST_OFFICE_HPP
#define GIKOMONA_CORE_COMMUNICATION_POST_OFFICE_HPP

#include <boost/optional.hpp>
#include <boost/interprocess/managed_shared_memory.hpp>
#include <boost/interprocess/containers/vector.hpp>
#include <boost/interprocess/allocators/allocator.hpp>

#include "shmem.hpp"
#include "message.hpp"
#include "mail.hpp"
#include "application-type.hpp"

namespace monazilla { namespace GikoMona { namespace core { namespace communication {

/** @brief
 *  @note このクラスは (1プロセス中の) シングルトンクラスである。
 *  @warning 1つのプロセス中で複数回constructされた場合アプリケーション自体がabortする。
 */
class post_office {
public:
    explicit post_office(const post_code& self_);
    ~post_office() noexcept;
    
    bool connect(const post_code& connect_to);
    bool disconnect(const post_code& disconnect_from);
    bool disconnect_all();
    
    template <class MessageType>
    bool send(const post_code& to, MessageType&& msg);
    
    mona_string receive(const post_code& originator_id);
    
    static post_office* get_instance() {
        if(!instance) { /* error? */ }
        return instance;
    }

private:
    bool send_string(const post_code& to, mona_string&& src);
    shared_memory gm_shmem; // アプリケーション群全体で共有されているメモリ
    const post_code self_code;
    
    const char *shared_memory_name = "monazilla.GikoMona.shared-memory";
    const char *ref_counter_name = "monazilla.GikoMona.reference-counter";
    
    static post_office* instance = nullptr;
};

} } } }

#endif // GIKOMONA_CORE_COMMUNICATION_POST_OFFICE_HPP
