
#ifndef GIKOMONA_CORE_COMMUNICATION_SHMEM_HPP
#define GIKOMONA_CORE_COMMUNICATION_SHMEM_HPP

#include <unordered_map>

#include <boost/optional.hpp>
#include <boost/interprocess/managed_shared_memory.hpp>
#include <boost/interprocess/containers/vector.hpp>
#include <boost/interprocess/allocators/allocator.hpp>

#include "GikoMona.hpp"
#include "string.hpp"

namespace monazilla { namespace GikoMona { namespace core { namespace communication {
    
namespace ipc = boost::interprocess;

typedef ipc::managed_shared_memory shared_memory;
typedef ipc::shared_memory_object shared_object;
typedef shared_memory::segment_manager segment_manager;

template <typename T>
using shared_memory_allocator = ipc::allocator<T, segment_manager>;
    
template <typename T>
using shared_list = ipc::list<T, shared_memory_allocator<T>>;

template <typename T>
T *find(shared_memory& shmem, const std::string& name) {
    return shmem.find<T>(name.c_str()).first;
}

template <typename T>
T *construct(shared_memory& shmem, const std::string& name) {
    return shmem.construct<T>(name.c_str())(shm.get_segment_manager());
}

void destruct(shared_memory& shmem, const std::string& name) {
    shared_object::remove(name.c_str());
}

} } } }

#endif // GIKOMONA_CORE_COMMUNICATION_SHMEM_HPP
