#ifndef GIKOMONA_CORE_EXTENSION_HPP
#define GIKOMONA_CORE_EXTENSION_HPP

#include <unordered_map>
#include <functional>

#include <boost/filesystem.hpp>

#include <lua.hpp>

#include "GikoMona.hpp"

namespace monazilla { namespace GikoMona { namespace core {

class extension final {
public:
    typedef mona_string extension_id_type;
    const static extension_id_type inavailable_id = "";
    typedef extension self_type;
    typedef ::lua_State* vm_type;
    
    typedef std::function<void (const vm_type*)> initialize_handler_type;
    typedef std::function<void () noexcept> finalize_handler_type;
    
    struct information {
        const mona_string name;
        const vm_type lua_obj;
        bool is_packaged;
    };
    
    extension() {
        if(!boost::filesystem::exists(unpacked_extension_path)) {
            boost::filesystem::create_directories(unpacked_extension_path);
        }
        instance = this;
    }
    
    ~extension() {
        boost::system::error_code dummy;
        boost::filesystem::remove_all(unpacked_extension_path, dummy);
    }
    
    static extension *get_instance() { return instance; }
    void add_initialize_handler(const initialize_handler_type& handler) { init_func = handler; }
    void add_finalize_handler(const finalize_handler_type& handler) { fin_func = handler; }
    
    extension_id_type load(const boost::filesystem::path& ext_path) {
        if(ext_path.get_ext() == "gep") {
            // エクステンションはパッケージ化されている
            
            information ext_info = {"", luaL_newstate(), true};
            
            extension_table[ext_info.name] = ext_info;
        } else if(ext_path.get_ext() == "gex") {
            // エクステンションは単体のファイルである
        } else { return inavailable_id; }
    }
private:
    std::unordered_map<extension_id_type, information> extension_table;
    const boost::filesystem::path unpacked_extension_path = ".tmp/unpacked-ext";
    static self_type *instance;
    
    initialize_handler_type init_func;
    finalize_handler_type fin_func;
};

} } }

#endif
