
#ifndef GIKOMONA_CORE_REF_COUNTER_HPP
#define GIKOMONA_CORE_REF_COUNTER_HPP

#include <memory>

#include <boost/interprocess/sync/named_mutex.hpp>

namespace monazilla { namespace GikoMona { namespace core {

class reference_counter {
public:
    typedef reference_counter self_type;
    
    reference_counter() : counter(0) {
        mutex = boost::interprocess::
            named_mutex(boost::interprocess::create_only,
                        "monazilla.GikoMona.shared-memory.mutex");
    }
    
    ~reference_counter() {
        named_mutex::remove("monazilla.GikoMona.shared-memory.mutex");
    }
    
    self_type& operator++() { ++counter; return *this; }
    self_type& operator--() { --counter; return *this; }
    
    void release_lock() { mutex.lock(); }
    void acquire_lock() { mutex.unlock(); }
    int count() const { return counter; }
    
public:
    struct scoped_locker {
        scoped_locker(reference_conuter& val) : obj(val) { obj.acquire_lock(); }
        ~scoped_locker() { obj.release_lock(); }
    private:
        reference_counter& obj
    };
    
    scoped_locker scoped_lock() { return std::move(scoped_locker(*this)); }
    
private:
    int counter;
    boost::interprocess::named_mutex mutex;
};

} } }

#endif // GIKOMONA_CORE_REF_COUNTER_HPP
