#include <boost/filesystem/path.hpp>
#include <boost/algorithm/string/split.hpp>

#include "model.hpp"

namespace monazilla { namespace GikoMona { namespace core {

struct model::model_pimpl {
    // session/tab-window
    /* 構造
     * bbs-name(TEXT)|board-name(TEXT)|thread-id(TEXT)|thread-name(TEXT)|is_fixed(INTEGAR)
     */
    database tab_db;
    
    // session/history
    /* 構造
     * date(TEXT)|bbs-name(TEXT)|board-name(TEXT)|thread-id(TEXT)|thread-name(TEXT)
     */
    database history_db;
    
    // application
    config app_config;
    
    struct {
        const mona_string tab_db = "session.tab-window.db";
        const mona_string history_db = "session.history.db";
        const mona_string linkref_db = "session.linkrefs.db";
        const mona_string app_config = "application-config.xml";
    } file_name;
};

model::model() noexcept {
    instance = this;
    pimpl = std::make_shared<model_pimpl>();
    
    auto config_path = pimpl->app_config;
}

bool model::load_file(const boost::filesystem::path& file_path) {
    if(!boost::filesystem::exists(file_path)) {
        return false;
    }
    
    auto ext = file_path.extension();
    auto file_name = file_path.filename();
    
    /* 依存型が欲しいなぁって */
    if(ext == "db") {
        // sqlite -> class `database'
        if(file_name == pimpl->file_name.tab_db) {
            pimpl->tab_db.get_connection().open(file_path.c_str());
        } else if(file_name == pimpl->file_name.history_db) {
            pimpl->history_db.get_connection().open(file_path.c_str());
        }
    } else if(ext == "xml") {
        // xml -> class `config'
        pimpl->app_config;
    }
    
    return true;
}

bool model::save_to_file(const boost::filesystem::path& path) {
    if(!boost::filesystem::exists(path)) { return false; }
    
    auto ext = path.extension();
    
    if(ext == "db") {
        // caprice::sqlitexx::connection は open の時点でファイルの作成を完了している。
        // さらに、connection に対する動作は全て db に書き込まれているので、単に true を返すに留める。
        return true;
    }
    
    pimpl->app_config;
    return true;
}

void model::execute_accumulated_query()  {
    inserted_value_triv_copyable_type q;
    
    if(insertion_query_queue.empty()) { return; }
    
    insertion_query_queue.pop(q);

    mona_string into;
    boost::any value;
    std::tie(*q, into, value);
    
    std::vector<mona_string> path_derimed = analyze_query(into);
    
    if(path_derimed[0] != "application") {
        // application/*
    } else if (path_derimed[0] == "session") {
        // session/*
        if(path_derimed[1] == "history") {
            ;
        } else if(path_derimed[1] == "tab-window") {
            ;
        }
    } else if(path_derimed[0] == "extension") {
        // extension/*
    } else {
        // ?
    }
}

boost::any model::select(const mona_string& from, bool tag) const noexcept {
    std::vector<mona_string> path_derimed = analyze_query(from);
    
    if(path_derimed[0] != "application") {
        // application/*
    } else if (path_derimed[0] == "session") {
        // session/*
        if(path_derimed[1] == "history") {
            ;
        } else if(path_derimed[1] == "tab-window") {
            ;
        }
    } else if(path_derimed[0] == "extension") {
        // extension/*
    } else {
        // ?
    }
}

std::vector<mona_string> model::analyze_query(const mona_string& src) const {
    std::vector<mona_string> result;
    boost::algorithm::split(result,
                            src,
                            [](char c) -> bool {
                                if(c == '/') return true;
                                return false;
                            });
    
    return std::move(result); // RVO を期待した方が良いか…？
}

} } }
