#include <sstream>

#include <boost/range/algorithm.hpp>

#include "post-office.hpp"
#include "reference-counter.hpp"

#include "request.hpp"
#include "failure.hpp"
#include "succeed.hpp"

namespace monazilla { namespace GikoMona { namespace core { namespace communication {

post_office::post_office(const post_code& self_) : self_code(self_) {
    gm_shmem = shared_memory(ipc::open_or_create, shared_memory_name, 1024 * 4);
    auto my_mailbox = construct<mailbox>(gm_shmem, self_code);
    
    if(auto obj = find<reference_counter>(gm_shmem, ref_counter_name)) {
        auto locker = obj->scoped_lock();
        ++(*obj);
    } else {
        construct<reference_counter>(gm_shmem, ref_counter_name);
    }
}

post_office::~post_office() noexcept {
    disconnect_all();
    
    if(auto obj = find<reference_counter>(gm_shmem, ref_counter_name)) {
        if(obj->count() == 1) {
            destruct(gm_shmem, shared_memory_name);
        } else {
            auto locker = obj->scoped_lock();
            --(*obj);
        }
    } else {
        /* error!!!!! */
    }
}

bool post_office::connect(const post_code& connect_to) {
    auto obj = find<mailbox>(gm_shmem, connect_to);
    
    if(obj) {
        //mailbox_map[connect_to] = *obj;
        send(connect_to, succeed::find_your_mailbox("").to_raw());
    }
    
    return obj;
}

bool post_office::disconnect(const post_code& disconnect_from) {
    return /*mailbox_map.erase(disconnect_from);*/ true;
}

mona_string post_office::receive(const post_code& originator_id) {
    //boost::find_if
}
    
bool post_office::send_string(const post_code& to, mona_string&& src) {
    auto obj = find<mailbox>(gm_shmem, to);
    
    if(obj) {
        std::ostringstream str_builder;
        //str_builder << self_ << "-" << src;
    }
    
    return obj;
}

} } } }
