#include <exception>
#include <memory>
#include <sstream>

#include <boost/filesystem.hpp>
#include <boost/log/trivial.hpp>

#include <wx/xrc/xmlres.h>
#include <wx/msgdlg.h>

#include "GikoMona.hpp"
#include "database.hpp"
#include "model.hpp"
#include "post-office.hpp"

#include "extension.hpp"

namespace monazilla { namespace GikoMona { namespace core {

namespace {

std::shared_ptr<model> app_model;
std::shared_ptr<extension> app_extension;
std::shared_ptr<communication::post_office> app_postoffice;

}

bool init_core(const mona_string& app_name) {
    wxXmlResource::Get()->InitAllHandlers();
    wxXmlResource::Get()->LoadAllFiles(wxT("resouce"));
    
    boost::system::error_code reason;
    std::stringstream path_builder;
    path_builder << ".tmp/" << app_name;
    
    // 一時解凍ファイルなどを溜め込む .tmp フォルダを作成
    if(!boost::filesystem::exists(path_builder.str(), reason) &&
       !boost::filesystem::create_directories(path_builder.str(), reason)) {
        // log
        std::terminate();
    }
    
    app_model = std::make_shared<model>();
    app_extension = std::make_shared<extension>();
    app_postoffice = std::make_shared<communication::post_office>(app_name);
    
    return true;
}

void done_core(const mona_string& app_name) noexcept {
    boost::system::error_code reason;
    boost::filesystem::remove_all(".tmp", reason);
    
    optimize_database("./history.db");
}

void optimize_database(const boost::filesystem::path& db_path) {
    boost::system::error_code ec;
    
    database db(db_path, ec);
    sqlite::connection con = db.get_connection();

    mona_string sql(u8"SELECT counts-of-deleting-value FROM file-information;");
    auto count = sqlite::execute_statement<int>(db, sql, ec);

    if(!count) { /* log */ }
    
    if(count->at<0>(0) >= 1000) {
        db.optimize(ec);
    }
}

} } }
