unit ItemDownload;

interface

uses
	Windows, SysUtils, Classes, ComCtrls, Controls, Forms, IdHTTP,
	{HTTPApp,} YofUtils, IdGlobal, IdException, IdComponent, IniFiles, {DateUtils,}
	GikoSystem, BoardGroup, MonaUtils, ExternalBoardManager, ExternalBoardPlugInMain,
	Sort;

type
	TDownloadItem = class;
	TGikoDownloadType = (gdtBoard, gdtThread);
	TGikoDownloadState = (gdsWait, gdsWork, gdsComplete, gdsDiffComplete, gdsNotModify, gdsAbort, gdsError);
	TGikoCgiStatus = (gcsOK, gcsINCR, gcsERR);
	TGikoDLProgress = (gdpStd, gdpAll, gdpDatOchi, gdpOfflaw);

	TGikoWorkEvent = procedure(Sender: TObject; AWorkMode: TWorkMode; const AWorkCount: Integer; ID: Integer) of object;
	TGikoWorkBeginEvent = procedure(Sender: TObject; AWorkMode: TWorkMode; const AWorkCountMax: Integer; ID: Integer; const AWorkTitle: string) of object;
	TGikoWorkEndEvent = procedure(Sender: TObject; AWorkMode: TWorkMode; ID: Integer) of object;
	TDownloadEndEvent = procedure(Sender: TObject; Item: TDownloadItem) of object;
	TDownloadMsgEvent = procedure(Sender: TObject; Item: TDownloadItem; Msg: string; Icon: TGikoMessageIcon) of object;

	TCgiStatus = record
		FStatus: TGikoCgiStatus;
		FSize: Integer;
		FErrText: string;
	end;


	TDownloadThread = class(TThread)
	private
		FIndy: TIdHttp;
		FItem: TDownloadItem;
		FNumber: Integer;
		FAbort: Boolean;
		FMsg: string;
		FIcon: TGikoMessageIcon;
		FSessionID: string;
		FOnWork: TGikoWorkEvent;
		FOnWorkBegin: TGikoWorkBeginEvent;
		FOnWorkEnd: TGikoWorkEndEvent;
		FOnDownloadEnd: TDownloadEndEvent;
		FOnDownloadMsg: TDownloadMsgEvent;
		FDownloadTitle: string;

		procedure FireDownloadEnd;
		procedure FireDownloadMsg;
		procedure GetSessionID;
		procedure WorkBegin(Sender: TObject; AWorkMode: TWorkMode; const AWorkCountMax: Integer);
		procedure WorkEnd(Sender: TObject; AWorkMode: TWorkMode);
		procedure Work(Sender: TObject; AWorkMode: TWorkMode; const AWorkCount: Integer);
		function ParseCgiStatus(Content: string): TCgiStatus;
		function CgiDownload(ItemType: TGikoDownloadType; URL: string; Modified: TDateTime): Boolean;
		function DatDownload(ItemType: TGikoDownloadType; URL: string; Modified: TDateTime; RangeStart: Integer; AdjustLen: Integer): Boolean;
		procedure DeleteStatusLine(Item: TDownloadItem);
		procedure InitHttpClient(client: TIdHttp);
		procedure ClearHttpClient(client: TIdHttp);
	protected
		procedure Execute; override;
	public
		property Item: TDownloadItem read FItem write FItem;
		property Number: Integer read FNumber write FNumber;
		constructor Create(CreateSuspended: Boolean);
				destructor Destroy; override;
		procedure Abort;
		property OnWork: TGikoWorkEvent read FOnWork write FOnWork;
		property OnWorkBegin: TGikoWorkBeginEvent read FOnWorkBegin write FOnWorkBegin;
		property OnWorkEnd: TGikoWorkEndEvent read FOnWorkEnd write FOnWorkEnd;
		property OnDownloadEnd: TDownloadEndEvent read FOnDownloadEnd write FOnDownloadEnd;
		property OnDownloadMsg: TDownloadMsgEvent read FOnDownloadMsg write FOnDownloadMsg;
	end;

	TDownloadItem = class(TObject)
	private
		FDownType: TGikoDownloadType;
		FBoard: TBoard;
		FThreadItem: TThreadItem;

		FContentLength: Integer;
		FLastModified: TDateTime;
		FContent: string;
		FResponseCode: Smallint;
		FState: TGikoDownloadState;
		FErrText: string;
		FForceDownload: Boolean;
		FIsAbone : Boolean;
	public
		procedure SaveListFile;
		procedure SaveItemFile;

		property DownType: TGikoDownloadType read FDownType write FDownType;
		property Board: TBoard read FBoard write FBoard;
		property ThreadItem: TThreadItem read FThreadItem write FThreadItem;

		property ContentLength: Integer read FContentLength write FContentLength;
		property LastModified: TDateTime read FLastModified write FLastModified;
		property Content: string read FContent write FContent;
		property ResponseCode: Smallint read FResponseCode write FResponseCode;
		property State: TGikoDownloadState read FState write FState;
		property ErrText: string read FErrText write FErrText;
		property ForceDownload: Boolean read FForceDownload write FForceDownload;
		property IsAbone : Boolean read FIsAbone write FIsAbone;
	end;

implementation

uses
	Y_TextConverter, MojuUtils, HTMLCreate;

constructor TDownloadThread.Create(CreateSuspended: Boolean);
begin
	inherited Create(CreateSuspended);
	FIndy := TIdHttp.Create(nil);

	FIndy.OnWorkBegin := WorkBegin;
	FIndy.OnWorkEnd := WorkEnd;
	FIndy.OnWork := Work;
end;

destructor TDownloadThread.Destroy;
begin
	ClearHttpClient(FIndy);
	FIndy.Free;
	inherited;
end;

function RFC1123_Date(aDate : TDateTime) : String;
const
	 StrWeekDay : String = 'MonTueWedThuFriSatSun';
	 StrMonth	 : String = 'JanFebMarAprMayJunJulAugSepOctNovDec';
var
	 Year, Month, Day			 : Word;
	 Hour, Min,	 Sec, MSec : Word;
	 DayOfWeek							: Word;
begin
	 DecodeDate(aDate, Year, Month, Day);
	 DecodeTime(aDate, Hour, Min,	 Sec, MSec);
	 DayOfWeek := ((Trunc(aDate) - 2) mod 7);
	 Result := Copy(StrWeekDay, 1 + DayOfWeek * 3, 3) + ', ' +
						 Format('%2.2d %s %4.4d %2.2d:%2.2d:%2.2d',
										[Day, Copy(StrMonth, 1 + 3 * (Month - 1), 3),
										 Year, Hour, Min, Sec]);
end;
// ******************************************************************
// HTTPClient̏
// ******************************************************************
procedure TDownloadThread.InitHttpClient(client: TIdHttp);
begin
	ClearHttpClient(client);
	client.Disconnect;
	client.Request.UserAgent := GikoSys.GetUserAgent;
	client.RecvBufferSize := Gikosys.Setting.RecvBufferSize;
	client.ProxyParams.BasicAuthentication := False;
	client.ReadTimeout := GikoSys.Setting.ReadTimeOut;
	{$IFDEF DEBUG}
	Writeln('------------------------------------------------------------');
	{$ENDIF}
	//FIndy.AllowCookies := False;
	if GikoSys.Setting.ReadProxy then begin
		if GikoSys.Setting.ProxyProtocol then
			client.ProtocolVersion := pv1_1
		else
			client.ProtocolVersion := pv1_0;
		client.ProxyParams.ProxyServer := GikoSys.Setting.ReadProxyAddress;
		client.ProxyParams.ProxyPort := GikoSys.Setting.ReadProxyPort;
		client.ProxyParams.ProxyUsername := GikoSys.Setting.ReadProxyUserID;
		client.ProxyParams.ProxyPassword := GikoSys.Setting.ReadProxyPassword;
		if GikoSys.Setting.ReadProxyUserID <> '' then
			client.ProxyParams.BasicAuthentication := True;
		{$IFDEF DEBUG}
		Writeln('vLVݒ肠');
		Writeln('zXg: ' + GikoSys.Setting.ReadProxyAddress);
		Writeln('|[g: ' + IntToStr(GikoSys.Setting.ReadProxyPort));
		{$ENDIF}
	end else begin
		if GikoSys.Setting.Protocol then
			client.ProtocolVersion := pv1_1
		else
			client.ProtocolVersion := pv1_0;
		client.ProxyParams.ProxyServer := '';
		client.ProxyParams.ProxyPort := 80;
		client.ProxyParams.ProxyUsername := '';
		client.ProxyParams.ProxyPassword := '';
		{$IFDEF DEBUG}
		Writeln('vLVݒȂ');
		{$ENDIF}
	end;
end;
// ******************************************************************
// HTTPClient̃NGXgƃX|X̃f[^̏
// ******************************************************************
procedure TDownloadThread.ClearHttpClient(client: TIdHttp);
begin
	client.Request.CustomHeaders.Clear;
	client.Request.RawHeaders.Clear;
	client.Request.Clear;
	client.Response.CustomHeaders.Clear;
	client.Response.RawHeaders.Clear;
	client.Response.Clear;

	client.ProxyParams.Clear;
end;
procedure TDownloadThread.Execute;
var
	ResStream: TMemoryStream;

	URL: string;
	CgiStatus: TCgiStatus;
	Modified: TDateTime;
	RangeStart: Integer;
	AdjustLen: Integer;
	Idx: Integer;
	ATitle: string;
	DownloadResult: Boolean;
	boardPlugIn 	: TBoardPlugIn;
	lastContent		: string;
	logFile				: TFileStream;
	adjustMargin	: Integer;
const
	ADJUST_MARGIN	= 16;
begin
	while not Terminated do begin
		//===== vOC
		FAbort := False;
		boardPlugIn := nil;
		ExternalBoardManager.OnWork				:= Work;
		ExternalBoardManager.OnWorkBegin	:= WorkBegin;
		ExternalBoardManager.OnWorkEnd		:= WorkEnd;

		FDownloadTitle := '';
		case FItem.FDownType of
		gdtBoard:
			begin
				FDownloadTitle := FItem.FBoard.Title;
				if FItem.FBoard <> nil then begin
					if FItem.FBoard.IsBoardPlugInAvailable then begin
						boardPlugIn	:= FItem.FBoard.BoardPlugIn;
						Item.State	:= TGikoDownloadState( boardPlugIn.DownloadBoard( DWORD( FItem.FBoard ) ) );
					end;
				end;
			end;
		gdtThread:
			begin
				FDownloadTitle := FItem.FThreadItem.Title;
				if FItem.FThreadItem <> nil then begin
					if FItem.FThreadItem.ParentBoard.IsBoardPlugInAvailable then begin
						boardPlugIn := FItem.FThreadItem.ParentBoard.BoardPlugIn;
						Item.State	:= TGikoDownloadState( boardPlugIn.DownloadThread( DWORD( FItem.FThreadItem ) ) );
					end;
					//if FItem.FThreadItem.IsBoardPlugInAvailable then begin
					//	boardPlugIn	:= FItem.FThreadItem.BoardPlugIn;
					//	Item.State	:= TGikoDownloadState( boardPlugIn.DownloadThread( DWORD( FItem.FThreadItem ) ) );
					//end;
				end;
			end;
		end;
		if Length(FDownloadTitle) = 0 then
			FDownloadTitle := 'i̕sj';

		if boardPlugIn <> nil then begin
			if FAbort then begin
				Item.State := gdsAbort;
			end;
			if Assigned( OnDownloadEnd ) then
				Synchronize( FireDownloadEnd );
			if Terminated then
				Break;

			Suspend;
			Continue;
		end;

		FAbort := False;
		//===== vOCgpȂꍇ
		InitHttpClient(FIndy);
		adjustMargin := 0;
		if Item.DownType = gdtThread then begin
			if FileExists( Item.ThreadItem.GetThreadFileName ) then begin
				// dat t@C̍Ōǂݏo
				SetLength( lastContent, ADJUST_MARGIN + 1 );
				logFile := TFileStream.Create( Item.ThreadItem.GetThreadFileName, fmOpenRead or fmShareDenyWrite );
				try
					logFile.Seek( -(ADJUST_MARGIN + 1), soFromEnd );
					logFile.Read( lastContent[ 1 ], ADJUST_MARGIN + 1 );
					lastContent := StringReplace( lastContent, #13, '', [] );	// CR ̍폜
				finally
					logFile.Free;
				end;
			end else begin
        lastContent := '';
			end;
			adjustMargin := Length( lastContent );
		end;

		FIndy.Request.ContentRangeStart := 0;
		FIndy.Request.LastModified := ZERO_DATE;
		ResStream := TMemoryStream.Create;
		try
			try
				//********************
				//DAT or Subject擾
				//********************
				Item.ResponseCode := 0;
				RangeStart := 0;
				AdjustLen := 0;
				Modified := 0;
				if Item.DownType = gdtBoard then begin
					{$IFDEF DEBUG}
					Writeln('Subject擾');
					Writeln('URL: ' + Item.Board.GetReadCgiURL);
					Writeln('Modified: ' + FloatToStr(Item.Board.LastModified));
					{$ENDIF}
					URL := Item.Board.GetReadCgiURL;
					if Item.ForceDownload then begin
						// 擾
						ATitle := Item.Board.Title;
						if ATitle = '' then
							ATitle := 'i̕sj';
						FMsg := '擾s܂ - [' + ATitle + ']';
						FIcon := gmiWhat;
						if Assigned(OnDownloadMsg) then
							Synchronize(FireDownloadMsg);
						Modified := ZERO_DATE
					end else begin
						Modified := Item.Board.LastModified;
					end;
				end else if Item.DownType = gdtThread then begin
					{$IFDEF DEBUG}
					Writeln('DAT擾');
					Writeln('URL: ' + Item.ThreadItem.GetDatURL);
					Writeln('Modified: ' + FloatToStr(Item.ThreadItem.LastModified));
					{$ENDIF}
					URL := Item.ThreadItem.GetDatURL;
					if Item.ForceDownload then begin
						// 擾
						ATitle := Item.ThreadItem.Title;
						if ATitle = '' then
							ATitle := 'i̕sj';
						FMsg := '擾s܂ - [' + ATitle + ']';
						FIcon := gmiWhat;
						if FileExists(ChangeFileExt(Item.FThreadItem.GetThreadFileName,'.NG')) = true then
							DeleteFile(ChangeFileExt(Item.FThreadItem.GetThreadFileName,'.NG'));
						if Assigned(OnDownloadMsg) then
							Synchronize(FireDownloadMsg);
						Modified := ZERO_DATE;
						RangeStart := 0;
						AdjustLen := 0;
					end else begin
						Modified := Item.ThreadItem.LastModified;
						if Item.ThreadItem.Size > 0 then begin
							{$IFDEF DEBUG}
							Writeln('RangeStart: ' + IntToStr(Item.ThreadItem.Size));
							{$ENDIF}
							// ځ[`FbN̂ adjustMargin oCgO擾
							RangeStart := Item.ThreadItem.Size;
							AdjustLen := -adjustMargin;
						end;
					end;
				end;
				Item.IsAbone := False;
				DownloadResult := DatDownload(Item.DownType, URL, Modified, RangeStart, AdjustLen);
				{$IFDEF DEBUG}
				Writeln('ResponseCode: ' + IntToStr(FIndy.ResponseCode));
				{$ENDIF}
				if Item.DownType = gdtThread then begin
					if Item.ResponseCode = 416 then begin
						Item.IsAbone := True;
						DownloadResult := True;
					end else if DownloadResult and (AdjustLen < 0) then begin
						if Copy( Item.Content, 1, adjustMargin ) <> lastContent then
							Item.IsAbone := True;
					end;
				end;

				if Trim(FIndy.Response.RawHeaders.Values['Date']) <> '' then begin
					if Item.DownType = gdtBoard then
						Item.Board.LastGetTime := MonaUtils.DateStrToDateTime(FIndy.Response.RawHeaders.Values['Date'])
					else
						Item.ThreadItem.ParentBoard.LastGetTime := MonaUtils.DateStrToDateTime(FIndy.Response.RawHeaders.Values['Date']);
				end;

				if DownloadResult then begin
					{$IFDEF DEBUG}
					Writeln('Date:' + FIndy.Response.RawHeaders.Values['Date']);
					{$ENDIF}
					if Item.IsAbone then begin
						{$IFDEF DEBUG}
						Writeln('ځ[񌟏o');
						{$ENDIF}
						ATitle := Item.ThreadItem.Title;
						if ATitle = '' then
							ATitle := 'i̕sj';
						//擾PoCgڂLFłȂꍇ́uځ[vĂ邩̂ōĎ擾
						RangeStart := 0;
						AdjustLen := 0;
						FMsg := 'uځ[vôōĎ擾s܂ - [' + ATitle + ']';
						FIcon := gmiWhat;
						if FileExists(ChangeFileExt(Item.FThreadItem.GetThreadFileName,'.NG')) = true then
							DeleteFile(ChangeFileExt(Item.FThreadItem.GetThreadFileName,'.NG'));
						if Assigned(OnDownloadMsg) then
							Synchronize(FireDownloadMsg);
						if not DatDownload(Item.DownType, URL, ZERO_DATE, RangeStart, AdjustLen) then
							Item.State := gdsError;
						{$IFDEF DEBUG}
						Writeln('ځ[Ď擾');
						Writeln('ResponseCode: ' + IntToStr(Item.ResponseCode));
						{$ENDIF}
					end else if (Item.DownType = gdtThread) and (AdjustLen < 0) then begin
						// 擾oꍇ͂ځ[`FbNpɎ擾]ȃTCY폜
						Item.Content := Copy(Item.Content, adjustMargin + 1, MaxInt);
					end;
				end else begin
					Item.State := gdsError;
					if (Item.DownType = gdtBoard) and (Item.ResponseCode = 302) then begin
						FMsg := 'ړ]Ȃ̂ŔXVsĂ';
						FIcon := gmiNG;
						if Assigned(OnDownloadMsg) then
							Synchronize(FireDownloadMsg);
					end;
				end;

				//********************
				//dat.gz擾(1)
				//********************
				if (Item.DownType = gdtThread) and (Item.ResponseCode = 302) then begin
					{$IFDEF DEBUG}
					Writeln('dat.gz擾');
					{$ENDIF}
					ATitle := Item.ThreadItem.Title;
					if ATitle = '' then
						ATitle := 'i̕sj';
					FMsg := 'dat݂Ȃ߉ߋO(dat.gz)T܂ - [' + ATitle + ']';
					FIcon := gmiWhat;
					if Assigned(OnDownloadMsg) then
						Synchronize(FireDownloadMsg);
					URL := Item.ThreadItem.GetDatgzURL;
					Modified := Item.ThreadItem.LastModified;
					RangeStart := 0;
					AdjustLen := 0;
					if not DatDownload(Item.DownType, URL, Modified, RangeStart, AdjustLen) then
						Item.State := gdsError;
					{$IFDEF DEBUG}
					Writeln('ResponseCode: ' + IntToStr(Item.ResponseCode));
					{$ENDIF}
				end;

				//********************
				//dat.gz@@dat̎擾@2005N6ǉ@by
				//********************
				if (Item.DownType = gdtThread) and (Item.ResponseCode = 302) then begin
					{$IFDEF DEBUG}
					Writeln('dat擾');
					{$ENDIF}
					FMsg := 'ߋO(dat.gz)݂Ȃ߉ߋO(dat)T܂ - [' + ATitle + ']';
					FIcon := gmiWhat;
					if Assigned(OnDownloadMsg) then
						Synchronize(FireDownloadMsg);
					URL := ChangeFileExt(URL, '');
					Modified := Item.ThreadItem.LastModified;
					RangeStart := 0;
					AdjustLen := 0;
					if not DatDownload(Item.DownType, URL, Modified, RangeStart, AdjustLen) then
						Item.State := gdsError;
					{$IFDEF DEBUG}
					Writeln('ResponseCode: ' + IntToStr(Item.ResponseCode));
					{$ENDIF}
				end;

				//********************
				//dat.gz擾(2)
				//********************
{
				if (Item.DownType = gdtThread) and (Item.ResponseCode = 302) then begin
					ATitle := Item.ThreadItem.Title;
					if ATitle = '' then
						ATitle := 'i̕sj';
					FMsg := 'ߋO(1)݂Ȃ߉ߋO(2)T܂ - [' + ATitle + ']';
					FIcon := gmiWhat;
					if Assigned(OnDownloadMsg) then
						Synchronize(FireDownloadMsg);
					URL := Item.ThreadItem.GetOldDatgzURL;
					Modified := Item.ThreadItem.LastModified;
					RangeStart := 0;
					AdjustLen := 0;
					if not DatDownload(Item.DownType, URL, Modified, RangeStart, AdjustLen) then
						Item.State := gdsError;
				end;
}

				//********************
				//offlaw.cgiŎ擾
				//********************
				FSessionID := '';
				Synchronize(GetSessionID);
				if (Item.DownType = gdtThread) and (Item.ResponseCode = 302) and (FSessionID <> '') then begin
					{$IFDEF DEBUG}
					Writeln('offlaw.cgiŎ擾');
					{$ENDIF}
					ATitle := Item.ThreadItem.Title;
					if ATitle = '' then
						ATitle := 'i̕sj';
					FMsg := 'dat.gz݂Ȃofflaw.cgi𗘗p܂ - [' + ATitle + ']';
					FIcon := gmiWhat;
					if Assigned(OnDownloadMsg) then
						Synchronize(FireDownloadMsg);
					URL := Item.ThreadItem.GetOfflawCgiURL(FSessionID);
					Modified := Item.ThreadItem.LastModified;
					RangeStart := 0;
					AdjustLen := 0;
					if not DatDownload(Item.DownType, URL, Modified, RangeStart, AdjustLen) then begin
						{$IFDEF DEBUG}
						Writeln('ResponseCode: ' + IntToStr(Item.ResponseCode));
						{$ENDIF}
						Item.State := gdsError;

						if (Item.DownType = gdtThread) and (Item.ResponseCode = 302) then begin
							FMsg := 'ړ]Ȃ̂ŔXVsĂB';
							FIcon := gmiNG;
							if Assigned(OnDownloadMsg) then
								Synchronize(FireDownloadMsg);
						end;

					end else begin
						CgiStatus := ParseCgiStatus(Item.Content);
						{$IFDEF DEBUG}
						Writeln('ResponseCode: ' + IntToStr(Item.ResponseCode));
						{$ENDIF}
						case CgiStatus.FStatus of
							gcsOK: begin
								{$IFDEF DEBUG}
								Writeln('CGIStatus: OK');
								{$ENDIF}
								Item.ResponseCode := 200;
								DeleteStatusLine(Item);
							end;
							gcsINCR: begin
								//͂肦Ȃ
								{$IFDEF DEBUG}
								Writeln('CGIStatus: 206');
								{$ENDIF}
								Item.ResponseCode := 206;
								DeleteStatusLine(Item);
							end;
							gcsERR: begin
								{$IFDEF DEBUG}
								Writeln('CGIStatus: 404(ERROR)');
								{$ENDIF}
								Item.ResponseCode := 404;
								Item.State := gdsError;
								Item.ErrText := CgiStatus.FErrText;
							end;
						end;
						if (Item.ResponseCode = 404) and (AnsiPos('ߋOqɂŔ', Item.ErrText) <> 0) then begin
							{$IFDEF DEBUG}
							Writeln('ߋO擾');
							{$ENDIF}
							ATitle := Item.ThreadItem.Title;
							if ATitle = '' then
								ATitle := 'i̕sj';
							FMsg := 'ߋOqɂŔ - [' + ATitle + ']';
							FIcon := gmiWhat;
							if Assigned(OnDownloadMsg) then
								Synchronize(FireDownloadMsg);
							Idx := Pos(' ', Item.ErrText);
							if Idx <> 0 then begin
								URL := Copy(Item.ErrText, Idx + 1, Length(Item.ErrText));
								if Pos( '://', URL ) = 0 then begin
									if Pos('../', URL) = 1 then
										URL := Copy(URL, 4, MaxInt );
									if Pos( '/', URL ) = 1 then
										URL := Copy( URL, 2, MaxInt );
									URL := GikoSys.UrlToServer(Item.ThreadItem.ParentBoard.URL) + URL;
								end;
								Modified := Item.ThreadItem.LastModified;
								RangeStart := 0;
								AdjustLen := 0;
								if not DatDownload(Item.DownType, URL, Modified, RangeStart, AdjustLen) then
									Item.State := gdsError;
								{$IFDEF DEBUG}
								Writeln('ResponseCode: ' + IntToStr(Item.ResponseCode));
								{$ENDIF}
							end;
						end;
					end;
				end else begin
					if (Item.DownType = gdtThread) and (Item.ResponseCode = 302) and (FSessionID = '') then begin
						{$IFDEF DEBUG}
						Writeln('OCĂȂ̂ŉߋO擾s');
						{$ENDIF}
						ATitle := Item.ThreadItem.Title;
						if ATitle = '' then
							ATitle := 'i̕sj';
						FMsg := 'OCĂȂߒTƂo܂ - [' + ATitle + ']';
						FIcon := gmiSAD;
						if Assigned(OnDownloadMsg) then
							Synchronize(FireDownloadMsg);
					end;
				end;

				case Item.ResponseCode of
					200: Item.State := gdsComplete;
					206: Item.State := gdsDiffComplete;
					304: Item.State := gdsNotModify;
					else
						Item.State := gdsError;
				end;
			except
				Item.State := gdsError;
			end;
			if FAbort then
				Item.State := gdsAbort;
		finally
			if Assigned(OnDownloadEnd) then
				Synchronize(FireDownloadEnd);
			ResStream.Free;
		end;

		ClearHttpClient(FIndy);

		if Terminated then Break;
		Suspend;
	end;
end;

function TDownloadThread.CgiDownload(ItemType: TGikoDownloadType; URL: string; Modified: TDateTime): Boolean;
var
	ResponseCode: Integer;
	ResStream: TMemoryStream;
begin
	ResponseCode := -1;
	FIndy.Request.ContentRangeStart := 0;
	FIndy.Request.ContentRangeEnd := 0;

	FIndy.Request.CustomHeaders.Clear;
	if (Modified <> 0) and (Modified <> ZERO_DATE) then begin
		FIndy.Request.LastModified := modified - OffsetFromUTC;
	end;
	FIndy.Request.AcceptEncoding := '';
	FIndy.Request.Accept := 'text/html';
	ResStream := TMemoryStream.Create;
	try
		try
			ResStream.Clear;
			{$IFDEF DEBUG}
			Writeln('URL: ' + URL);
			{$ENDIF}
			FIndy.Get(URL, ResStream);
			Item.Content := GikoSys.GzipDecompress(ResStream, FIndy.Response.ContentEncoding);
			Item.LastModified := FIndy.Response.LastModified;
			//擾łPoCgOƂĂƂ̓}CiX
			Item.ContentLength := Length(Item.Content);
			//ƎvǁBBB
			if Item.Content = '' then
				Result := False
			else
				Result := True;
			{$IFDEF DEBUG}
			Writeln('擾ŗOȂ');
			{$ENDIF}
			ResponseCode := FIndy.ResponseCode;
		except
			on E: EIdSocketError do begin
				Item.Content := '';
				Item.LastModified := ZERO_DATE;
				Item.ContentLength := 0;
				Item.ErrText := E.Message;
				Result := False;
				ResponseCode := -1;
				Screen.Cursor := crDefault;
			end;
			on E: EIdConnectException do begin
				Item.Content := '';
				Item.LastModified := ZERO_DATE;
				Item.ContentLength := 0;
				Item.ErrText := E.Message;
				Result := False;
				ResponseCode := -1;
				Screen.Cursor := crDefault;
			end;
			on E: Exception do begin
				{$IFDEF DEBUG}
				Writeln('擾ŗO');
				Writeln('E.Message: ' + E.Message);
				{$ENDIF}
				Item.Content := '';
				Item.LastModified := ZERO_DATE;
				Item.ContentLength := 0;
				Item.ErrText := E.Message;
				ResponseCode := FIndy.ResponseCode;
				Result := False;
				Screen.Cursor := crDefault;
			end;
		end;
	finally
		if (Item.ContentLength = 0) and (ResponseCode = 206) then
			Item.ResponseCode := 304
		else
			Item.ResponseCode := ResponseCode;
		ResStream.Free;
	end;
end;

function TDownloadThread.DatDownload(ItemType: TGikoDownloadType; URL: string; Modified: TDateTime; RangeStart: Integer; AdjustLen: Integer): Boolean;
var
	ResponseCode: Integer;
	ResStream: TMemoryStream;
begin
	ResponseCode := -1;
	if (ItemType = gdtThread) and (RangeStart > 0) then begin
		FIndy.Request.ContentRangeStart := RangeStart + AdjustLen;
		FIndy.Request.ContentRangeEnd := 0;
	end else begin
		FIndy.Request.ContentRangeStart := 0;
		FIndy.Request.ContentRangeEnd := 0;
	end;

	FIndy.Request.CustomHeaders.Clear;
	FIndy.Request.CacheControl := 'no-cache';
	FIndy.Request.CustomHeaders.Add('Pragma: no-cache');
	if (Modified <> 0) and (Modified <> ZERO_DATE) then begin
		FIndy.Request.LastModified := modified - OffsetFromUTC;
	end;
	if RangeStart = 0 then
		FIndy.Request.AcceptEncoding := 'gzip'
	else
		FIndy.Request.AcceptEncoding := '';
	ResStream := TMemoryStream.Create;
	try
		try
			ResStream.Clear;
			{$IFDEF DEBUG}
			Writeln('URL: ' + URL);
			{$ENDIF}
			FIndy.Get(URL, ResStream);
            Item.Content := GikoSys.GzipDecompress(ResStream, FIndy.Response.ContentEncoding);
			Item.LastModified := FIndy.Response.LastModified;
			//擾łPoCgOƂĂƂ̓}CiX
//			Item.ContentLength := FIndy.Response.ContentLength + AdjustLen;
			Item.ContentLength := Length(Item.Content) + AdjustLen;
			//ƎvǁBBB
//			if (FIndy.ResponseCode in [200, 206]) and (Item.Content = '') then
//				Result := False
			if Item.Content = '' then
				Result := False
			else
				Result := True;
			{$IFDEF DEBUG}
			Writeln('擾ŗOȂ');
			{$ENDIF}
			ResponseCode := FIndy.ResponseCode;
		except
			on E: EIdSocketError do begin
				Item.Content := '';
				Item.LastModified := ZERO_DATE;
				Item.ContentLength := 0;
				Item.ErrText := E.Message;
				Result := False;
				ResponseCode := -1;
				Screen.Cursor := crDefault;
			end;
			on E: EIdConnectException do begin
				Item.Content := '';
				Item.LastModified := ZERO_DATE;
				Item.ContentLength := 0;
				Item.ErrText := E.Message;
				Result := False;
				ResponseCode := -1;
				Screen.Cursor := crDefault;
			end;
			on E: Exception do begin
				{$IFDEF DEBUG}
				Writeln('擾ŗO');
				Writeln('E.Message: ' + E.Message);
				{$ENDIF}
				Item.Content := '';
				Item.LastModified := ZERO_DATE;
				Item.ContentLength := 0;
				Item.ErrText := E.Message;
				ResponseCode := FIndy.ResponseCode;
				Result := False;
				Screen.Cursor := crDefault;
			end;
		end;
	finally
		if (Item.ContentLength = 0) and (ResponseCode = 206) then
			Item.ResponseCode := 304
		else
			Item.ResponseCode := ResponseCode;
		ResStream.Free;
	end;
end;

procedure TDownloadThread.FireDownloadEnd;
begin
	OnDownloadEnd(self, Item);
end;

procedure TDownloadThread.FireDownloadMsg;
begin
	OnDownloadMsg(Self, Item, FMsg, FIcon);
end;

procedure TDownloadThread.GetSessionID;
begin
	FSessionID := GikoSys.Dolib.SessionID;
end;

procedure TDownloadThread.Abort;
begin
	FAbort := True;
	FIndy.DisconnectSocket;
	if socket <> nil then begin
		socket.DisconnectSocket;
	end;
end;

procedure TDownloadThread.WorkBegin(Sender: TObject; AWorkMode: TWorkMode; const AWorkCountMax: Integer);
begin
	if Assigned(OnWorkBegin) then
		OnWorkBegin(Sender, AWorkMode, AWorkCountMax, FNumber, FDownloadTitle);
end;

procedure TDownloadThread.WorkEnd(Sender: TObject; AWorkMode: TWorkMode);
begin
	if Assigned(OnWorkEnd) then
		OnWorkEnd(Sender, AWorkMode, FNumber);
end;

procedure TDownloadThread.Work(Sender: TObject; AWorkMode: TWorkMode; const AWorkCount: Integer);
begin
	if Assigned(OnWork) then
		OnWork(Sender, AWorkMode, AWorkCount, FNumber);
end;

function TDownloadThread.ParseCgiStatus(Content: string): TCgiStatus;
var
	StatusLine: string;
	Line: string;
	Idx: Integer;
	Status: string;
	Size: string;
	Msg: string;
begin
// [+OK] ̏ꍇ͍
// [-INCR] (Incorrect)̏ꍇׂ͂Ẵf[^
// [-ERR (eLXg)]̏ꍇ͂Ȃ񂩃G[
// F+OK 23094/512K
//		 -INCR 23094/512K
//		 -ERR ȔȂł
	Idx := AnsiPos(#10, Content);
	StatusLine := Copy(Content, 0, Idx);

	Idx := AnsiPos(' ', Content);
	Status := Copy(StatusLine, 0, Idx - 1);
	Line := Copy(StatusLine, Idx + 1, Length(StatusLine));

//	Idx := AnsiPos('/', Line);
	if Trim(Status) = '-ERR' then
		Msg := Trim(Line)
	else
		Size := Copy(Line, 0, Idx - 1);

	if Trim(Status) = '+OK' then
		Result.FStatus := gcsOK
	else if Trim(Status) = '-INCR' then
		Result.FStatus := gcsINCR
	else if Trim(Status) = '-ERR' then begin
		Result.FStatus := gcsERR;
		Result.FErrText := Msg;
		Result.FSize := 0;
		Exit;
	end else begin
		{$IFDEF DEBUG}
		Writeln(Status);
		{$ENDIF}
		Result.FStatus := gcsERR;
		Result.FErrText := 'G[Ȃ񂾂ǁA悭ȂG[';
		Result.FSize := 0;
		Exit;
	end;

	if GikoSys.IsNumeric(Size) then
		Result.FSize := StrToInt(Size)
	else begin
		Result.FSize := 0;
		Result.FStatus := gcsERR;
		Result.FErrText := 'Xe[^X͎s[' + StatusLine + ']';
	end;
end;

//PsڂāARecTCYݒ肷
procedure TDownloadThread.DeleteStatusLine(Item: TDownloadItem);
var
	SList: TStringList;
begin
	SList := TStringList.Create;
	try
		SList.Text := Item.Content;
		//1sڂ폜
		if SList.Count > 1 then
			SList.Delete(0);
        Item.Content := SList.Text;
		//sR[hCRLF -> LFƍlāAs}CiX
        Item.ContentLength := Length(SList.Text) - SList.Count;
	finally
		SList.Free;
	end;
end;

procedure TDownloadItem.SaveListFile;
var
	i: Integer;
	index: Integer;
	NewItem: TThreadItem;
	NumCount: Integer;
	Body: TStringList;
	Rec: TSubjectRec;
	{$IFDEF DEBUG}
	st, rt : Cardinal;
	{$ENDIF}
	function MakeThreadCallBack(
		inInstance	: DWORD;	// TBoardItem ̃CX^X
		inURL				: PChar;	// Xbh URL
		inTitle			: PChar;	// X^C
		inCount			: DWORD		// X̐
	) : Boolean; stdcall;		// 񋓂𑱂Ȃ True
	var
		_ThreadItem	: TThreadItem;	// '_' ̓NX̃vpeBƂԂĂ̂
		boardItem		: TBoard;
	begin
		Result		:= True;
		boardItem	:= TBoard( inInstance );

		boardItem.IntData := boardItem.IntData + 1;
		if boardItem.IntData < (boardItem.Count shr	 2) then
			index := boardItem.GetIndexFromURL( string( inURL ) )
		else
			index := boardItem.GetIndexFromURL( string( inURL ), True );
		if index = -1 then begin
			//VXbh
			_ThreadItem := TThreadItem.Create( boardItem.BoardPlugIn, boardItem, string( inURL ) );

			_ThreadItem.Title					:= string( inTitle );
			_ThreadItem.AllResCount		:= inCount;
			_ThreadItem.ParentBoard		:= Board;
			_ThreadItem.No						:= boardItem.IntData;
			_ThreadItem.RoundDate 		:= ZERO_DATE;
			_ThreadItem.LastModified	:= ZERO_DATE;
			_ThreadItem.AgeSage	 			:= gasNew;
			boardItem.Add(_ThreadItem);
		end else begin
			//ʂオĂAgeɂ
			if boardItem.Items[index].No > boardItem.IntData then
				boardItem.Items[index].AgeSage := gasAge
			//ʂオĂȂǁAXĂASage
			else if boardItem.Items[index].AllResCount <> inCount then
				boardItem.Items[index].AgeSage := gasSage
			//ʏオĂȂAX̑΁ANone
			else
				boardItem.Items[index].AgeSage := gasNone;

			boardItem.Items[index].No						:= boardItem.IntData;
			boardItem.Items[index].AllResCount	:= inCount;
		end;

	end;
begin
{$IFDEF DEBUG}
	st := GetTickCount;
	Writeln('SAVELIST');
{$ENDIF}
	//Board.ListData := TList.Create;
	Body := TStringList.Create;
	try
		//_E[hݒi[Jj
		Board.RoundDate := Now;
		//T[ot@C̍XVݒ
		Board.LastModified := LastModified;


		//datX̃\[g肷邽߂Ƀ\[g
		if GikoSys.Setting.DatOchiSortIndex >= 0 then begin
			Sort.SortNoFlag := true;
			Sort.SortOrder := GikoSys.Setting.DatOchiSortOrder;
			Sort.SortIndex := GikoSys.Setting.DatOchiSortIndex;
			//Sort.SortNonAcquiredCountFlag := GikoSys.Setting.NonAcquiredCount;
			Board.CustomSort(ThreadItemSortProc);
		end;

{$IFDEF DEBUG}
	rt := GetTickCount - st;
	Writeln('END Sortd' + IntToStr(rt) + ' ms');
{$ENDIF}

		for i := Board.Count - 1 downto 0 do
			Board.Items[i].AgeSage := gasNull;

		if Board.IsBoardPlugInAvailable then begin
			// VXg쐬
			// VXgɌÂXg̃OȂ炻VXgɒǉ
			// ÂOȂ΁AVɃXIuWFNg쐬
			Board.IntData := 0;
{$IFDEF DEBUG}
	rt := GetTickCount - st;
	Writeln('Start Enum' + IntToStr(rt) + ' ms');
{$ENDIF}

			//ꂪx@vP
			Board.BeginUpdate;
			Board.BoardPlugIn.EnumThread( DWORD( Board ), @MakeThreadCallBack );
			Board.EndUpdate;

{$IFDEF DEBUG}
	rt := GetTickCount - st;
	Writeln('End Enum' + IntToStr(rt) + ' ms');
{$ENDIF}

			//ÂXgɂȂ폜
			for i := Board.Count - 1 downto 0 do begin
				if( Board.Items[i].AgeSage = gasNull )and not (Board.Items[i].IsLogFile) then
					Board.Delete(i);
			end;

			// VXgɖACeVXgɒǉ
			for i := 0 to Board.Count - 1 do begin
				if(Board.Items[i].AgeSage = gasNull) and (Board.Items[i].IsLogFile) then begin
					Board.IntData := Board.IntData + 1;
					Board.Items[i].No						:= Board.IntData;
					Board.Items[i].AllResCount	:= Board.Items[i].Count;
					Board.Items[i].NewResCount	:= 0;
					Board.Items[i].AgeSage			:= gasNone;
				end;
			end;

		end else begin
			//VXg쐬
			//VXgɌÂXg̃OȂ炻VXgɒǉ
			//ÂOȂ΁AVɃXIuWFNg쐬
			Body.Text := Content;
			NumCount := 0;
			for i := 0 to Body.Count - 1 do begin
				Rec := GikoSys.DivideSubject(Body[i]);
				Rec.FFileName := Trim(Rec.FFileName);
				if (Rec.FTitle = '') and (Rec.FCount = 0) then Continue;
				Inc(NumCount);
				index := Board.GetIndexFromFileName(Rec.FFileName);
				if index = -1 then begin
					//VXbh
					NewItem := TThreadItem.Create(
								nil,
                                Board,
                                GikoSys.Get2chBoard2ThreadURL( Board, ChangeFileExt( Rec.FFileName, '' ) ) );
					NewItem.Title := Rec.FTitle;
					NewItem.AllResCount := Rec.FCount;
					NewItem.ParentBoard := Board;
					NewItem.No := NumCount;
					NewItem.RoundDate := ZERO_DATE;
					NewItem.LastModified := ZERO_DATE;
					NewItem.AgeSage := gasNew;
					Board.Add(NewItem);
				end else begin
					if Board.Items[index].No > NumCount then
						Board.Items[index].AgeSage := gasAge
					else if Board.Items[index].AllResCount < Rec.FCount then
						Board.Items[index].AgeSage := gasSage
					else
						Board.Items[index].AgeSage := gasNone;

					Board.Items[index].No := NumCount;
					Board.Items[index].AllResCount := Rec.FCount;
				end;
			end;
			//ÂXg̍폜
			for i := Board.Count - 1 downto 0 do begin
				if( Board.Items[i].AgeSage = gasNull )and not (Board.Items[i].IsLogFile) then
					Board.Delete(i);
			end;

			//VXgɖACe̍XV
			for i := 0 to Board.Count - 1 do begin
				if( Board.Items[i].AgeSage = gasNull )and (Board.Items[i].IsLogFile) then begin
					inc(NumCount);
					Board.Items[i].No := NumCount;
					Board.Items[i].AllResCount := Board.Items[i].Count;
					Board.Items[i].NewResCount := 0;
					Board.Items[i].AgeSage := gasNone;
				end;
			end;
			//Xg(subject.txt)ۑ
			GikoSys.ForceDirectoriesEx(ExtractFilePath(Board.GetSubjectFileName));
			Body.SaveToFile(Board.GetSubjectFileName);
		end;
	finally
		Body.Free;
	end;


end;

{procedure TDownloadItem.SaveListFile;
var
	i: Integer;
	index: Integer;
	NewItem: TThreadItem;
	NewList: TList;
//	SaveCount: Integer;
	NumCount: Integer;
	Body: TStringList;
	Rec: TSubjectRec;
begin
	NewList := TList.Create;
	Body := TStringList.Create;
	try
		//ݒ
		Board.RoundDate := Now;
		//T[ot@C̍XVݒ
		Board.LastModified := LastModified;

		//Xgۑ擾
		//SaveCount := MaxInt;

		//ÂXg烍OACe폜
		for i := Board.Count - 1 downto 0 do
			if not Board.Items[i].IsLogFile then
				Board.Delete(i);

		//VXg쐬
		//VXgɌÂXg̃OȂ炻VXgɒǉ
		//ÂOȂ΁AVɃXIuWFNg쐬
		Body.Text := Content;
//		Loop := Min(Body.Count, SaveCount);
		NumCount := 0;
//		for i := 0 to Loop - 1 do begin
		for i := 0 to Body.Count - 1 do begin
			if i = 0 then Continue;	//Psڂ̓Xe[^XŝߏȂ

			Rec := GikoSys.DivideSubject(Body[i]);
			if (Rec.FTitle = '') and (Rec.FCount = 0) then Continue;
			Inc(NumCount);
			index := Board.GetIndex(Rec.FFileName);
			if index = -1 then begin
				NewItem := TThreadItem.Create;
				NewItem.FileName := Rec.FFileName;
				NewItem.Title := Rec.FTitle;
				NewItem.Count := Rec.FCount;
				NewItem.ParentBoard := Board;
				NewItem.No := NumCount;
				NewItem.RoundDate := ZERO_DATE;
				NewItem.LastModified := ZERO_DATE;
				NewList.Add(NewItem);
			end else begin
				//Board.Items[index].Count := Count;
				Board.Items[index].No := NumCount;
				NewList.Add(Board.Items[index]);
				Board.DeleteList(index);
			end;
		end;

		//VXgɖÂOLACeVXgɒǉ
		for i := 0 to Board.Count - 1 do begin
			inc(NumCount);
			Board.Items[i].No := NumCount;
			NewList.Add(Board.Items[i]);
		end;

		//ÂXgiXĝ݁BXIuWFNĝ͏Ȃj
		for i := Board.Count - 1 downto 0 do
			Board.DeleteList(i);

		//VXg{[hIuWFNgɒǉ
		for i := 0 to NewList.Count - 1 do
			Board.Add(TThreadItem(NewList[i]));

		//Xg(subject.txt)ۑ
//		GikoSys.ForceDirectoriesEx(GikoSys.GetLogDir + Board.BBSID);
//		Body.SaveToFile(GikoSys.GetSubjectFileName(Board.BBSID));
		GikoSys.ForceDirectoriesEx(ExtractFilePath(Board.GetSubjectFileName));
		Body.SaveToFile(Board.GetSubjectFileName);
	finally
		Body.Free;
		NewList.Free;
	end;
end;
}
procedure TDownloadItem.SaveItemFile;
var
	Body, oldBody: TStringList;
	Cnt: Integer;
	OldCnt: Integer;
	FileName: string;
	ini: TMemIniFile;
	Res: TResRec;
	NewRes: Integer;
	finish : Boolean;
	loopCnt : Integer;
	LastIdx	: Integer;
begin
	FileName := ThreadItem.GetThreadFileName;

	//if not ThreadItem.IsBoardPlugInAvailable then begin
    if not ThreadItem.ParentBoard.IsBoardPlugInAvailable then begin
		if Trim(Content) = '' then
			Exit;

		GikoSys.ForceDirectoriesEx(ExtractFilePath(FileName));

		//	Cnt := 0;
		Body := TStringList.Create;
		NewRes := 0;
		OldCnt := 0;
		try
		//		if FileExists(FileName) and (ResponseCode = 206) then begin
			if FileExists(FileName) and (State = gdsDiffComplete) then begin
				loopCnt := 10;
				repeat
					finish := true;
					try
						Body.LoadFromFile(FileName);
						OldCnt := Body.Count;
						Body.Text := Body.Text + Content;
						Body.SaveToFile(FileName);
						NewRes := Body.Count - OldCnt;
					except
						on E:EFOpenError do begin
							sleep(10);
							Dec(loopCnt);
							if loopCnt > 0 then
								finish := false;
						end;
					end;
				until finish;
				//Cnt := Body.Count;
			end else begin
				if IsAbone then begin
					// ځ[ôł܂œǂ񂾂ƐVXԂ̂Ȃ
					oldBody := TStringList.Create;
					try
						loopCnt := 10;
						repeat
							finish := true;
							try
								oldBody.LoadFromFile(FileName);
							except
								on E:EFOpenError do begin
									sleep(10);
									Dec(loopCnt);
									if loopCnt > 0 then
										finish := false
									else
										finish := true;
								end;
							end;
						until finish;

						Body.Text := Content;
						if (ThreadItem.Kokomade > 0) and (ThreadItem.Kokomade <= oldBody.Count) then begin
							ThreadItem.Kokomade := Body.IndexOf(oldBody.Strings[ ThreadItem.Kokomade - 1 ]);
							if ThreadItem.Kokomade <> -1 then ThreadItem.Kokomade := ThreadItem.Kokomade + 1;
						end;

						LastIdx := oldBody.Count;
						repeat
							Dec(LastIdx);
							OldCnt := Body.IndexOf(oldBody.Strings[ LastIdx ]) + 1;
						until ( OldCnt <> 0 ) or (LastIdx = 0);

						if OldCnt >= Body.Count then OldCnt := Body.Count - 1;
						NewRes := Body.Count - OldCnt;

						// ܂œǂ񂾂VXԂ𒴂Ȃ悤(ُĨJo)
						if ThreadItem.Kokomade > OldCnt then begin
							if OldCnt > 0 then
								ThreadItem.Kokomade := OldCnt
							else
								ThreadItem.Kokomade := 1;
						end;

					finally
						oldBody.Free;
					end;

				end else begin
					Body.Text := Content;
					//ThreadItem.Count := 0;
					OldCnt := 0;
					NewRes := Body.Count;
					//Cnt := Body.Count;
				end;
	//			if Body.Count > 0 then
	//				Body.Delete(0);
				Body.SaveToFile(FileName);

				if ThreadItem.Title = '' then begin
					THTMLCreate.DivideStrLine(Body[0], @Res);
					ThreadItem.Title := Res.FTitle;
				end;
				ThreadItem.Size := 0;
			end;
			Cnt := Body.Count;
		finally
			Body.Free;
		end;

		ThreadItem.Size := ThreadItem.Size + ContentLength;
		ThreadItem.LastModified := LastModified;
		ThreadItem.Count := Cnt;
		//ThreadItem.AllResCount := Cnt;
		ThreadItem.NewResCount := NewRes;
		ThreadItem.NewReceive := OldCnt + 1;
	end;
	ThreadItem.AllResCount := ThreadItem.Count;
	ThreadItem.IsLogFile := True;
	ThreadItem.RoundDate := Now;
	if not ThreadItem.UnRead then begin
		ThreadItem.UnRead := True;
	end;
//	if ThreadItem.RoundNo = 6 then
//		ThreadItem.RoundNo := 0;

	//ُI̓CfbNXXVȂ߁Ae|쐬B
	//Iɂ͍폜
	//ُÍANɃe|čXV
	ini := TMemIniFile.Create(ChangeFileExt(FileName, '.tmp'));
	try
		ini.WriteDateTime('Setting', 'RoundDate', ThreadItem.RoundDate);
		ini.WriteDateTime('Setting', 'LastModified', ThreadItem.LastModified);
		ini.WriteInteger('Setting', 'Size', ThreadItem.Size);
		ini.WriteInteger('Setting', 'Count', ThreadItem.Count);
		ini.WriteInteger('Setting', 'AllResCount', ThreadItem.AllResCount);
		ini.WriteInteger('Setting', 'NewResCount', ThreadItem.NewResCount);
		ini.WriteInteger('Setting', 'NewReceive', ThreadItem.NewReceive);
//		ini.WriteInteger('Setting', 'RoundNo', ThreadItem.RoundNo);
//		ini.WriteBool('Setting', 'Round', ThreadItem.Round);
		ini.WriteBool('Setting', 'UnRead', ThreadItem.UnRead);
		ini.UpdateFile;
	finally
		ini.Free;
	end;
end;

end.
