unit Editor;

interface

uses
	Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms,
	Dialogs, StdCtrls, ComCtrls, ExtCtrls, ToolWin, Menus, OleCtrls, Registry,
{$IF Defined(DELPRO) }
	SHDocVw,
	MSHTML,
{$ELSE}
	SHDocVw_TLB,
	MSHTML_TLB,
{$IFEND}
	ActiveX, {HTTPApp,} YofUtils, IniFiles, StrUtils,
	GikoSystem, GikoUtil, ImgList, Clipbrd, BoardGroup,
	IdAntiFreezeBase,	IdAntiFreeze, IdBaseComponent, IdComponent,
	IdTCPConnection, IdTCPClient, IdHTTP, ActnList, StdActns, IdIntercept,
	IdLogBase, IdLogDebug, IdException, DateUtils,  bmRegExp,
	Gesture, AppEvnts, SambaTimer, IdCookieManager;

type
//	TSetLayeredWindowAttributes = function(wnd: HWND; crKey: DWORD; bAlpha: BYTE; dwFlag: DWORD): Boolean; stdcall;
	//ݖ߂l^Cv
	TGikoResultType = (grtOK, grtCookie, grtCheck, grtError, grtNinpou, grtNinpouErr, grtSuiton);

	TEditorForm = class(TForm)
		MainMenu: TMainMenu;
		FileMenu: TMenuItem;
		PostMessage: TMenuItem;
		SaveMessage: TMenuItem;
		CloseMenu: TMenuItem;
		N01: TMenuItem;
		StatusBar: TStatusBar;
	EditorPage: TPageControl;
		EditorTab: TTabSheet;
		PreviewTab: TTabSheet;
		Browser: TWebBrowser;
		EditMenu: TMenuItem;
		UndoMenu: TMenuItem;
		CutMenu: TMenuItem;
		CopyMenu: TMenuItem;
		PasteMenu: TMenuItem;
		N02: TMenuItem;
		ToolBarImageList: TImageList;
		HotToobarImageList: TImageList;
		NameBasePanel: TPanel;
		NameLabel: TLabel;
		MailLabel: TLabel;
		NameComboBox: TComboBox;
		MailComboBox: TComboBox;
		ToolBar: TToolBar;
		SendToolButton: TToolButton;
		OutBoxToolButton: TToolButton;
		ToolButton5: TToolButton;
		UndoToolButton: TToolButton;
		CutToolButton: TToolButton;
		CopyToolButton: TToolButton;
		PasteToolButton: TToolButton;
		ToolButton3: TToolButton;
		TransToolButton: TToolButton;
		TopToolButton: TToolButton;
		Indy: TIdHTTP;
		IdAntiFreeze: TIdAntiFreeze;
		ToolButton1: TToolButton;
		ToolButton2: TToolButton;
		ActionList: TActionList;
		SendAction: TAction;
		SaveAction: TAction;
		CloseAction: TAction;
		UndoAction: TAction;
		CutAction: TAction;
		CopyAction: TAction;
		PasteAction: TAction;
		AbortAction: TAction;
		TopAction: TAction;
		Show1: TMenuItem;
		T1: TMenuItem;
		N1: TMenuItem;
		S1: TMenuItem;
		SageCheckBox: TCheckBox;
		IdLogDebug: TIdLogDebug;
		TransAction: TAction;
		A1: TMenuItem;
		KotehanCheckBox: TCheckBox;
		TitlePanel: TPanel;
		Label1: TLabel;
		TitleEdit: TEdit;
		SelectAllAction: TAction;
		N2: TMenuItem;
		SelectAll1: TMenuItem;
	QuotePasteAction: TAction;
	QuotePasteMenuItem: TMenuItem;
	C1: TMenuItem;
	SpaceToNBSPAction: TAction;
	AmpToCharRefAction: TAction;
	SpaceTabnbsp1: TMenuItem;
	amp1: TMenuItem;
	BoardInformationTab: TTabSheet;
				BoardtopTab: TTabSheet;
	TitlePictureBrowser: TWebBrowser;
	BoardTop: TMenuItem;
	BoardInformationMemo: TMemo;
	GetSETTINGTXTAction: TAction;
	N3: TMenuItem;
	SETTINGTXT2: TMenuItem;
	GetTitlePictureAction: TAction;
	OP1: TMenuItem;
    GetHeadTXTAction: TAction;
    HeadTXT1: TMenuItem;
    RocalRuleTab: TTabSheet;
    WebBrowser1: TWebBrowser;
    CalcCapacityAction: TAction;
    N4: TMenuItem;
    N5: TMenuItem;
    LocalRule: TMenuItem;
    LocalEdit: TMemo;
    N6: TMenuItem;
    LocalRuleBrowse: TMenuItem;
	ToolButton4: TToolButton;
    ToolButton6: TToolButton;
    SaveNameMailAction: TAction;
    ToolButton7: TToolButton;
    BeLogInOutEAction: TAction;
    UpdateSambaAction: TAction;
    Samba241: TMenuItem;
    N7: TMenuItem;
    InputAssistAction: TAction;
    InputAssistPopupMenu: TPopupMenu;
    BodyEdit: TMemo;
    ApplicationEvents1: TApplicationEvents;
    ToolButton8: TToolButton;
    ToolButton9: TToolButton;
    ShowInputAssistForm: TAction;
    ReleaseCookieAction: TAction;
    Cookie1: TMenuItem;
    ContinueModeAction: TAction;
    ToolButton10: TToolButton;
    ToolButton11: TToolButton;
    OpenSendTargetAction: TAction;
    ReloadTargetAction: TAction;
    N8: TMenuItem;
    N9: TMenuItem;
    N10: TMenuItem;

		procedure EditorPageChange(Sender: TObject);
		procedure FormCreate(Sender: TObject);
		procedure BrowserStatusTextChange(Sender: TObject;
			const Text: WideString);
		procedure FormClose(Sender: TObject; var Action: TCloseAction);
		procedure FormDestroy(Sender: TObject);
		procedure SendActionExecute(Sender: TObject);
		procedure SaveActionExecute(Sender: TObject);
		procedure AbortActionExecute(Sender: TObject);
		procedure CloseActionExecute(Sender: TObject);
		procedure UndoActionExecute(Sender: TObject);
		procedure CutActionExecute(Sender: TObject);
		procedure CopyActionExecute(Sender: TObject);
		procedure PasteActionExecute(Sender: TObject);
		procedure SendActionUpdate(Sender: TObject);
		procedure SaveActionUpdate(Sender: TObject);
		procedure CloseActionUpdate(Sender: TObject);
		procedure UndoActionUpdate(Sender: TObject);
		procedure CutActionUpdate(Sender: TObject);
		procedure CopyActionUpdate(Sender: TObject);
		procedure PasteActionUpdate(Sender: TObject);
		procedure TopActionExecute(Sender: TObject);
		procedure TopActionUpdate(Sender: TObject);
		procedure SageCheckBoxClick(Sender: TObject);
		procedure MailComboBoxChange(Sender: TObject);
		procedure TransActionExecute(Sender: TObject);
		procedure TransActionUpdate(Sender: TObject);
		procedure IdLogDebugReceive(ASender: TIdConnectionIntercept;
			AStream: TStream);
		procedure IdLogDebugSend(ASender: TIdConnectionIntercept;
			AStream: TStream);
		procedure SelectAllActionExecute(Sender: TObject);
	procedure StatusBarResize(Sender: TObject);
	procedure FormActivate(Sender: TObject);
	procedure FormCloseQuery(Sender: TObject; var CanClose: Boolean);
		procedure QuotePasteActionExecute(Sender: TObject);
	procedure SpaceToNBSPActionExecute(Sender: TObject);
	procedure AmpToCharRefActionExecute(Sender: TObject);
	procedure BoardTopClick(Sender: TObject);
	procedure GetSETTINGTXTActionExecute(Sender: TObject);
	procedure GetTitlePictureActionUpdate(Sender: TObject);
	procedure GetTitlePictureActionExecute(Sender: TObject);
    procedure GetHeadTXTActionExecute(Sender: TObject);
	procedure CalcCapacityActionExecute(Sender: TObject);
    procedure LocalRuleClick(Sender: TObject);
    procedure FormDeactivate(Sender: TObject);
    procedure LocalRuleBrowseClick(Sender: TObject);
    procedure SaveNameMailActionExecute(Sender: TObject);
    procedure BeLogInOutEActionExecute(Sender: TObject);
    procedure BeLogInOutEActionUpdate(Sender: TObject);
    procedure UpdateSambaActionUpdate(Sender: TObject);
    procedure UpdateSambaActionExecute(Sender: TObject);
    procedure InputAssistActionExecute(Sender: TObject);
    procedure ApplicationEvents1Message(var Msg: tagMSG;
      var Handled: Boolean);
    procedure ShowInputAssistFormExecute(Sender: TObject);
    procedure ReleaseCookieActionExecute(Sender: TObject);
    procedure GetSETTINGTXTActionUpdate(Sender: TObject);
    procedure GetHeadTXTActionUpdate(Sender: TObject);
    procedure ContinueModeActionExecute(Sender: TObject);
    procedure ContinueModeActionUpdate(Sender: TObject);
    procedure OpenSendTargetActionExecute(Sender: TObject);
    procedure ReloadTargetActionExecute(Sender: TObject);
	private
		FThreadItem: TThreadItem;
		FBoard: TBoard;
		FNameComboEdit: THandle;
		FMailComboEdit: THandle;
		FAbort: Boolean;
		FWork: Boolean;
		FStatusCode: Integer;
		FDebugStrReceive: string;
		FDebugStrSend: string;
		FNow: TDateTime;
		FInputAssistKey: String;	///< ̓AVXg̃L[
		FResistWords: TStringList;	///< ̓AVXg̎̌
        FSambaTimer: TSambaTimer;   ///< Samba΍̃^C}[
        FCookieDomain: string;        ///< E@hC
		procedure Preview;
		function Check: Boolean;
		procedure SetNameList(sName, sMail: string);
		procedure Send(const ACOOKIE: string; const SPID: string; const PON: string; FirstWriting: Boolean);
		function GetActiveControlHandle: THandle;
		procedure GetSendData(Source: TStringStream);
		procedure SaveSendFile;
		procedure SetContent(Content: string; ABrowser: TWebBrowser);
		function GetResultType(ResponseText: string): TGikoResultType;
		/// {̎擾
		function GetBody : string;
		//IdHttp̏
		procedure InitIdHTTP(http: TIdHTTP);
		procedure ShowBoardInformation(ABoard: TBoard; AMemo: TMemo);
		function GetTitlePictureURL(body: TStringList; ABoard: TBoard): string;
		procedure ShowTitlePicture();
				function GetFusianaName(body: TStringList; ABoard: TBoard): String;
		//! }EXWFX`[Jn
		procedure OnGestureStart(Sender: TObject);
		//! }EXWFX`[
		procedure OnGestureMove(Sender: TObject);
		//! }EXWFX`[I
		procedure OnGestureEnd(Sender: TObject);
				//HEAD.TXT\
				procedure ShowBoardHead(ABoard: TBoard; AMemo: TMemo);
				//LocalFusianaTrapAlart
				function LFusianaGet(const s: String): Boolean;
		// Cookie̎擾
		procedure GetCookie(CookieMng: TIdCookieManager; ABoard: TBoard);
        // hiddenf[^擾
        procedure GetHiddenParameter(Rawtext: String; ABoard: TBoard);
		//! ̓AVXg̃|bvAbvj[̃NbNCxg
		procedure InputAssistMenuClick(Sender: TObject);
		//! TMemõJ[\ʒuɕ}
		procedure InsertText(Memo: TMemo; Text: String);
		//! M~
		procedure CancelSend(ABoard: TBoard; ASysMenu: HMENU);
        //! Samba^C}[Cxg
        procedure SambaTimer(Sender: TObject);
        //! EBhËʒuƃTCY̐ݒ
        procedure SetWindowRect;
        //! g^uݒ
        procedure SetExtraTab;
        //! 擾
        function GetBoard : TBoard;
        //! URL̃f[^streamɎ荞 
        procedure GetWebData(const URL: string; const RefURL: string;
             Modified: TDateTime; stream: TStream);
        //! GikoFormɐVbZ[Wǉ
        procedure AddFormMessageNew(icon: TGikoMessageIcon);
        //! [Jfusianagbv
        function isLocalFusianaTrap: Boolean;
        //! [Jfusianagbv
        function isRemoteFusianaTrap: Boolean;
        //! Header擾
        function getHeaderStr(const ACOOKIE: string; const SPID : string;
            const PON : string; const HAP : string; Board : TBoard) : string;
        //! fusianax_CAO
        function FusianaMsgBox: Integer;
        //! sent.init@C̐
        function CreateSentIniFile: TMemIniFile;
        //! 딚`FbN
        function isGobaku: Boolean;
	protected
		procedure CreateParams(var Params: TCreateParams); override;
	public
		FBBSID: String;
		procedure SetFont;
		procedure SetThreadItem(Item: TThreadItem);
		procedure SetBoard(Item: TBoard);
        procedure UpdateSambaStatus;
		property BBSID: string read FBBSID write FBBSID;
	end;

implementation

uses
	Giko, ItemDownload, MojuUtils, IdGlobal, GikoMessage,  Imm,
  InputAssistDataModule, InputAssist, HTMLCreate, IdCookie, GikoDataModule,
  Belib;
const
	CAPTION_NAME_NEW: string = 'MRir XăGfB^';
	CAPTION_NAME_RES: string = 'MRir XGfB^';

	// GfBbgEBhEEɂ炵ĊJړ
	WINDOWMOVE_H = 30;
	WINDOWMOVE_V = 30;

	//DAXض!(LM)
	READCGI_ERR		 	= '-ERR';
	READCGI_INCR		= '-INCR';
	READCGI_OK			= '+OK';
	READCGI_PARTIAL = '+PARTIAL';
	READCGI_ERR_FOUND_KAKO	= '-ERR ߋOqɂŔ';
	READCGI_ERR_NOT_HTML		= '-ERR html҂';
	READCGI_ERR_NOT_FOUND	 	= '-ERR ȔorXbhȂłB';
	READCGI_ERR_ABONE			 	= '-ERR ǂłځ[񂪂݂łB';
	READCGI_ERR_TIMEOUT		 	= '-ERR w莞Ԃ߂܂B';
	READCGI_ERR_CANTUSE		 	= '-ERR @܂';
	RES2CH_TRUE			 	= '<!-- 2ch_X:true -->';
	RES2CH_FALSE			= '<!-- 2ch_X:false -->';
	RES2CH_ERROR			= '<!-- 2ch_X:error -->';
	RES2CH_CHECK			= '<!-- 2ch_X:check -->';
	RES2CH_COOKIE		 	= '<!-- 2ch_X:cookie -->';

type
	TSelection = record
		StartPos, EndPos: Integer;
	end;

{$R *.DFM}

{constructor TEditorForm.Create(AOwner: TComponent; Item: TBoard);
begin
	inherited Create(AOwner);
end;}

procedure TEditorForm.CreateParams(var Params: TCreateParams);
begin
	inherited;
	if FormStyle in [fsNormal, fsStayOnTop] then
		if BorderStyle in [bsSingle, bsSizeable] then begin
			Params.ExStyle := Params.ExStyle or WS_EX_APPWINDOW;
			Params.WndParent := 0;
		end;
end;

{procedure TEditorForm.CreateParams(var Params: TCreateParams);
begin
	inherited CreateParams(Params);
	Params.ExStyle := Params.ExStyle or WS_EX_APPWINDOW;
end;}

procedure TEditorForm.FormCreate(Sender: TObject);
begin
	FWork := False;
    FSambaTimer := TSambaTimer.Create(Self);
    FSambaTimer.Interval := 0;
	Browser.Navigate('about:blank');
	TitlePictureBrowser.Navigate('about:blank');
    WebBrowser1.Navigate('about:blank');
	FBoard := nil;
	FThreadItem := nil;

    if (Owner <> nil) and (Owner.ClassNameIs('TKeySettingForm') = False) then
    	//EBhËʒuݒ
        SetWindowRect;

	EditorPage.ActivePage := EditorTab;
	FNameComboEdit := GetWindow(NameComboBox.Handle, GW_CHILD);
	FMailComboEdit := GetWindow(MailComboBox.Handle, GW_CHILD);
	NameComboBox.Items.Assign(GikoSys.Setting.NameList);
	MailComboBox.Items.Assign(GikoSys.Setting.MailList);
	SetFont;
    // p\ݒ
    TransAction.Enabled := GikoSys.CanUser32DLL;

    // EBhẼXeC
	if GikoSys.Setting.EditWindowStay then begin    // XeC
		SetWindowPos(Handle, HWND_TOPMOST, 0, 0, 0, 0, SWP_NOMOVE + SWP_NOSIZE);
		TopAction.Checked := true;
		TopToolButton.Down := true;
	end else begin                                  // XeCȂ
		SetWindowPos(Handle, HWND_NOTOPMOST, 0, 0, 0, 0, SWP_NOMOVE + SWP_NOSIZE);
		TopAction.Checked := false;
		TopToolButton.Down := false;
	end;

    // EBhE̔
	if(GikoSys.Setting.EditWindowTranslucent) and (TransAction.Enabled) then begin // igX[Zgj
        AlphaBlend := true;
        TransAction.Checked := true;
        TransToolButton.Down := true;
    end else begin                                      // s
        AlphaBlend := false;
        TransAction.Checked := false;
        TransToolButton.Down := false;
    end;
        // Ԃ̕ۑ
	GikoSys.Setting.EditWindowTranslucent := TransAction.Checked;

	SpaceToNBSPAction.Checked		:= GikoSys.Setting.SpaceToNBSP;
	AmpToCharRefAction.Checked	:= GikoSys.Setting.AmpToCharRef;
    // [J[{gbv摜̃^u̐ݒ
    SetExtraTab;

	// L[ݒ̓ǂݍ
	GikoSys.LoadKeySetting(ActionList, GikoSys.GetEditorKeyFileName);
	SaveNameMailAction.Checked := True;
end;
procedure TEditorForm.SetBoard(Item: TBoard);
begin
	FBoard := Item;
	Caption := CAPTION_NAME_NEW + ' - [' + Item.Title + ']';
	NameComboBox.Text := FBoard.KotehanName;
	MailComboBox.Text := FBoard.KotehanMail;
	SageCheckBox.Checked := AnsiPos('sage', MailComboBox.Text) <> 0;
	TitlePanel.Visible := True;

    if (FSambaTimer.SetBoard(FBoard) >= 0) then begin
        UpdateSambaStatus;
        FNow := Now();
        FSambaTimer.OnTimer := SambaTimer;
    end;

	ShowBoardInformation(FBoard, BoardInformationMemo);
	ShowTitlePicture();
end;

procedure TEditorForm.SetThreadItem(Item: TThreadItem);
begin
	FThreadItem := Item;
	Caption := CAPTION_NAME_RES + ' - [' + FThreadItem.Title + ']';
	NameComboBox.Text := FThreadItem.ParentBoard.KotehanName;
	MailComboBox.Text := FThreadItem.ParentBoard.KotehanMail;
	SageCheckBox.Checked := AnsiPos('sage', MailComboBox.Text) <> 0;
	TitlePanel.Visible := False;

    if (FSambaTimer.SetBoard(FThreadItem.ParentBoard) >= 0) then begin
        UpdateSambaStatus;
        FNow := Now();
        FSambaTimer.OnTimer := SambaTimer;
    end;

	ShowBoardInformation(FThreadItem.ParentBoard, BoardInformationMemo);
	ShowTitlePicture();
end;

function TEditorForm.GetBody : string;
var
	body, tmp		: string;
	p, tail			: PChar;
	len					: Integer;
const
	TAB_LENGTH	= 4;
begin

	body := BodyEdit.Text;
	if AmpToCharRefAction.Checked then
		// & ̒u͈ԍŏɂ邱
		body := CustomStringReplace( body, '&', '&amp;' );
	if SpaceToNBSPAction.Checked then begin
		p			:= PChar( body );
		tail	:= p + Length( body );
		len		:= 0;
		while p < tail do begin
			case p^ of
			#09:
				begin
					Inc( p );
					repeat
						Inc( len );
						tmp := tmp + '&nbsp;';
					until (len mod TAB_LENGTH) = 0;
				end;

			#10, #13:
				begin
					tmp := tmp + p^;	Inc( p );
					len	:= 0;
				end;

			' ':
				begin
					tmp	:= tmp + '&nbsp;';
					Inc( p );
					Inc( len );
				end;
				
			'&':
				// ̎QƂ 1 
				begin
					tmp := tmp + '&';
					Inc( p );
					Inc( len );
					while p < tail do begin
						if p^ in ['a'..'z', 'A'..'Z', '0'..'9', '#'] then begin
							tmp := tmp + p^;
						end else if p^ = ';' then begin
							tmp := tmp + p^;
							Inc( p );
							Break;
						end else begin
							Break;
						end;
						Inc( p );
					end;
				end;

			else
				if p^ in kYofKanji then begin
					tmp := tmp + p^;	Inc( p );
					tmp	:= tmp + p^;	Inc( p );
					len	:= len + 2;
				end else begin
					tmp := tmp + p^;	Inc( p );
					Inc( len );
				end;
			end;
		end;
		body := tmp;
	end;

	Result	:= body;

end;

procedure TEditorForm.SetFont;
begin
	BodyEdit.Font.Name := GikoSys.Setting.EditorFontName;
	BodyEdit.Font.Size := GikoSys.Setting.EditorFontSize;
	BodyEdit.Font.Color := GikoSys.Setting.EditorFontColor;
	BodyEdit.Color := GikoSys.Setting.EditorBackColor;
end;

procedure TEditorForm.Preview;
var
	Title: string;
	No: string;
	Mail: string;
	Namae: string;
	Body: string;
	s: string;
begin
	if FThreadItem = nil then begin
		No := '1';
		Title := THTMLCreate.RepHtml(TitleEdit.Text);
	end else begin
		No := IntToStr(FThreadItem.Count + 1);
		Title := THTMLCreate.RepHtml(FThreadItem.Title);
	end;

	Body := GetBody;
	Namae := THTMLCreate.RepHtml(NameComboBox.Text);
	Mail := THTMLCreate.RepHtml(MailComboBox.Text);
	Body := THTMLCreate.RepHtml(Body);
	Body := CustomStringReplace(Body, #13#10, '<br>', False);


	if Trim(Namae) = '' then
		Namae := '';

    s := THTMLCreate.CreatePreviewHTML(Title, No, Mail, Namae, Body);
    
	SetContent(s, Browser);
end;

procedure TEditorForm.EditorPageChange(Sender: TObject);
var
        tmpBoard: TBoard;
begin

    tmpBoard := GetBoard;

	if tmpBoard = nil then Exit;

	if EditorPage.ActivePage = PreviewTab then begin
		Preview;
	end else if EditorPage.ActivePage = RocalRuleTab then begin
                if not FileExists(tmpBoard.GETHEADTXTFileName) then begin
                        LocalEdit.Text := '[J[擾';
                        Exit;
                end;
                ShowBoardHead(tmpBoard, LocalEdit);
        end else begin
		Browser.Navigate('about:blank');
	end;
end;

procedure TEditorForm.BrowserStatusTextChange(Sender: TObject;
	const Text: WideString);
begin
	if EditorPage.ActivePage = PreviewTab then begin
		StatusBar.Panels[0].Text := Text;
	end else begin
		StatusBar.Panels[0].Text := '';
	end;
end;

function TEditorForm.Check: Boolean;
const
	REQUIRED: string = '͂Ă܂B';
	ERROR: string = 'G[';
var
	Msg: string;
	rc: Integer;
	Board: TBoard;
begin
	Result := True;

    Board := GetBoard;

	if (not GikoSys.Setting.UseMachineTime) and
		 ((Board.LastGetTime = 0) or
			(Board.LastGetTime = ZERO_DATE)) then begin
		Msg := 'T[o̎Ȃ߁AMo܂'#13#10
				 + 'XbhXVi擾jA15b҂Ă瑗MĂ';
		MsgBox(Handle, Msg, ERROR, MB_OK or MB_ICONSTOP);
		Result := False;
	end else if BodyEdit.Text = '' then begin
		Msg := '{' + REQUIRED;
		MsgBox(Handle, Msg, ERROR, MB_OK or MB_ICONSTOP);
		Result := False;
	end else if (FBoard <> nil) and (Trim(TitleEdit.Text) = '') then begin
		Msg := '^Cg' + REQUIRED;
		MsgBox(Handle, Msg, ERROR, MB_OK or MB_ICONSTOP);
		Result := False;
	end else begin
		if (not GikoSys.Dolib.Connected) and (AnsiPos('', NameComboBox.Text) <> 0) then begin
			Msg := 'OCĂȂ̂Ł̋@\͗po܂B'#13#10
					 + '̂܂ܑMĂ낵łH';
			rc := MsgBox(Handle, Msg, 'mF', MB_YESNO or MB_ICONQUESTION);
			Result := (rc = IDYES);
		end;
	end;
end;

procedure TEditorForm.FormClose(Sender: TObject; var Action: TCloseAction);
begin
	Action := caFree;
end;

procedure TEditorForm.FormDestroy(Sender: TObject);
var
	wp: TWindowPlacement;
begin
    FSambaTimer.Free;
    
    if (Owner <> nil) and (Owner.ClassNameIs('TKeySettingForm') = False) then begin
        //ő剻EEBhEʒuۑ
        wp.length := sizeof(wp);
        GetWindowPlacement(Handle, @wp);

        GikoSys.Setting.EditWindowTop := wp.rcNormalPosition.Top;
        GikoSys.Setting.EditWindowLeft := wp.rcNormalPosition.Left;
        GikoSys.Setting.EditWindowHeight := wp.rcNormalPosition.Bottom - wp.rcNormalPosition.Top;
        GikoSys.Setting.EditWindowWidth := wp.rcNormalPosition.Right - wp.rcNormalPosition.Left;
        GikoSys.Setting.EditWindowMax := WindowState = wsMaximized;
        //GikoSys.Setting.EditWindowStay := FormStyle = fsStayOnTop;      // XeCԂ̕ۑ
        GikoSys.Setting.EditWindowTranslucent := TransAction.Checked;   // Ԃ̕ۑ
    end;

end;

procedure TEditorForm.SetNameList(sName, sMail: string);
begin
	if SaveNameMailAction.Checked then begin
		if Trim(sName) <> '' then begin
			if GikoSys.Setting.NameList.IndexOf(sName) = -1 then
				GikoSys.Setting.NameList.Insert(0, sName);
		end;
		if Trim(sMail) <> '' then begin
			if GikoSys.Setting.MailList.IndexOf(sMail) = -1 then
				GikoSys.Setting.MailList.Insert(0, sMail);
		end;
	end;
end;

function TEditorForm.GetActiveControlHandle: THandle;
begin
	if EditorPage.ActivePage = EditorTab then begin
		if ActiveControl = NameComboBox then
			Result := FNameComboEdit
		else if ActiveControl = MailComboBox then
			Result := FMailComboEdit
		else if ActiveControl = BodyEdit then
			Result := BodyEdit.Handle
		else if ActiveControl = TitleEdit then
			Result := TitleEdit.Handle
		else
			Result := 0;
	end else if Editorpage.ActivePage = BoardInformationTab then begin
		if ActiveControl = BoardInformationMemo then
			Result := BoardInformationMemo.Handle
		else
			Result := 0;
	end else if Editorpage.ActivePage = RocalRuleTab then begin
		if ActiveCOntrol = LocalEdit then
			Result := LocalEdit.Handle
		else
			Result := 0;
	end else
		Result := 0;
end;

procedure TEditorForm.SetContent(Content: string; ABrowser: TWebBrowser);
var
	doc: OleVariant;
begin
	if Assigned(ABrowser.ControlInterface.Document) then begin
		doc := OleVariant(ABrowser.Document);
		doc.Clear;
		doc.open;
		doc.charset := 'Shift_JIS';
		doc.Write(Content);
		doc.Close;
	end;
end;
procedure TEditorForm.InitIdHTTP(http: TIdHTTP);
begin
	http.Request.Clear;
	http.ProxyParams.BasicAuthentication := False;
	if GikoSys.Setting.WriteProxy then begin
		http.ProxyParams.ProxyServer := GikoSys.Setting.WriteProxyAddress;
		http.ProxyParams.ProxyPort := GikoSys.Setting.WriteProxyPort;
		http.ProxyParams.ProxyUsername := GikoSys.Setting.WriteProxyUserID;
		http.ProxyParams.ProxyPassword := GikoSys.Setting.WriteProxyPassword;
		if GikoSys.Setting.ReadProxyUserID <> '' then
			http.ProxyParams.BasicAuthentication := True;
	end else begin
		http.ProxyParams.ProxyServer := '';
		http.ProxyParams.ProxyPort := 80;
		http.ProxyParams.ProxyUsername := '';
		http.ProxyParams.ProxyPassword := '';
	end;
	Indy.Request.UserAgent := GikoSys.GetUserAgent;
	Indy.Request.AcceptEncoding := '';
    Indy.AllowCookies := True;
end;
//! M~̂߂̃j[̍Đ
procedure TEditorForm.CancelSend(ABoard: TBoard; ASysMenu: HMENU);
begin
	ABoard.SPID := '';
	ABoard.PON := '';
	FWork := false;
	EnableMenuItem(ASysMenu, SC_CLOSE, MF_BYCOMMAND or MF_ENABLED);
	DrawMenuBar(Handle);
end;

procedure TEditorForm.Send( const ACOOKIE: string; const SPID: string;
 const PON: string; FirstWriting: Boolean);
var
	TextStream: TStringStream;
	Source: TStringStream;
	ResponseText: string;
	URL: string;
	State: TGikoDownloadState;
	ResultType: TGikoResultType;
	MsgResult: Integer;
	Board: TBoard;
	sysMenu	: HMENU;
    {Protocol,Host, Path, Document, Port, Bookmark : String;}
begin
	FAbort := False;
	State := gdsError;
    Board := GetBoard;

	InitIdHTTP(Indy);
	if FThreadItem = nil then begin
		URL := FBoard.GetSendURL;
		Indy.Request.Referer := GikoSys.UrlToServer(FBoard.URL) + 'test/bbs.cgi';
	end else begin
		URL := FThreadItem.GetSendURL;
		Indy.Request.Referer := FThreadItem.URL;
	end;
	sysMenu := GetSystemMenu( Handle, false );
	EnableMenuItem( sysMenu, SC_CLOSE, MF_GRAYED );
{
  EnableMenuItem(SysMenu, SC_CLOSE, MF_BYCOMMAND or MF_ENABLED);
  DrawMenuBar(Handle);
}
	Indy.Request.CustomHeaders.Clear;
//	Indy.Request.CacheControl := 'no-cache';
	Indy.Request.CustomHeaders.Add('Pragma: no-cache');
	Indy.Request.AcceptLanguage := 'ja';
	Indy.Request.Accept := 'image/gif, image/x-xbitmap, image/jpeg, image/pjpeg, */*';
	Indy.Request.ContentType := 'application/x-www-form-urlencoded';
	Indy.Request.CustomHeaders.Add(getHeaderStr(ACOOKIE, SPID, PON, GikoSys.GetBouken(URL, FCookieDomain), Board));
	TextStream := TStringStream.Create('');
	Source := TStringStream.Create('');
	try
		try
			FDebugStrReceive := '';
			FDebugStrSend := '';

			if (FirstWriting) then begin
				//tVAigbvx(LocalMode) by 
                if (isLocalFusianaTrap) then begin
                    CancelSend( Board, SysMenu );
                    Exit;
                end;
                //tVAigbvx(Remote)
                if (isRemoteFusianaTrap) then begin
                    CancelSend( Board, SysMenu );
                    Exit;
                end;
                // 딚`FbN
                if (isGobaku) then begin
                    CancelSend( Board, SysMenu );
                    Exit;
                end;
			end;

			GetSendData(Source);
			IdAntiFreeze.Active := True;
			try
				Indy.Post(URL, Source, TextStream);
			finally
				IdAntiFreeze.Active := False;
			end;
			ResponseText := TextStream.DataString;

			ResultType := GetResultType(ResponseText);


			if ResultType = grtOK then begin
				if (GikoSys.Setting.UseSamba) and  (FSambaTimer.Enabled) then
                begin
                    FSambaTimer.WriteSambaTime(Now());
                end;
                GetCookie(Indy.CookieManager, Board);
				State := gdsComplete;
			end else if ResultType = grtCookie then begin
				//[vh~
				if not FirstWriting then
					raise Exception.Create('');

				MsgResult := MsgBox( Handle,
								'Eeꂽe̓Rs[AۑApA]ړꍇ܂B' + #13#10 +
								'EeɊւĔӔC͑Sēe҂ɋA܂B' + #13#10#13#10 +
								'SӔC𕉂Ƃď݂܂H',
								'',
								MB_YESNO or MB_ICONQUESTION);

				if MsgResult = IDYES then begin
					GetCookie(Indy.CookieManager, Board);
                    if (Board.Is2ch) then begin
                        GetHiddenParameter(ResponseText, Board);
                    end;

					if (Board.SPID = '') and (Board.PON = '') and (Board.Cookie = '') then
						raise Exception.Create('');
					//񂱂̃\bh
					Send(Board.Cookie, Board.SPID, Board.PON, False);
					Exit;
				end else begin
					CancelSend( Board, SysMenu );
					Exit;
				end;
			end else if ResultType = grtCheck then begin
				//[vh~
				if not FirstWriting then
					raise Exception.Create('');

				MsgResult := MsgBox( Handle,
						'݂ɊւĂ͗lXȃO񂪋L^Ă܂B' + #13#10 +
						'eɊւĔӔC͑Sēe҂ɋA܂B' + #13#10 +
						'ǑɔAlɖf鏑݂͍TĉB' + #13#10 +
						'eꂽe̓Rs[EۑEpE]ړꍇ܂B' + #13#10 +
						#13#10 +
						'SӔC𕉂Ƃď݂܂H',
						'mF',
						MB_YESNO or MB_ICONQUESTION);

				if MsgResult = IDYES then begin
					GetCookie(Indy.CookieManager, Board);
                    if (Board.Is2ch) then begin
                        GetHiddenParameter(ResponseText, Board);
                    end;

					if (Board.SPID = '') and (Board.PON = '') and (Board.Cookie = '') then
						raise Exception.Create('');


					Send(Board.Cookie, Board.SPID, Board.PON, False);
					Exit;
				end else begin
					CancelSend( Board, SysMenu );
					Exit;
				end;
			end else if ResultType = grtNinpou then begin
				MsgBox( Handle,
						'M̔E@쐬łBԂȂ炢܂B(Qقǂ܂)' + #13#10
						, 'mF',
						MB_OK or MB_ICONINFORMATION);
				if (GikoSys.Setting.UseSamba)  and  (FSambaTimer.Enabled) then
                begin
					FSambaTimer.WriteSambaTime(Now());
                end;
                Board.PON  := '';
                Board.SPID := '';
                Board.Cookie := '';
                GetCookie(Indy.CookieManager, Board);
				Exit;
            end else if ResultType = grtSuiton then begin
				MsgBox( Handle,
						'M̔E@͏Ă܂B' + #13#10 +
                        'E@폜܂AđMĂB'
						, 'mF',
						MB_OK or MB_ICONINFORMATION);
                // E@
                GikoSys.DelBoukenCookie(FCookieDomain);
                GikoSys.Setting.WriteBoukenSettingFile;
                Board.PON  := '';
                Board.SPID := '';
                Board.Cookie := '';
                Exit;
			end else begin
				if (GikoSys.Setting.UseSamba)  and  (FSambaTimer.Enabled) then
                begin
					FSambaTimer.WriteSambaTime(Now());
                end;
                // E@G[CookieXV
                if ResultType = grtNinpouErr then begin
                    GetCookie(Indy.CookieManager, Board);
                end;
				State := gdsError;
				raise Exception.Create('');
			end;
		except
            on E: EIdSocketError do begin
				State := gdsError;
				ResponseText := '<html><body>'
											+ '<div>ڑs܂<br>'
											+ '̏Ԃ𒲂ׂĂ<br></div>'
											+ '<br><br><div>' + E.Message + '</div>'
											+ '</body></html>';
            end;
			on E: EIdConnectException do begin
				State := gdsError;
				ResponseText := '<html><body>'
											+ '<div>ڑs܂<br>'
											+ 'vLV̏Ԃ𒲂ׂĂ<br></div>'
											+ '<br><br><div>' + E.Message + '</div>'
											+ '</body></html>';
			end;
			on E: Exception do begin
				State := gdsError;

				FDebugStrReceive := AnsiReplaceText(FDebugStrReceive, '<', '&lt;');
				FDebugStrReceive := AnsiReplaceText(FDebugStrReceive, '>', '&gt;');
				FDebugStrSend := AnsiReplaceText(FDebugStrSend, '<', '&lt;');
				FDebugStrSend := AnsiReplaceText(FDebugStrSend, '>', '&gt;');

				ResponseText := '<html><body>' + TextStream.DataString;
				ResponseText := AnsiReplaceText(ResponseText, '</body>', '');
				ResponseText := AnsiReplaceText(ResponseText, '</html>', '');
				ResponseText := ResponseText + '<hr><div align="left"><pre>';
				ResponseText := ResponseText + '<b>MRiȑ</b>'#13#10;
				ResponseText := ResponseText + #13#10'M'#13#10;
				ResponseText := ResponseText + FDebugStrSend;
				ResponseText := ResponseText + #13#10'M'#13#10;
				ResponseText := ResponseText + FDebugStrReceive;
				ResponseText := ResponseText + '</pre></div></body></html>';
			end;
		end;
		FStatusCode := Indy.ResponseCode;
		if FAbort then
			State := gdsAbort;
	finally
		Source.Free;
		TextStream.Free;
        if ( Indy.CookieManager <> nil ) then begin
            Indy.CookieManager.CookieCollection.Clear;
        end;
		//sysMenu := GetSystemMenu( Handle, true );
		EnableMenuItem(SysMenu, SC_CLOSE, MF_BYCOMMAND or MF_ENABLED);
		DrawMenuBar(Handle);
	end;
	FWork := false;
    //MRirȂǂ2ch݊XNvgp
    //2chȊOłResponceCode302Foundŏ݊
    //if (not Board.Is2ch) and (FStatusCode = 302) then begin
    if FStatusCode = 302 then begin
        GikoForm.PlaySound('ResEnd');
        SaveSendFile;
        AddFormMessageNew( gmiOK );
        if (not ContinueModeAction.Enabled) or (not ContinueModeAction.Checked) then begin
            Close;
            Exit;
        end;
    end;
	if State = gdsComplete then begin
		GikoForm.PlaySound('ResEnd');
		SaveSendFile;
        AddFormMessageNew( gmiOK );
        if (not ContinueModeAction.Enabled) or (not ContinueModeAction.Checked) then begin
    		Close;
        end;
	end else if State = gdsError then begin
        AddFormMessageNew( gmiOK );
		EditorPage.ActivePage := PreviewTab;
		SetContent(ResponseText, Browser);
	end else if State = gdsAbort then begin
		GikoForm.AddMessageList(FThreadItem.Title + ' ' + GikoSys.GetGikoMessage(gmAbort), nil, gmiSAD);
	end;
end;
function TEditorForm.GetResultType(ResponseText: string): TGikoResultType;
begin
	if AnsiPos('݂I܂', ResponseText) <> 0 then
		Result := grtOK
    else if ( (AnsiPos('<b>悤FM̔E@쐬܂BQɍēxނAA肭', ResponseText) > 0) or
              (AnsiPos('dqqnqFM̖`̏쐬ł', ResponseText) > 0) )
                and (AnsiPos(RES2CH_COOKIE, ResponseText) > 0) 	then
        Result := grtNinpou
    else if ( (AnsiPos('dqqnqFCs܂', ResponseText) > 0) or   // G[
              (AnsiPos('dqqnqFLvȂăXbh', ResponseText) > 0) ) // G[
              and (AnsiPos(RES2CH_COOKIE, ResponseText) > 0) 	then
        Result := grtNinpouErr
    else if( AnsiPos('<b>ꂽłFLv=0 <br>Ď͂ŕł邩?', ResponseText) > 0) 
              and (AnsiPos(RES2CH_COOKIE, ResponseText) > 0) 	then
        Result := grtSuiton
	else if ( AnsiPos('NbL[Ȃ؂ł', ResponseText) > 0) or
					(AnsiPos('<title>NbL[mFI</title>', ResponseText) > 0)	or
					(AnsiPos('<title>NbL[mFI</title>', ResponseText) > 0) or
                    (AnsiPos(RES2CH_COOKIE, ResponseText) > 0)	then
		Result := grtCookie
	else if (AnsiPos('<font size=+2 color=#FF0000>݃`FbNI </font>', ResponseText) > 0)	or
					(AnsiPos('<title> ݊mF܂ </title>', ResponseText) > 0)	or
					(AnsiPos('<title>emF</title>', ResponseText) > 0)	or
					(AnsiPos('<b>݊mF</b>', ResponseText) > 0)	or
					(AnsiPos('="../test/subbbs.cgi">', ResponseText) > 0)	or
					(AnsiPos(RES2CH_FALSE, ResponseText) > 0)	then
		Result := grtCheck
	else if (AnsiPos('Ee҂́Af^c҂ɑ΂āAҐli؍sgȂƂ܂B<br>', ResponseText) > 0) or
                                        (AnsiPos('i쌠@21Ȃ28ɋK肳錠܂ށj̑̌ɂA', ResponseText) > 0) then
                Result := grtCookie
    else
        Result := grtError;
end;


procedure TEditorForm.GetSendData(Source: TStringStream);
var
	SessionID: string;
	s: string;
	SendTime: Integer;
	Adjust: Integer;
	Board: TBoard;
	body		: string;
begin
    Board := GetBoard;

	if GikoSys.Setting.UseMachineTime then begin
		if GikoSys.Setting.TimeAdjust then
			Adjust := Gikosys.Setting.TimeAdjustSec
		else
			Adjust := GikoSys.Setting.TimeAdjustSec * -1;
		SendTime := GikoSys.DateTimeToInt(Now) - (9 * 60 * 60) + Adjust
	end else begin
		if (Board.LastGetTime = 0) or (Board.LastGetTime = ZERO_DATE) then
			SendTime := GikoSys.DateTimeToInt(Now)
		else
			SendTime := GikoSys.DateTimeToInt(Board.LastGetTime);
	end;

	body := GetBody;

	SessionID := GikoSys.Dolib.SessionID;
	if SessionID <> '' then
		s := 'sid=' + HttpEncode(SessionID) + '&'
	else
		s := '';
        s := s + 'subject=&'
               + 'FROM=' + HttpEncode(NameComboBox.Text) + '&'
               + 'mail=' + HttpEncode(MailComboBox.Text) + '&'
               + 'MESSAGE=' + HttpEncode(body) + '&'
               + 'bbs=' + Board.BBSID + '&'
			   + 'time=' + IntToStr(SendTime) + '&';
			   
	if FThreadItem = nil then begin
		s := s + 'subject=' + HttpEncode(TitleEdit.Text) + '&';
		s := s + 'submit=' + HttpEncode('SӔC𕉂Ƃď') + #13#10;
	end else begin
		s := s + 'key=' + ChangeFileExt(FThreadItem.FileName, '') + '&';
		s := s + 'submit=' + HttpEncode('') + #13#10;
	end;
	Source.WriteString(s);
end;

procedure TEditorForm.SaveSendFile;
var
	sDate: string;
	ini: TMemIniFile;
begin
	ini := CreateSentIniFile;
    if (ini <> nil) then begin
        try
            sDate := IntToStr(GikoSys.DateTimeToInt(Now));

            ini.WriteString(sDate, 'Name', NameComboBox.Text);
            ini.WriteString(sDate, 'EMail', MailComboBox.Text);
            ini.WriteString(sDate, 'Body', HttpEncode(BodyEdit.Text));
            ini.WriteInteger(sDate, 'Status', FStatusCode);
            ini.WriteDateTime(sDate, 'Date', Now);
            if FThreadItem = nil then begin
                ini.WriteString(sDate, 'Title', MojuUtils.Sanitize(TitleEdit.Text));
                //ini.WriteString(sDate, 'BBS', FBoard.BBSID);
                ini.WriteString(sDate, 'URL', FBoard.URL);
                ini.WriteInteger(sDate, 'NewThread', 1);
            end else begin
                ini.WriteString(sDate, 'Title', FThreadItem.Title);
                //ini.WriteString(sDate, 'BBS', FThreadItem.ParentBoard.BBSID);
                ini.WriteString(sDate, 'URL', FThreadItem.URL);
                ini.WriteString(sDate, 'Key', ChangeFileExt(FThreadItem.FileName, ''));
            end;

            ini.UpdateFile;
        finally
            ini.Free;
        end;
    end;
end;
function TEditorForm.CreateSentIniFile: TMemIniFile;
var
    maxSize, fileSize, i: Integer;
    newName: String;
begin
    Result := nil;
    // MB -> bytes
    maxSize := GikoSys.Setting.SentIniFileSize * 1024 * 1024;
    // t@CTCY0̏ꍇ́Asent.iniɏ܂Ȃ̂nilԂ
    if (maxSize > 0) then begin
        fileSize := GikoSys.GetFileSize(GikoSys.Setting.GetSentFileName);
        // őTCY𒴂Ăꍇ̓l[
        if (fileSize >= maxSize) then begin
            i := 0;
            // ̎t@Čɂ
            repeat
                // 10ȏ㎸s炠߂
                if (i > 10) then break;
                DateTimeToString(newName, 'yyhhnnsszzz', Now());
                Inc(i);
            until RenameFile(GikoSys.Setting.GetSentFileName,
                GikoSys.Setting.GetSentFileName + '.' + newName);
        end;
        Result := TMemIniFile.Create(GikoSys.Setting.GetSentFileName);
    end;
end;
procedure TEditorForm.SendActionExecute(Sender: TObject);
const
	TITLE_SAMBA : string = 'Samba24x';
var
	Board: TBoard;
	rc: Integer;
        rc2: Integer;
	state : TGikoDownloadState;
	body		: string;
begin
	if FWork then
		Exit;
	try
		FWork := True;
		SendAction.Enabled := False;
		Application.ProcessMessages;
		if not Check then Exit;

        Board := GetBoard;

		if FThreadItem = nil then begin
			rc := GikoUtil.MsgBox(Handle,
													'u' + Board.Title + 'vɐVXbhĂ܂'#13#10#13#10
													+ 'E̃[݂ł邱ƂmF܂H'#13#10
													+ 'Eɓ悤ȃXbhƂmF܂H'#13#10#13#10
													+ 'u͂vƑM܂',
													'mF',
													MB_ICONQUESTION or MB_YESNO);
			if rc <> ID_YES then
				Exit;
		end;

		SetNameList(NameComboBox.Text, MailComboBox.Text);
		if (KotehanCheckBox.Enabled) and (KotehanCheckBox.Checked) then begin
			Board.KotehanName := NameComboBox.Text;
			Board.KotehanMail := MailComboBox.Text;
		end;

		if Board.IsBoardPlugInAvailable then begin
			body := GetBody;

			if FThreadItem = nil then begin
				// X
				state := TGikoDownloadState( Board.BoardPlugIn.CreateThread(
					DWORD( Board ), TitleEdit.Text, NameComboBox.Text, MailComboBox.Text, body ) );

				if state = gdsComplete then begin
					GikoForm.PlaySound('ResEnd');
					SaveSendFile;
					GikoForm.AddMessageList(FBoard.Title + ' ' + GikoSys.GetGikoMessage(gmNewSure), nil, gmiOK);
					FWork := False;
					Close;
				end else if State = gdsError then begin
					GikoForm.AddMessageList(FBoard.Title + ' ' + GikoSys.GetGikoMessage(gmSureError), nil, gmiNG);
				end else if State = gdsAbort then begin
					GikoForm.AddMessageList(FBoard.Title + ' ' + GikoSys.GetGikoMessage(gmAbort), nil, gmiNG);
				end;
			end else begin
				// X
				state := TGikoDownloadState( FThreadItem.ParentBoard.BoardPlugIn.WriteThread(
					DWORD( FThreadItem ), NameComboBox.Text, MailComboBox.Text, body ) );

				if state = gdsComplete then begin
					GikoForm.PlaySound('ResEnd');
					SaveSendFile;
					GikoForm.AddMessageList(FThreadItem.Title + ' ' + GikoSys.GetGikoMessage(gmNewRes), nil, gmiOK);
					FWork := False;
					Close;
				end else if State = gdsError then begin
					GikoForm.AddMessageList(FThreadItem.Title + ' ' + GikoSys.GetGikoMessage(gmResError), nil, gmiOK);
				end else if State = gdsAbort then begin
                    GikoForm.AddMessageList(FThreadItem.Title + ' ' + GikoSys.GetGikoMessage(gmAbort), nil, gmiOK);
				end;
			end;
		end else begin
			if not FSambaTimer.Enabled then begin
				if CompareDateTime(Board.Expires ,Now) <= 0 then begin
					Board.Cookie	:= '';
					Board.SPID      := '';
					Board.PON		:= '';
				end;
                // `̏x߂Ή
                if (Board.Is2ch) and (AnsiPos('HAP=', Board.Cookie)>0) then begin
                    Board.Cookie := '';
                end;
				Send(Board.Cookie, Board.SPID, Board.PON, True);
			end else begin
				if not FSambaTimer.CheckSambaTime(Now()) then begin
					rc := GikoUtil.MsgBox(Handle,
								'Samba24̋Kl̕bo߂Ă܂B'#13#10
								+ 'M𒆎~܂H' + #13#10
								+ '(uvƑM܂)', TITLE_SAMBA,
								MB_YESNO or MB_ICONQUESTION);
					if rc = IDYES then begin
						FWork := false;
						Exit;
					end;
                                        if rc = IDNO then begin
                                                rc2 := GikoUtil.MsgBox(Handle,
                                                                       '{ɑM܂H',
                                                                       TITLE_SAMBA,
                                                                       MB_YESNO or MB_ICONQUESTION);
                                                if rc2 = IDNO then begin
                                                        FWork := False;
                                                        Exit;
                                                end;
                                        end;
				end;
				if CompareDateTime(Board.Expires ,Now) <= 0 then begin
					Board.Cookie	:= '';
					Board.SPID      := '';
					Board.PON		:= '';
				end;
                // `̏x߂Ή
                if (Board.Is2ch) and (AnsiPos('HAP=', Board.Cookie)>0) then begin
                    Board.Cookie := '';
                end;
				Send(Board.Cookie, Board.SPID, Board.PON, True);
			end;
		end;
	finally
		FWork := False;
		if FSambaTimer.Enabled then begin
			FNow := FSambaTimer.Update;
        end;
	end;
end;

procedure TEditorForm.SaveActionExecute(Sender: TObject);
begin
//
end;

procedure TEditorForm.CloseActionExecute(Sender: TObject);
begin
	Close;
end;

procedure TEditorForm.UndoActionExecute(Sender: TObject);
begin
	SendMessage(GetActiveControlHandle, WM_UNDO, 0, 0);
end;

procedure TEditorForm.CutActionExecute(Sender: TObject);
begin
	SendMessage(GetActiveControlHandle, WM_CUT, 0, 0);
end;

procedure TEditorForm.CopyActionExecute(Sender: TObject);
begin
	SendMessage(GetActiveControlHandle, WM_COPY, 0, 0);
end;

procedure TEditorForm.PasteActionExecute(Sender: TObject);
begin
	SendMessage(GetActiveControlHandle, WM_PASTE, 0, 0);
end;

procedure TEditorForm.SelectAllActionExecute(Sender: TObject);
begin
	SendMessage(GetActiveControlHandle, EM_SETSEL, 0, GetWindowTextLength(GetActiveControlHandle));
end;

procedure TEditorForm.TopActionExecute(Sender: TObject);     // EBhEőO(Stay){^̏
begin
	if not (fsShowing in Self.FormState) then begin
		if TopAction.Checked then begin // XeCԂɐݒ
			SetWindowPos(Handle, HWND_TOPMOST, 0, 0, 0, 0, SWP_NOMOVE + SWP_NOSIZE);
			GikoSys.Setting.EditWindowStay := true;
		end	else begin   // XeCԉ
			SetWindowPos(Handle, HWND_NOTOPMOST, 0, 0, 0, 0, SWP_NOMOVE + SWP_NOSIZE);
			GikoSys.Setting.EditWindowStay := false;
		end;
		// XeCԂ̕ۑ
		//GikoSys.Setting.EditWindowStay := FormStyle = fsStayOnTop;
	end;
end;

procedure TEditorForm.AbortActionExecute(Sender: TObject);
begin
	FAbort := True;
end;

procedure TEditorForm.SendActionUpdate(Sender: TObject);
begin
	SendAction.Enabled := not FWork;
end;

procedure TEditorForm.SaveActionUpdate(Sender: TObject);
begin
	SaveAction.Enabled := False;
end;

procedure TEditorForm.CloseActionUpdate(Sender: TObject);
begin
	CloseAction.Enabled := not FWork;
end;

procedure TEditorForm.UndoActionUpdate(Sender: TObject);
begin
	UndoAction.Enabled := (GetActiveControlHandle <> 0)
												and (SendMessage(GetActiveControlHandle, EM_CANUNDO, 0, 0) <> 0)
												and (not FWork);
end;

procedure TEditorForm.CutActionUpdate(Sender: TObject);
var
	Selection: TSelection;
	AHandle: THandle;
begin
	AHandle := GetActiveControlHandle;
	SendMessage(AHandle, EM_GETSEL, Longint(@Selection.StartPos), Longint(@Selection.EndPos));
	CutAction.Enabled := (AHandle <> 0)
										and ((Selection.EndPos - Selection.StartPos) <> 0)
										and (not FWork);
end;

procedure TEditorForm.CopyActionUpdate(Sender: TObject);
var
	Selection: TSelection;
	AHandle: THandle;
begin
	AHandle := GetActiveControlHandle;
	SendMessage(AHandle, EM_GETSEL, Longint(@Selection.StartPos), Longint(@Selection.EndPos));
	CopyAction.Enabled := (AHandle <> 0)
										and ((Selection.EndPos - Selection.StartPos) <> 0)
										and (not FWork);
end;

procedure TEditorForm.PasteActionUpdate(Sender: TObject);
begin
	PasteAction.Enabled := (GetActiveControlHandle <> 0)
											and (Clipboard.HasFormat(CF_TEXT))
											and (not FWork);
end;

procedure TEditorForm.TopActionUpdate(Sender: TObject);
begin
 	TopAction.Enabled := not FWork;
end;

procedure TEditorForm.SageCheckBoxClick(Sender: TObject);
begin
	if SageCheckBox.Checked then begin
		if AnsiPos('sage', MailComboBox.Text) = 0 then
			MailComboBox.Text := 'sage' + MailComboBox.Text;
	end else begin
		if AnsiPos('sage', MailComboBox.Text) <> 0 then
			MailComboBox.Text := StringReplace(MailComboBox.Text, 'sage', '', [rfReplaceAll]);
	end;
end;

procedure TEditorForm.MailComboBoxChange(Sender: TObject);
begin
	if AnsiPos('sage', MailComboBox.Text) = 0 then
		SageCheckBox.Checked := False
	else
		SageCheckBox.Checked := True;
end;

procedure TEditorForm.IdLogDebugReceive(ASender: TIdConnectionIntercept;
	AStream: TStream);
var
	StringStream: TStringStream;
begin
	StringStream := TStringStream.Create('');
	try
		StringStream.CopyFrom(AStream, AStream.Size);
		FDebugStrReceive := FDebugStrReceive + StringStream.DataString;
	finally
		StringStream.Free;
	end;
end;

procedure TEditorForm.IdLogDebugSend(ASender: TIdConnectionIntercept;
	AStream: TStream);
var
	StringStream: TStringStream;
begin
	StringStream := TStringStream.Create('');
	try
		StringStream.CopyFrom(AStream, AStream.Size);
		FDebugStrSend := FDebugStrSend + StringStream.DataString;
	finally
		StringStream.Free;
	end;
end;

procedure TEditorForm.TransActionExecute(Sender: TObject);
begin
	AlphaBlend := TransAction.Checked;
	// Ԃ̕ۑ
	GikoSys.Setting.EditWindowTranslucent := TransAction.Checked;
end;

procedure TEditorForm.TransActionUpdate(Sender: TObject);
begin
	TransAction.Enabled := not FWork;
end;
//StatusBarPanels[0]̕ρBcŒɂ
procedure TEditorForm.StatusBarResize(Sender: TObject);
begin
	StatusBar.Panels[0].Width := StatusBar.Width
									- StatusBar.Panels[1].Width - StatusBar.Panels[2].Width;

end;

//FormActiveɂȂŏIݎԂǂݍ
procedure TEditorForm.FormActivate(Sender: TObject);
begin
	if ( FSambaTimer.Enabled ) and ( FThreadItem <> nil ) then
    begin
		FNow := FSambaTimer.Update;
    end;
	if GikoSys.Setting.GestureEnabled then begin
		GikoSys.Setting.Gestures.ClearGesture;
		GikoSys.Setting.Gestures.LoadGesture(
			GikoSys.Setting.GetGestureFileName, ActionList );
		MouseGesture.UnHook;
		MouseGesture.OnGestureStart := OnGestureStart;
		MouseGesture.OnGestureMove := OnGestureMove;
		MouseGesture.OnGestureEnd := OnGestureEnd;
		MouseGesture.SetHook( Handle );
	end;
end;
procedure TEditorForm.FormCloseQuery(Sender: TObject;
  var CanClose: Boolean);
begin
	CanClose := not FWork;
end;

procedure TEditorForm.QuotePasteActionExecute(Sender: TObject);
var
	s			: TStringList;
	i			: Integer;
	quote	: string;
begin

	quote	:= GikoSys.GetOEIndentChar;
	s			:= TStringList.Create;
	try
		s.Text	:= Clipboard.AsText;

		for i := s.Count - 1 downto 0 do
			s[ i ]	:= quote + s[ i ];

		BodyEdit.SelText	:= s.Text;
	finally
		s.Free;
	end;

end;

procedure TEditorForm.SpaceToNBSPActionExecute(Sender: TObject);
begin
	GikoSys.Setting.SpaceToNBSP := SpaceToNBSPAction.Checked;
	if EditorPage.ActivePage = PreviewTab then
		Preview;
end;

procedure TEditorForm.AmpToCharRefActionExecute(Sender: TObject);
begin
	GikoSys.Setting.AmpToCharRef := AmpToCharRefAction.Checked;
	if EditorPage.ActivePage = PreviewTab then
		Preview;
end;

procedure TEditorForm.BoardTopClick(Sender: TObject);
var
	ini: TMemIniFile;
begin
	ini := TMemIniFile.Create(GikoSys.Setting.GetFileName);
	try
		BoardtopTab.TabVisible := BoardTop.Checked;
		ini.WriteBool('EditorForm', 'BoardTopTab', BoardtopTab.TabVisible);
        ini.UpdateFile;
	finally
		ini.Free;
	end;
end;


procedure TEditorForm.GetSETTINGTXTActionExecute(Sender: TObject);
var
	memStream: TMemoryStream;
	URL, RefURL: string;
	settingBody: TStringList;
	tmpBoard: TBoard;
begin
	if not FWork then begin
    	FWork := True;

        tmpBoard := GetBoard;
        if tmpBoard <> nil then begin

            RefURL	:= tmpBoard.URL;
            if RefURL[Length(RefURL)] <> '/' then
                URL	:= RefURL + '/' + 'SETTING.TXT'
            else
                URL	:= RefURL + 'SETTING.TXT';
            Screen.Cursor := crHourGlass;
            memStream := TMemoryStream.Create;
            try
                try
                    StatusBar.Panels[0].Text := 'SETTING.TXT_E[h';
                    GetWebData(URL, RefURL, tmpBoard.SETTINGTXTTime, memStream);
                    if( Indy.ResponseCode = 200 ) then begin
                        settingBody := TStringList.Create;
                        try
                            memStream.Seek(0, soFromBeginning);
                            settingBody.LoadFromStream(memStream);
                            settingBody.SaveToFile(tmpBoard.GetSETTINGTXTFileName);
                            tmpBoard.SETTINGTXTTime := Indy.Response.LastModified;
                            tmpBoard.IsSETTINGTXT := true;
                            tmpBoard.TitlePictureURL := GetTitlePictureURL(settingBody, tmpBoard);
                            tmpBoard.Modified := true;
                        finally
                            settingBody.Free;
                        end;
                        StatusBar.Panels[0].Text := 'SETTING.TXT擾(' + IntToStr(Indy.ResponseCode) + ')';
                    end;
                except
                    on E: EIdException do begin
                        if( AnsiPos('304', E.Message) > 0 ) then
                            StatusBar.Panels[0].Text := 'SETTING.TXTXV(' + IntToStr(Indy.ResponseCode) + ')'
                        else
                            StatusBar.Panels[0].Text := 'SETTING.TXT擾G[(' + IntToStr(Indy.ResponseCode) + ')';
                    end;
                end;
            finally
                memStream.Free;
                Screen.Cursor := crDefault;
            end;
            ShowBoardInformation(tmpBoard, BoardInformationMemo);
        end;
        FWork := False;
    end;
end;

procedure TEditorForm.ShowBoardInformation(ABoard: TBoard; AMemo: TMemo);
var
	body: TStringList;
begin
	AMemo.Clear;
	AMemo.Lines.Add('[SETTING.TXT]');
	if ABoard.IsSETTINGTXT then begin
		if FileExists(ABoard.GetSETTINGTXTFileName)  then begin
			AMemo.Lines.Add(DateTimeToStr(ABoard.SETTINGTXTTime) + ' XV');
			body := TStringList.Create;
			try
				body.LoadFromFile(ABoard.GetSETTINGTXTFileName);
				AMemo.Lines.AddStrings(body);
			finally
				body.Free;
			end;
		end else begin
			ABoard.IsSETTINGTXT := false;
			ABoard.SETTINGTXTTime := ZERO_DATE;
			AMemo.Lines.Add('LocalɕۑꂽSETTING.TXT܂');
			AMemo.Lines.Add('j[Ď擾ĂB');
		end;
	end else begin
		AMemo.Lines.Add('SETTING.TXT擾Ă܂B');
		AMemo.Lines.Add('j[擾ĂB');
	end;
end;
function TEditorForm.GetTitlePictureURL(body: TStringList; ABoard: TBoard): string;
//BBS_TITLE_PICTURE=
//BBS_FIGUREHEAD=
var
	i: Integer;
	tmp: string;
begin
	Result := '';
	for i := 0 to body.Count - 1 do begin
		if (AnsiPos('BBS_TITLE_PICTURE=', body[i]) > 0) or
		   (AnsiPos('BBS_FIGUREHEAD=', body[i]) > 0) then begin
			tmp := body[i];
			Delete(tmp, 1, AnsiPos('=', tmp));
			if AnsiPos('../', tmp) > 0 then begin
				tmp := CustomStringReplace(tmp, '../', GikoSys.UrlToServer(ABoard.URL));
			end;
			Result := tmp;
			Exit;
		end;
	end;
end;

procedure TEditorForm.GetTitlePictureActionUpdate(Sender: TObject);
begin
	if FThreadItem = nil then
		GetTitlePictureAction.Enabled :=  FBoard.IsSETTINGTXT
	else
		GetTitlePictureAction.Enabled :=  FThreadItem.ParentBoard.IsSETTINGTXT;

	if GetTitlePictureAction.Enabled Then begin
		// s͎ss
		GetTitlePictureAction.Enabled := not FWork;
	end;
end;

procedure TEditorForm.GetTitlePictureActionExecute(Sender: TObject);
var
	memStream: TMemoryStream;
	tmpBoard: TBoard;
begin
	if FWork then
		Exit;

	FWork := True;
	memStream := TMemoryStream.Create;
	try
        tmpBoard := GetBoard;

		if (tmpBoard <> nil) and (tmpBoard.TitlePictureURL <> '') then begin
			StatusBar.Panels[0].Text := 'gbv摜_E[h';
			Screen.Cursor := crHourGlass;
			try
                // URLw肵ăɓǂݍ
                GetWebData(tmpBoard.TitlePictureURL, tmpBoard.URL,
                    ZERO_DATE, memStream);
				if Indy.ResponseCode = 200 then begin
					memStream.SaveToFile(tmpBoard.GetTitlePictureFileName);
					ShowTitlePicture();
					tmpBoard.Modified := true;
				end;
                StatusBar.Panels[0].Text := 'gbv摜 (' + IntToStr(Indy.ResponseCode) + ')';
			except
			end;
		end;
	finally
		memStream.Free;
        FWork := False;
		Screen.Cursor := crDefault;
	end;
end;
{
\brief  URL̃f[^streamɓǂݍ
\param  URL ǂݍސ
\param  RefURL   refererɐݒ肷
\param  Modified    Modifiedɐݒ肷
\param  stream  ǂݍ񂾃f[^̕ۑ
}
procedure TEditorForm.GetWebData(const URL: string; const RefURL: string;
             Modified: TDateTime; stream: TStream);
begin
    InitIdHTTP(Indy);
    Indy.Request.Referer := RefURL;
    Indy.Request.LastModified := Modified;
    
    IdAntiFreeze.Active := True;
    try
        Indy.Get(URL, stream);
    finally
        IdAntiFreeze.Active := False;
    end;

end;
procedure TEditorForm.ShowTitlePicture();
var
	tmpBoard: TBoard;
	s: String;
begin
    tmpBoard := GetBoard;

	if FileExists(tmpBoard.GetTitlePictureFileName) then begin
		TitlePictureBrowser.Navigate(tmpBoard.GetTitlePictureFileName);
	end else begin
		s := 'gbv摜擾łB<br>j[擾ĂB';
		SetContent(s, TitlePictureBrowser);
	end;
end;

function TEditorForm.GetFusianaName(body: TStringList; ABoard: TBoard): String;
var
	i: Integer;
	tmp: string;
begin
	for i := 0 to body.Count - 1 do begin
		if (AnsiPos('BBS_NONAME_NAME=', body[i]) > 0) then begin
			tmp := body[i];
			Delete(tmp, 1, AnsiPos('=', tmp));
			Result := tmp;
			Exit;
		end;
	end;
end;

procedure TEditorForm.GetHeadTXTActionExecute(Sender: TObject);
var
	URL, RefURL: string;
	settingBody: TStringList;
	tmpBoard: TBoard;
	memStream: TMemoryStream;
begin
    if not FWork then begin
        FWork := True;

        tmpBoard := GetBoard;
        if (tmpBoard <> nil) then begin

            RefURL	:= tmpBoard.URL;
            if RefURL[Length(RefURL)] <> '/' then
                URL	:= RefURL + '/' + 'head.txt'
            else
                URL	:= RefURL + 'head.txt';

            Screen.Cursor := crHourGlass;
            memStream := TMemoryStream.Create;
            try
                StatusBar.Panels[0].Text := '[J[(head.txt)_E[h';
                try
                    GetWebData(URL, RefURL, tmpBoard.HEADTXTTime, memStream);
                    if( Indy.ResponseCode = 200 ) then begin
                        settingBody := TStringList.Create;
                        try
                            memStream.Seek(0, soFromBeginning);
                            settingBody.LoadFromStream(memStream);
                            settingBody.Insert(0, '<HTML lang="ja"><HEAD>');
                            settingBody.Insert(1, '<META http-equiv="Content-Type" content="text/html; charset=Shift_JIS">');
                            settingBody.Insert(2, '<TITLE>' + tmpBoard.Title + '</TITLE>');
                            settingBody.Insert(3, '<base href="' + RefURL + '"></HEAD><BODY>');
                            settingBody.Add('</BODY></HTML>');
                            settingBody.SaveToFile(tmpBoard.GETHEADTXTFileName);
                            tmpBoard.HEADTXTTime := Indy.Response.LastModified;
                            tmpBoard.IsHEADTXT := true;
                            tmpBoard.Modified := true;
                        finally
                            settingBody.Free;
                        end;
                        StatusBar.Panels[0].Text := '[J[擾(' + IntToStr(Indy.ResponseCode) + ')';
                    end;
                except
                    on E: EIdException do begin
                        if( AnsiPos('304', E.Message) > 0 ) then
                            StatusBar.Panels[0].Text := '[J[XV(' + IntToStr(Indy.ResponseCode) + ')'
                        else
                            StatusBar.Panels[0].Text := '[J[擾G[(' + IntToStr(Indy.ResponseCode) + ')';
                    end;
                end;
            finally
                memStream.Free;
                Screen.Cursor := crDefault;
            end;
            if tmpBoard.IsHEADTXT then begin
                ShowBoardHead(tmpboard, LocalEdit);
            end;
        end;
        FWork := False;
    end;

end;

procedure TEditorForm.CalcCapacityActionExecute(Sender: TObject);
var
	Board: TBoard;
	body: String;
begin
	body := GetBody;
    //ǂAsĂۂǁA{悭ȂB
    Board := GetBoard;

	if Board.BoardPlugIn <> nil then
		body := CustomStringReplace(body, #13#10, '<br>')
	else
		body := CustomStringReplace(body, #13#10, ' <br> ');
	StatusBar.Panels[0].Text := 'e:' + IntToStr(Length(body)) + ' byte';
end;

procedure TEditorForm.LocalRuleClick(Sender: TObject);
var
  ini: TMemIniFile;
begin
	ini := TMemIniFile.Create(GikoSys.Setting.GetFileName);
	try
		RocalRuleTab.TabVisible := LocalRule.Checked;
		ini.WriteBool('EditorForm', 'LocalRuleTab', RocalRuleTab.TabVisible);
        ini.UpdateFile;
	finally
		ini.Free;
	end;
end;

procedure TEditorForm.FormDeactivate(Sender: TObject);
begin
    if GikoSys.Setting.GestureEnabled then begin
        GikoSys.Setting.Gestures.ClearGesture;
        MouseGesture.UnHook;
		MouseGesture.OnGestureStart := nil;
		MouseGesture.OnGestureMove := nil;
		MouseGesture.OnGestureEnd := nil;
    end;
end;

procedure TEditorForm.OnGestureStart(Sender: TObject);
begin
//
end;

procedure TEditorForm.OnGestureMove(Sender: TObject);
var
	s: string;
	Action: TAction;
	ActStr: string;
begin
	s := MouseGesture.GetGestureStr;
	ActStr := '';
	Action := GikoSys.Setting.Gestures.GetGestureAction(s);
	if Action <> nil then
		ActStr := 'i' + Action.Caption + 'j';
	s := 'WFX`[: ' + s + ActStr;
	StatusBar.Panels[0].Text := s;
end;

procedure TEditorForm.OnGestureEnd(Sender: TObject);
var
	s: string;
	Action: TAction;
begin
	s := MouseGesture.GetGestureStr;
    MouseGesture.Clear;
	Action := GikoSys.Setting.Gestures.GetGestureAction(s);
	if Action <> nil then
		Action.Execute;
	StatusBar.Panels[0].Text := '';
end;

procedure TEditorForm.ShowBoardHead(ABoard: TBoard; AMemo: TMemo);
var
    range: OleVariant;
begin
	//Ql
	//http://www.campus.ne.jp/~ishigami/CREATION/TECHNIC/WEBAP-2.htm
	WebBrowser1.Navigate(ABoard.GETHEADTXTFileName);
	//^OxTXTɈڂȂBʂorz
	//̂悤ɂƓǂݍ݂IĂ邩A`FbN΂񂾂B
	//ł܂B肪Ƃ܂B
	while (WebBrowser1.ReadyState <> READYSTATE_COMPLETE) and
			(WebBrowser1.ReadyState <> READYSTATE_INTERACTIVE) do begin
		Application.ProcessMessages;
	end;

    try
    ;
    	range := OleVariant(WebBrowser1.Document).body.createTextRange;
	    LocalEdit.Text := range.text;
    except
    end;
end;

procedure TEditorForm.LocalRuleBrowseClick(Sender: TObject);
var
    URL: String;
    ABoard: TBoard;
begin
    ABoard := GetBoard;

	if ABoard = nil
        then Exit;

    URL := ABoard.GETHEADTXTFileName;
    GikoSys.OpenBrowser(URL, gbtAuto);
end;

procedure TEditorForm.SaveNameMailActionExecute(Sender: TObject);
begin
	SaveNameMailAction.Checked := not SaveNameMailAction.Checked;
	KotehanCheckBox.Enabled := SaveNameMailAction.Checked;
end;

function TEditorForm.LFusianaGet(const s: String): Boolean;
const
    FUSIANA = 'fusianasan';
var
	i: Integer;
begin
    i := AnsiPos(FUSIANA, s);
    Result := (i > 0);
end;

procedure TEditorForm.BeLogInOutEActionExecute(Sender: TObject);
begin
    GikoDM.BeLogInOutAction.Execute;
end;

procedure TEditorForm.BeLogInOutEActionUpdate(Sender: TObject);
begin
    BeLogInOutEAction.Checked := GikoDM.BeLogInOutAction.Checked;
    BeLogInOutEAction.Enabled := GikoDM.BeLogInOutAction.Enabled;
end;
// Cookie̎擾
procedure TEditorForm.GetCookie(CookieMng: TIdCookieManager; ABoard: TBoard);
const
	VAL_SPID	= 'SPID';
	VAL_PON		= 'PON';
    VAL_HAP     = 'HAP';
var
	i : Integer;
    Cookie : TIdCookieRFC2109;
    curCookies : TStringList;
begin
    // 2008.12.14 NAĂ͂Ȃ by 
    curCookies := TStringList.Create;
    curCookies.Delimiter := ';';
    curCookies.DelimitedText := ABoard.Cookie;
    curCookies.Sort;
    curCookies.Duplicates := dupIgnore;
	ABoard.Cookie := '';
    try
        for i := 0 to CookieMng.CookieCollection.Count - 1 do begin
            Cookie := CookieMng.CookieCollection.Items[i];
            if ( Cookie.CookieName = VAL_PON ) then begin
                ABoard.PON := Cookie.Value;
                ABoard.Expires := GMTToLocalDateTime(Cookie.Expires);
            end else if ( Cookie.CookieName = VAL_SPID ) then begin
                ABoard.SPID := Cookie.Value;
                ABoard.Expires := GMTToLocalDateTime(Cookie.Expires);
            end else if ( Cookie.CookieName = VAL_HAP ) then begin
                // HAP폜pCookiezẑŁAL`FbN
                if CompareDateTime(GMTToLocalDateTime(Cookie.Expires) ,Now) > 0 then begin
                    GikoSys.SetBoukenCookie(Cookie.Value, Cookie.Domain);
                    // `̏̕ۑ
                    GikoSys.Setting.WriteBoukenSettingFile;
                end;
            end else begin
                if Length( curCookies.Values[ Cookie.CookieName ] ) > 0 then begin
                    // l̕tւ
                    curCookies[curCookies.IndexOfName(Cookie.CookieName)] :=
                        Cookie.ClientCookie;
                end else begin
                    // ǉ
                    curCookies.Add(Cookie.ClientCookie);
                end;
            end;
        end;
        for i := 0 to curCookies.Count - 1 do begin
            if (curCookies[i] <> '') then begin
                ABoard.Cookie := ABoard.Cookie + curCookies[i] + '; ';
            end;
        end;
    finally
        CookieMng.CookieCollection.Clear;
        curCookies.Free;
    end;
end;
//! hiddenf[^擾
procedure TEditorForm.GetHiddenParameter(Rawtext: String; ABoard: TBoard);
const
    INPUT_MARK = '<input type=hidden' ; // 啶΂΂ȂƂɒ
    VALUE_MARK = 'value=' ;              // 啶΂΂ȂƂɒ
    NAME_MARK  = 'name=' ;               // 啶΂΂ȂƂɒ
    IGNORE_NAMES : array[0..6] of String =
        ('subject', 'from', 'mail', 'message', 'bbs', 'time', 'key');
var
    tmp, line, name, value, lname : String;
    pos, pose, i : Integer;
begin
    tmp := AnsiLowerCase(Rawtext);
    pos := AnsiPos(INPUT_MARK, tmp);
    while  (pos > 0 ) do begin
		tmp := Copy(Rawtext, pos + Length(INPUT_MARK), Length(tmp));
        Delete(Rawtext, 1, pos+ Length(INPUT_MARK) - 1);
        pose := AnsiPos('>', tmp);
        // name=xxx value=yyy ؂o
        line := Copy(tmp, 1, pose - 1);
        name := '';
        value := '';
        pos := AnsiPos(NAME_MARK, tmp);
        if (pos > 0) then begin
            name := Copy(Rawtext, pos + Length(NAME_MARK), Length(line));
            //p"Ŏn܂Ă邩
            if AnsiPos('"', name) = 1 then begin
                // p"܂łRs[
                Delete(name, 1, 1);
                pose := AnsiPos('"', name);
                if (pose > 0) then begin
                    Delete(name, pose, Length(name));
                end else begin
                    pose := AnsiPos(' ', name);
                    if (pose > 0) then begin
                        Delete(name, pose, Length(name));
                    end;
                end;
            end else begin
                pose := AnsiPos(' ', name);
                if (pose > 0) then begin
                    Delete(name, pose, Length(name));
                end;
            end;
        end;
        lname := AnsiLowerCase(name);
        for i := 0 to Length(IGNORE_NAMES) do begin
            if lname = IGNORE_NAMES[i] then begin
                name := '';
                break;
            end;
        end;
        pos := AnsiPos(VALUE_MARK, tmp);
        if (name <> '') and (pos > 0) then begin
            value := Copy(Rawtext, pos + Length(VALUE_MARK), Length(line));
            //p"Ŏn܂Ă邩
            if AnsiPos('"', value) = 1 then begin
                // p"܂łRs[
                Delete(value, 1, 1);
                pose := AnsiPos('"', value);
                if (pose > 0) then begin
                    Delete(value, pose, Length(value));
                end else begin
                    pose := AnsiPos(' ', value);
                    if (pose > 0) then begin
                        Delete(value, pose, Length(value));
                    end;
                end;
            end else begin
                pose := AnsiPos(' ', value);
                if (pose > 0) then begin
                    Delete(value, pose, Length(name));
                end;
            end;
        end;
        if (name <> '') then begin
            ABoard.Cookie := ABoard.Cookie + name + '=' + value + '; '; 

        end;
		Delete(tmp, 1, Length(line));
        Delete(Rawtext, 1, Length(line));
        pos := AnsiPos(INPUT_MARK, tmp);
    end;
end;

//! ToXṼANVUpdateCxg@ȒP̂߃^C}[ƓɂĂ
procedure TEditorForm.UpdateSambaActionUpdate(Sender: TObject);
begin
	UpdateSambaAction.Enabled := FSambaTimer.Enabled;
end;

//! ToXVANV
procedure TEditorForm.UpdateSambaActionExecute(Sender: TObject);
var
	input : String;
	i : Integer;
begin
	if InputQuery('Samba24ݒlXV', 'Vݒl͂Ă', input) then begin
        input := ZenToHan(input);
		if GikoSys.IsNumeric(input) then begin
            FSambaTimer.UpdateSambaSetting(StrToInt(input));
            UpdateSambaStatus;
			//SẴtH[ASamba^C}[XV
			for i := 0 to Screen.FormCount - 1 do begin
				if Screen.Forms[i] is TEditorForm then begin
                    TEditorForm(Screen.Forms[i]).FSambaTimer.Update;
                    TEditorForm(Screen.Forms[i]).UpdateSambaStatus;
                end;
			end;
		end else begin
			ShowMessage('l͂Ă');
			UpdateSambaActionExecute(Sender);
		end;
	end;
end;

procedure TEditorForm.UpdateSambaStatus;
begin
    if (FSambaTimer.Enabled) then begin
        StatusBar.Panels[2].Text
            := 'Samba24Kl' + IntToStr(FSambaTimer.SambaInterval);
    end;
end;

procedure TEditorForm.InputAssistActionExecute(Sender: TObject);
var
	count, i : Integer;
	item : TMenuItem;
	point: TPoint;
	Bitmap : TBitmap;
	TextWidth, ItemWidth, tmpWidth: Integer;
begin
	if FInputAssistKey = '' then Exit;

	InputAssistPopupMenu.Items.Clear;

	if (FResistWords = nil) then begin
		FResistWords := TStringList.Create;
	end else begin
		FResistWords.Clear;
	end;

	if (GetKeyState( VK_SHIFT ) < 0) then begin
		// VtgĂ΁AL[Ŏn܂JeS
		count :=
			InputAssistDM.GetStartWithCategoryResistWords(
									FInputAssistKey, FResistWords);
	end else begin
		// VtĝŁAL[Ŏn܂L[
		count :=
			InputAssistDM.GetStartWithKeyResistWords(
									FInputAssistKey, FResistWords);
	end;
	Bitmap := TBitmap.Create;
	try
		Bitmap.Canvas.Font.Assign(BodyEdit.Font);
		// }[W5px
		TextWidth := Bitmap.Canvas.TextWidth(FInputAssistKey) + 5;
		ItemWidth := 0;
		for i := 0 to count - 1 do begin
			item := TMenuItem.Create(nil);
			item.Break := mbNone;
			item.Caption := FResistWords[i];
			item.Tag := i;
			item.OnClick := InputAssistMenuClick;
			InputAssistPopupMenu.Items.Add(item);

			tmpWidth := Bitmap.Canvas.TextWidth(Item.Caption);
			if (tmpWidth > ItemWidth) then begin
				ItemWidth := tmpWidth;
			end;
		end;
	finally
		Bitmap.Free;
	end;

	if (count > 0) then begin
		GetCaretpos(point);
		point.X := point.X + Self.Left + (Self.Width - BodyEdit.Width) div 2;
		point.Y := point.Y + Self.Top + (Self.Height - Self.ClientHeight);

		if Screen.DesktopWidth >
			(point.X + TextWidth + ItemWidth) then begin
			InputAssistPopupMenu.Popup(
				point.X + TextWidth,
				point.Y + EditorPage.Top + EditorPage.TabHeight + BodyEdit.Top);
		end else begin
			InputAssistPopupMenu.Popup(
				point.X - TextWidth - ItemWidth,
				point.Y + EditorPage.Top + EditorPage.TabHeight + BodyEdit.Top);
		end;
	end;
end;

procedure TEditorForm.InputAssistMenuClick(Sender: TObject);
var
	text : String;
	IMC: HIMC;
begin
	if not (Sender is TMenuItem) then Exit;

	if (FResistWords <> nil) then begin
		try
			text :=
				TResistWord(FResistWords.Objects[TMenuItem(Sender).Tag]).GetText;
		except
			text := '';
		end;
		IMC := ImmGetContext(BodyEdit.Handle); //ReLXg擾
		try
			ImmNotifyIME(IMC, NI_COMPOSITIONSTR, CPS_CANCEL, 0);
		finally
			ImmReleaseContext(BodyEdit.Handle, IMC);  //ReLXg
		end;

		FResistWords.Clear;
		FInputAssistKey := '';
	end;
	InsertText(BodyEdit, text);
end;

//! TMemõJ[\ʒuɕ}
procedure TEditorForm.InsertText(Memo: TMemo; Text: String);
var
	line, sel, pos: Integer;
	left, right : String;
begin
	Memo.Lines.BeginUpdate;
	line := SendMessage(Memo.Handle,EM_LINEFROMCHAR,-1,0);  //s
	sel := Memo.SelStart;
	pos	:= sel - SendMessage(Memo.Handle, EM_LINEINDEX, -1, 0); //
	if (pos > 0) then begin
		left := Copy(Memo.Lines[line], 0, pos);
	end else begin
		left := '';
	end;
	right := Copy(Memo.Lines[line], pos + 1, Length(Memo.Lines[line]));
	Memo.Lines.Strings[line] := left + Text + right;
	Memo.Lines.EndUpdate;
	//@Lbg̈ʒuXV
	Memo.SelStart := sel + Length(text);
	// Lbg̈ʒu܂ŃXN[
	Memo.Perform(EM_SCROLLCARET, 0, 0);

end;

procedure TEditorForm.ApplicationEvents1Message(var Msg: tagMSG;
  var Handled: Boolean);
var
	wmMsg: TWMKey;
	IMC: HIMC;
	Len: integer;
	Str: string;
begin
	if (Self.Active) then begin
		case Msg.message of
			//L[̂ݎ󂯎
			WM_KEYDOWN:
			begin
				// ^uhҏWhCtrlL[Ă̂mF
				if (EditorPage.ActivePageIndex = 0)
						and (GetKeyState( VK_CONTROL ) < 0) then begin
					wmMsg.Msg := Msg.message;
					wmMsg.CharCode := Word(Msg.wParam);
					wmMsg.KeyData := Msg.lParam;
					if (wmMsg.CharCode = 229) and (wmMsg.KeyData = 3735553) then begin
						IMC := ImmGetContext(BodyEdit.Handle); //ReLXg擾
						Len := ImmGetCompositionString(IMC, GCS_COMPSTR, nil, 0); //܂擾
						if (Len > 0) then begin
							SetLength(Str, Len + 1); //Buffer̃ݒ
							ImmGetCompositionString(IMC, GCS_COMPSTR, PChar(Str), Len + 1); //܂擾
							SetLength(Str, Len);
							FInputAssistKey := Str;
							InputAssistActionExecute(nil);
							Handled := True;
						end;
						ImmReleaseContext(BodyEdit.Handle, IMC);  //ReLXg
					end;
				end;
			end;
		end;

	end;
end;

procedure TEditorForm.ShowInputAssistFormExecute(Sender: TObject);
var
	form : TInputAssistForm;
begin
	form := TInputAssistForm.Create(nil);
	try
		if TopAction.Checked then begin // XeCԂɐݒ
			SetWindowPos(form.Handle, HWND_TOPMOST, 0, 0, 0, 0, SWP_NOMOVE + SWP_NOSIZE);
        end;
		form.SetUpFromEditor;
		if (form.ShowModal = mrOk) then begin
			InsertText(BodyEdit, form.GetInsertText);
		end;
	finally
		form.Release;
	end;
end;
//! Cookie폜
procedure TEditorForm.ReleaseCookieActionExecute(Sender: TObject);
var
	Board : TBoard;
begin
	// Xbh@XĂ̂ƂFBoard𒼐ڎg
    Board := GetBoard;

	// NbL[̏̂Ă
	Board.Cookie := '';
	Board.SPID := '';
	Board.PON  := '';
	// 0Ɋ߂
	Board.Expires := 0;
end;
//! 擾UpdateCxg
procedure TEditorForm.GetSETTINGTXTActionUpdate(Sender: TObject);
begin
	// s͎ss
	GetSETTINGTXTAction.Enabled := not FWork;
end;
//! [J[擾UpdateCxg
procedure TEditorForm.GetHeadTXTActionUpdate(Sender: TObject);
begin
	// s͎ss
	GetSETTINGTXTAction.Enabled := not FWork;
end;

//! Samba^C}[Cxg
procedure TEditorForm.SambaTimer(Sender: TObject);
begin

	if FSambaTimer.WriteDeta = ZERO_DATE then
		StatusBar.Panels[1].Text := ''
	else begin
		FNow := IncMilliSecond(FNow, 500);
		StatusBar.Panels[1].Text :=
            Format('%8.0fbo', [SecondSpan(FNow, FSambaTimer.WriteDeta)]);
	end;
end;
{
\brief EBhËʒuƃTCY̐ݒ
}
procedure TEditorForm.SetWindowRect;
var
    wp: TWindowPlacement;
    MonCnt: Integer;
    MonOk: Boolean;
    MonR: Integer;
    MonB: Integer;
    Right: Integer;
    Bottom: Integer;
begin
	//EBhËʒuݒ
	wp.length := sizeof(wp);
	wp.rcNormalPosition.Top := GikoSys.Setting.EditWindowTop;
	wp.rcNormalPosition.Left := GikoSys.Setting.EditWindowLeft;

	wp.rcNormalPosition.Bottom := GikoSys.Setting.EditWindowTop + GikoSys.Setting.EditWindowHeight;
	wp.rcNormalPosition.Right := GikoSys.Setting.EditWindowLeft + GikoSys.Setting.EditWindowWidth;
	wp.showCmd := SW_HIDE;
	SetWindowPlacement(Handle, @wp);

	if GikoSys.Setting.EditWindowMax then begin
		WindowState := wsMaximized;
    end;

	//EBhEʊOȂʓɈړ
    Right := Left + Width;
    Bottom := Top + Height;
    MonOk := False;
    MonCnt := 0;
    while (MonCnt < Screen.MonitorCount) do begin
        MonR := Screen.Monitors[MonCnt].Left + Screen.Monitors[MonCnt].Width;
        MonB := Screen.Monitors[MonCnt].Top  + Screen.Monitors[MonCnt].Height;

        if ((Left  >= Screen.Monitors[MonCnt].Left) and (Left   <  MonR) and
            (Top   >= Screen.Monitors[MonCnt].Top)  and (Top    <  MonB) and
            (Right  > Screen.Monitors[MonCnt].Left) and (Right  <= MonR) and
            (Bottom > Screen.Monitors[MonCnt].Top)  and (Bottom <= MonB)) then begin
            MonOk := True;
            Break;
        end;

        MonCnt := MonCnt + 1;
    end;

    if (MonOk = False) then begin
        Left := 0;
        Top := 0;
    end;

    //݂̃EBhËʒuۑ
    GikoSys.Setting.EditWindowTop := Top  + WINDOWMOVE_V;   // ɊJEBhE
    GikoSys.Setting.EditWindowLeft := Left + WINDOWMOVE_H;  // @@@E΂߉ɂ炷
    //EBhE̕ƍΌɖ߂
	if GikoSys.Setting.EditWindowHeight < 144 then begin
		Height := 400;
    end;
	if GikoSys.Setting.EditWindowWidth < 144 then begin
		Width := 640;
    end;
end;
{
\brief g^uݒ
}
procedure TEditorForm.SetExtraTab;
const
    SECTION = 'EditorForm';
var
    ini: TMemIniFile;
begin
    ini := TMemIniFile.Create(GikoSys.Setting.GetFileName);
    try
        BoardtopTab.TabVisible := ini.Readbool(SECTION, 'BoardTopTab', False);
        BoardTop.Checked := BoardtopTab.TabVisible;
        RocalRuleTab.TabVisible := ini.ReadBool(SECTION, 'LocalRuleTab', False);
        LocalRule.Checked := RocalRuleTab.TabVisible;
    finally
        ini.Free;
    end;
end;
{
\brief 擾
\return XGfB^e悤ƂĂ
}
function TEditorForm.GetBoard : TBoard;
begin
    // XbhACenull̎FBoard
    if FThreadItem = nil then begin
        Result := FBoard;
    end else  begin
        Result := FThreadItem.ParentBoard;
    end;
end;
{
\brief  GikoFormɃbZ[Wǉ
\param  icon    bZ[WɂACR
}
procedure TEditorForm.AddFormMessageNew(icon: TGikoMessageIcon);
begin
    if FThreadItem = nil then begin
        GikoForm.AddMessageList(FBoard.Title + ' ' + GikoSys.GetGikoMessage(gmNewSure), nil, icon)
    end else begin
        GikoForm.AddMessageList(FThreadItem.Title + ' ' + GikoSys.GetGikoMessage(gmNewRes), nil, icon);
    end;

end;
{
\brief  [Jfusianagbv
\return true:M~ false:M
}
function TEditorForm.isLocalFusianaTrap: Boolean;
var
    Namae : string;
begin
    Result := False;
    if GikoSys.Setting.LocalTrapAtt then begin
        Namae := THTMLCreate.RepHtml(NameComboBox.Text);
        if (LFusianaGet(Namae)) or (Namae = 'R') then begin
            if FusianaMsgBox = IDNO  then begin
                Result := True;
            end;
        end;
    end;
end;
{
\brief  [gfusianagbv
\return true:M~ false:M
}
function TEditorForm.isRemoteFusianaTrap: Boolean;
var
    Namae : string;
    Board : TBoard;
    Remote: string;
    body : TStringList;
begin
    Result := False;
    Namae := THTMLCreate.RepHtml(NameComboBox.Text);
    if (GikoSys.Setting.RemoteTrapAtt) and (Length(Namae) = 0) then begin
        Board := GetBoard;

        if Board = nil then Exit;

        if not FileExists(Board.GetSETTINGTXTFileName)  then begin
            //Setting.txtȂ擾
            //Iɕׂ肻...
            try
                GetSETTINGTXTAction.Execute;
            except
            end;
        end;

        Remote := '';
        if FileExists(Board.GetSETTINGTXTFileName)  then begin
            body := TStringList.Create;
            try
                body.LoadFromFile(Board.GetSETTINGTXTFileName);
                Remote := GetFusianaName(body, Board);
            finally
                body.Free;
            end;
        end;

        if LFusianaGet(Remote) then begin
            if FusianaMsgBox = IDNO  then begin
                Result := True;
            end;
        end;
    end;
end;
{
\brief  Header擾
\param  ACOOKIE Cookie
\param  SPID    SPID
\param  PON    PON
\param  HAP     HAP
\param  Board   
\return Header
}
function TEditorForm.getHeaderStr(const ACOOKIE: string; const SPID : string;
    const PON : string; const HAP : string; Board : TBoard) : string;
begin
    Result := ACOOKIE;

	if SPID <> '' then
		Result := Result + 'SPID=' + SPID + '; ';
	if PON <> '' then
		Result := Result + 'PON=' + PON + '; ';

	//zXg2chŁABeLoginĂBẼf[^𑗂
	//GikoSys.ParseURI( URL, Protocol,Host, Path, Document, Port, Bookmark );
	//if GikoSys.Is2chHost(Host) and GikoSys.Setting.BeLogin then
	if (Board.Is2ch) then begin
		// Œ̃NbL[ΐH킹
		if Length(GikoSys.Setting.FixedCookie) > 0 then begin
			// zXg2ch̏ꍇCŒ̃NbL[H킹
			Result := Result + GikoSys.Setting.FixedCookie + '; ';
		end;
        if (GikoSys.Belib.Connected) then begin
			Result := Result + 'MDMD=' + GikoSys.Belib.MDMD + '; '
                             + 'DMDM=' + GikoSys.Belib.DMDM + '; ';
		end;
    end;

	Result := 'Cookie: ' + Result + 'NAME=' + NameComboBox.Text + '; MAIL=' + MailComboBox.Text;

    if HAP <> '' then
    	Result := Result + '; HAP=' + HAP + '; ';

end;

{
\brief fusianax_CAO
\return IDYES  IDNO ~
}
function TEditorForm.FusianaMsgBox: Integer;
const
	MSG_FUSIANA : string =	'[gzXg\@\gĂ܂'#13#10 +
		'ԈĂ̕@ŃzXg\ꂽƂĂAȐӔCȂ̂ō폜˗ɂ͉܂B' +
		#13#10#13#10'ӔC𕉂Ƃď݂܂H';
begin
    Result := MsgBox(Handle, MSG_FUSIANA, '',
                MB_YESNO or MB_ICONQUESTION);
end;
{
\brief A[hON/OFF؂ւ
}
procedure TEditorForm.ContinueModeActionExecute(Sender: TObject);
begin
	ContinueModeAction.Checked := not ContinueModeAction.Checked;
end;
{
\brief A[hXV
}
procedure TEditorForm.ContinueModeActionUpdate(Sender: TObject);
begin
    // XĂ̂Ƃ͖
    ContinueModeAction.Enabled := FThreadItem <> nil;
end;
{
\brief ޔ/Xbh\
}
procedure TEditorForm.OpenSendTargetActionExecute(Sender: TObject);
begin
    if (FThreadItem <> nil) then begin
        // CXVĂ܂̂ŉʂp^p^؂ւ̂h߂
        // OʂŌŒ肷
        if not (fsShowing in Self.FormState) then begin
            // XeCԂɐݒ
            SetWindowPos(Handle, HWND_TOPMOST, 0, 0, 0, 0, SWP_NOMOVE + SWP_NOSIZE);
        end;
        try
            // Xbh
            GikoForm.InsertBrowserTab(FThreadItem, True);
        finally
            if not TopAction.Checked then begin // XeCԉ
                SetWindowPos(Handle, HWND_NOTOPMOST, 0, 0, 0, 0, SWP_NOMOVE + SWP_NOSIZE);
            end;
        end;
        Self.SetFocus;
    end else begin
        // 
        GikoForm.SelectTreeNode(
            GetBoard, True );
    end;
end;
procedure TEditorForm.ReloadTargetActionExecute(Sender: TObject);
begin
    if (FThreadItem <> nil) then begin
        // Xbh
        // CXVĂ܂̂ŉʂp^p^؂ւ̂h߂
        // OʂŌŒ肷(_E[hƐ؂ւĂ܂߂)
        if not (fsShowing in Self.FormState) then begin
            // XeCԂɐݒ
            SetWindowPos(Handle, HWND_TOPMOST, 0, 0, 0, 0, SWP_NOMOVE + SWP_NOSIZE);
        end;
        try
            GikoForm.DownloadContent(FThreadItem);
        finally
            if not TopAction.Checked then begin // XeCԉ
                SetWindowPos(Handle, HWND_NOTOPMOST, 0, 0, 0, 0, SWP_NOMOVE + SWP_NOSIZE);
            end;
        end;
        Self.SetFocus;
    end else begin
        // 
        GikoForm.DownloadList(GetBoard);
    end;
end;
//! 딚`FbN
function TEditorForm.isGobaku: Boolean;
const
	MSG_GOBAKU : string =
        '\Ă%sƓe%sقȂ܂B'#13#10 +
		'̂܂܏݂܂H';
var
    ThreadItem : TThreadItem;
    msg : String;

begin
    Result := False;
    // IvVLXMł̂ݗL
    if (GikoSys.Setting.UseGobakuCheck) then begin
        // XM
        if (FThreadItem <> nil) then begin
            ThreadItem := GikoForm.GetActiveContent(False);
            if (ThreadItem <> nil) then begin
                if (FThreadItem <> ThreadItem) then begin
                    msg := Format(MSG_GOBAKU, ['Xbh', 'Xbh']);
                    Result := MsgBox(Handle, msg, '', MB_YESNO or MB_ICONQUESTION) = IDNO;
                end;
            end else begin
                if GikoForm.ActiveList is TBBS then begin
                    if TBBS(GikoForm.ActiveList) <> FThreadItem.ParentBoard.ParentCategory.ParenTBBS then begin
                        msg := Format(MSG_GOBAKU, ['BBS', 'Xbh̏BBS']);
                        Result := MsgBox(Handle, msg, '', MB_YESNO or MB_ICONQUESTION) = IDNO;
                    end;
                end else if GikoForm.ActiveList is TCategory then begin
                    if TCategory(GikoForm.ActiveList).FindThreadFromURL(FThreadItem.URL) = nil then begin
                        msg := Format(MSG_GOBAKU, ['JeS', 'Xbh̏JeS']);
                        Result := MsgBox(Handle, msg, '', MB_YESNO or MB_ICONQUESTION) = IDNO;
                    end;
                end else if GikoForm.ActiveList is TBoard then begin
                    if TBoard(GikoForm.ActiveList) <> FThreadItem.ParentBoard then begin
                        msg := Format(MSG_GOBAKU, ['', 'Xbh̏']);
                        Result := MsgBox(Handle, msg, '', MB_YESNO or MB_ICONQUESTION) = IDNO;
                    end;
                end;
            end;
        end else begin
            // X
            if GikoForm.ActiveList is TBBS then begin
                if TBBS(GikoForm.ActiveList) <> FBoard.ParentCategory.ParenTBBS then begin
                    msg := Format(MSG_GOBAKU, ['BBS', '̏BBS']);
                    Result := MsgBox(Handle, msg, '', MB_YESNO or MB_ICONQUESTION) = IDNO;
                end;
            end else if GikoForm.ActiveList is TCategory then begin
                if TCategory(GikoForm.ActiveList).FindBoardFromURL(FBoard.URL) = nil then begin
                    msg := Format(MSG_GOBAKU, ['JeS', '̏JeS']);
                    Result := MsgBox(Handle, msg, '', MB_YESNO or MB_ICONQUESTION) = IDNO;
                end;
            end else if GikoForm.ActiveList is TBoard then begin
                if TBoard(GikoForm.ActiveList) <> FBoard then begin
                    msg := Format(MSG_GOBAKU, ['', '']);
                    Result := MsgBox(Handle, msg, '', MB_YESNO or MB_ICONQUESTION) = IDNO;
                end;
            end;
        end;
    end;
end;

end.
