unit SambaTimer;

interface

uses
	Windows, SysUtils, Classes, ExtCtrls,
    BoardGroup, GikoSystem;

type
    {
    \brief  Samba24΍^C}[NX
    }
    TSambaTimer = class(TTimer)
    private
        FKey : string;
        FWriteDeta : TDateTime;
        FSambaInterval : Integer;
        procedure ReadSambaTime;
        procedure ReadSettingTime(Board: TBoard);
    public
        function SetBoard(Board : TBoard): integer;
        function CheckSambaTime(ATime: TDateTime): Boolean;
        procedure WriteSambaTime(ATime: TDateTime);
        procedure UpdateSambaSetting(Interval : Integer);
        function Update : TDateTime;
        property WriteDeta : TDateTime read FWriteDeta;
        property SambaInterval : Integer read FSambaInterval;
    end;

implementation

uses
    IniFiles, DateUtils;
{
\brief  To^C}[ݒ
\param  Board   XGfB^̔
\return Samba̐ݒl
}
function TSambaTimer.SetBoard(Board : TBoard): Integer;
begin
    Result := -1;
    Enabled := False;
    if (GikoSys.Setting.UseSamba) and (Board <> nil) then begin
        // 2chɑĂꍇC^C}[Lɂ
        if (Board.Is2ch) then begin
            ReadSettingTime(Board);
            ReadSambaTime;
            Interval := 500;
            Result := FSambaInterval;
        end;
    end;
end;
{
\brief Samba̋Klǂݍ
}
procedure TSambaTimer.ReadSettingTime(Board: TBoard);
var
	ini :TMemIniFile;
	Protocol, Host, Path, Document, Port, Bookmark : string;
begin
	Enabled := false; //oߕb\TimerOffɂ
	ini := TMemIniFile.Create(GikoSys.GetSambaFileName);
	try
        if (Board <> nil) then begin
            // ܂BBSIDŌʂɐݒ肳ĂȂmF
            FKey := '@' + Board.BBSID;
            FSambaInterval := ini.ReadInteger('Setting', FKey, -1);
            if (FSambaInterval = -1) then begin
                // ݒ肳ĂȂ̂ŃzXg̐ݒĂ
                GikoSys.ParseURI( Board.URL, Protocol, Host, Path, Document, Port, Bookmark );
                FKey := Copy(Host, 1, AnsiPos('.', Host) - 1);
                FSambaInterval := ini.ReadInteger('Setting', FKey, -1);
		        //ݒ肳ĂȂƂ́At@CɏB
		        if FSambaInterval = -1 then begin
                    FSambaInterval := 0;
    			    ini.WriteInteger('Setting', FKey, 0);
	    		    ini.UpdateFile;
		        end;
            end;
        end else begin
            FSambaInterval := ini.ReadInteger('Setting', FKey, -1);
        end;
	finally
		ini.Free;
	end;
	Enabled := true; //oߕb\TimerOnɂ
end;

{
\brief Samba.inȉݎԂǂݍ
}
procedure TSambaTimer.ReadSambaTime;
var
	ini :TMemIniFile;
begin
	Enabled := false; //oߕb\TimerOffɂ
	ini := TMemIniFile.Create(GikoSys.GetSambaFileName);
	try
		 //œǂݎāAϊ֐TDateTime
		 FWriteDeta := ConvertDateTimeString(
                ini.ReadString('Send', FKey, ''));
	finally
		ini.Free;
	end;
	Enabled := true; //oߕb\TimerOnɂ
end;
{
\brief  Samba.iniɍŏIݎԂ
}
procedure TSambaTimer.WriteSambaTime(ATime: TDateTime);
var
	ini :TMemIniFile;
begin
	ini := TMemIniFile.Create(GikoSys.GetSambaFileName);
	try
		ini.WriteDateTime('Send', FKey, ATime);
		ini.UpdateFile;
	finally
		ini.Free;
	end;
end;

{
\brief  ŏIݎԂƌݎr
\return ^FKlȏ@UFKl
}
function TSambaTimer.CheckSambaTime(ATime: TDateTime): Boolean;
var
	pastsec: double;
begin
	pastsec := SecondSpan(ATime, FWriteDeta);
	Result := (pastsec > FSambaInterval);
end;
{
\breif  ^C}[XV
}
function TSambaTimer.Update : TDateTime;
begin
    ReadSettingTime( nil );
    ReadSambaTime;
    Result := Now();
end;
{
\biref  SambaݒlXV
\param  Interval    ݒl
}
procedure TSambaTimer.UpdateSambaSetting(Interval : Integer);
var
	ini :TMemIniFile;
begin
	Enabled := false; //oߕb\TimerOffɂ
	ini := TMemIniFile.Create(GikoSys.GetSambaFileName);
	try
        FSambaInterval := Interval;
        ini.WriteInteger('Setting', FKey, FSambaInterval);
        ini.UpdateFile;
	finally
		ini.Free;
	end;
	Enabled := true; //oߕb\TimerOnɂ
end;

end.
