/* GIMP - The GNU Image Manipulation Program
 * Copyright (C) 1995-2003 Spencer Kimball and Peter Mattis
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/* NOTE: This file is auto-generated by pdbgen.pl. */

#include "config.h"

#include <gegl.h>

#include "pdb-types.h"

#include "core/gimpchannel.h"
#include "core/gimpdrawable.h"
#include "core/gimpimage.h"
#include "core/gimplayer.h"
#include "core/gimpparamspecs.h"
#include "core/gimppickable.h"
#include "core/gimpselection.h"

#include "gimppdb.h"
#include "gimppdb-utils.h"
#include "gimpprocedure.h"
#include "internal-procs.h"

#include "gimp-intl.h"


static GValueArray *
selection_bounds_invoker (GimpProcedure      *procedure,
                          Gimp               *gimp,
                          GimpContext        *context,
                          GimpProgress       *progress,
                          const GValueArray  *args,
                          GError            **error)
{
  gboolean success = TRUE;
  GValueArray *return_vals;
  GimpImage *image;
  gboolean non_empty = FALSE;
  gint32 x1 = 0;
  gint32 y1 = 0;
  gint32 x2 = 0;
  gint32 y2 = 0;

  image = gimp_value_get_image (&args->values[0], gimp);

  if (success)
    {
      non_empty = gimp_channel_bounds (gimp_image_get_mask (image),
                                       &x1, &y1, &x2, &y2);
    }

  return_vals = gimp_procedure_get_return_values (procedure, success,
                                                  error ? *error : NULL);

  if (success)
    {
      g_value_set_boolean (&return_vals->values[1], non_empty);
      g_value_set_int (&return_vals->values[2], x1);
      g_value_set_int (&return_vals->values[3], y1);
      g_value_set_int (&return_vals->values[4], x2);
      g_value_set_int (&return_vals->values[5], y2);
    }

  return return_vals;
}

static GValueArray *
selection_value_invoker (GimpProcedure      *procedure,
                         Gimp               *gimp,
                         GimpContext        *context,
                         GimpProgress       *progress,
                         const GValueArray  *args,
                         GError            **error)
{
  gboolean success = TRUE;
  GValueArray *return_vals;
  GimpImage *image;
  gint32 x;
  gint32 y;
  gint32 value = 0;

  image = gimp_value_get_image (&args->values[0], gimp);
  x = g_value_get_int (&args->values[1]);
  y = g_value_get_int (&args->values[2]);

  if (success)
    {
      value = gimp_pickable_get_opacity_at (GIMP_PICKABLE (gimp_image_get_mask (image)), x, y);
    }

  return_vals = gimp_procedure_get_return_values (procedure, success,
                                                  error ? *error : NULL);

  if (success)
    g_value_set_int (&return_vals->values[1], value);

  return return_vals;
}

static GValueArray *
selection_is_empty_invoker (GimpProcedure      *procedure,
                            Gimp               *gimp,
                            GimpContext        *context,
                            GimpProgress       *progress,
                            const GValueArray  *args,
                            GError            **error)
{
  gboolean success = TRUE;
  GValueArray *return_vals;
  GimpImage *image;
  gboolean is_empty = FALSE;

  image = gimp_value_get_image (&args->values[0], gimp);

  if (success)
    {
      is_empty = gimp_channel_is_empty (gimp_image_get_mask (image));
    }

  return_vals = gimp_procedure_get_return_values (procedure, success,
                                                  error ? *error : NULL);

  if (success)
    g_value_set_boolean (&return_vals->values[1], is_empty);

  return return_vals;
}

static GValueArray *
selection_translate_invoker (GimpProcedure      *procedure,
                             Gimp               *gimp,
                             GimpContext        *context,
                             GimpProgress       *progress,
                             const GValueArray  *args,
                             GError            **error)
{
  gboolean success = TRUE;
  GimpImage *image;
  gint32 offx;
  gint32 offy;

  image = gimp_value_get_image (&args->values[0], gimp);
  offx = g_value_get_int (&args->values[1]);
  offy = g_value_get_int (&args->values[2]);

  if (success)
    {
      gimp_item_translate (GIMP_ITEM (gimp_image_get_mask (image)),
                           offx, offy, TRUE);
    }

  return gimp_procedure_get_return_values (procedure, success,
                                           error ? *error : NULL);
}

static GValueArray *
selection_float_invoker (GimpProcedure      *procedure,
                         Gimp               *gimp,
                         GimpContext        *context,
                         GimpProgress       *progress,
                         const GValueArray  *args,
                         GError            **error)
{
  gboolean success = TRUE;
  GValueArray *return_vals;
  GimpDrawable *drawable;
  gint32 offx;
  gint32 offy;
  GimpLayer *layer = NULL;

  drawable = gimp_value_get_drawable (&args->values[0], gimp);
  offx = g_value_get_int (&args->values[1]);
  offy = g_value_get_int (&args->values[2]);

  if (success)
    {
      if (gimp_pdb_item_is_attached (GIMP_ITEM (drawable), NULL, TRUE, error) &&
          gimp_pdb_item_is_not_group (GIMP_ITEM (drawable), error))
        {
          GimpImage *image = gimp_item_get_image (GIMP_ITEM (drawable));

          layer = gimp_selection_float (GIMP_SELECTION (gimp_image_get_mask (image)),
                                        drawable, context, TRUE, offx, offy,
                                        error);
          if (! layer)
            success = FALSE;
        }
      else
        success = FALSE;
    }

  return_vals = gimp_procedure_get_return_values (procedure, success,
                                                  error ? *error : NULL);

  if (success)
    gimp_value_set_layer (&return_vals->values[1], layer);

  return return_vals;
}

static GValueArray *
selection_invert_invoker (GimpProcedure      *procedure,
                          Gimp               *gimp,
                          GimpContext        *context,
                          GimpProgress       *progress,
                          const GValueArray  *args,
                          GError            **error)
{
  gboolean success = TRUE;
  GimpImage *image;

  image = gimp_value_get_image (&args->values[0], gimp);

  if (success)
    {
      gimp_channel_invert (gimp_image_get_mask (image), TRUE);
    }

  return gimp_procedure_get_return_values (procedure, success,
                                           error ? *error : NULL);
}

static GValueArray *
selection_sharpen_invoker (GimpProcedure      *procedure,
                           Gimp               *gimp,
                           GimpContext        *context,
                           GimpProgress       *progress,
                           const GValueArray  *args,
                           GError            **error)
{
  gboolean success = TRUE;
  GimpImage *image;

  image = gimp_value_get_image (&args->values[0], gimp);

  if (success)
    {
      gimp_channel_sharpen (gimp_image_get_mask (image), TRUE);
    }

  return gimp_procedure_get_return_values (procedure, success,
                                           error ? *error : NULL);
}

static GValueArray *
selection_all_invoker (GimpProcedure      *procedure,
                       Gimp               *gimp,
                       GimpContext        *context,
                       GimpProgress       *progress,
                       const GValueArray  *args,
                       GError            **error)
{
  gboolean success = TRUE;
  GimpImage *image;

  image = gimp_value_get_image (&args->values[0], gimp);

  if (success)
    {
      gimp_channel_all (gimp_image_get_mask (image), TRUE);
    }

  return gimp_procedure_get_return_values (procedure, success,
                                           error ? *error : NULL);
}

static GValueArray *
selection_none_invoker (GimpProcedure      *procedure,
                        Gimp               *gimp,
                        GimpContext        *context,
                        GimpProgress       *progress,
                        const GValueArray  *args,
                        GError            **error)
{
  gboolean success = TRUE;
  GimpImage *image;

  image = gimp_value_get_image (&args->values[0], gimp);

  if (success)
    {
      gimp_channel_clear (gimp_image_get_mask (image), NULL, TRUE);
    }

  return gimp_procedure_get_return_values (procedure, success,
                                           error ? *error : NULL);
}

static GValueArray *
selection_feather_invoker (GimpProcedure      *procedure,
                           Gimp               *gimp,
                           GimpContext        *context,
                           GimpProgress       *progress,
                           const GValueArray  *args,
                           GError            **error)
{
  gboolean success = TRUE;
  GimpImage *image;
  gdouble radius;

  image = gimp_value_get_image (&args->values[0], gimp);
  radius = g_value_get_double (&args->values[1]);

  if (success)
    {
      gimp_channel_feather (gimp_image_get_mask (image),
                            radius, radius, TRUE);
    }

  return gimp_procedure_get_return_values (procedure, success,
                                           error ? *error : NULL);
}

static GValueArray *
selection_border_invoker (GimpProcedure      *procedure,
                          Gimp               *gimp,
                          GimpContext        *context,
                          GimpProgress       *progress,
                          const GValueArray  *args,
                          GError            **error)
{
  gboolean success = TRUE;
  GimpImage *image;
  gint32 radius;

  image = gimp_value_get_image (&args->values[0], gimp);
  radius = g_value_get_int (&args->values[1]);

  if (success)
    {
      /* FIXME: "feather" and "edge-lock" hardcoded to TRUE */
      gimp_channel_border (gimp_image_get_mask (image),
                           radius, radius, TRUE, TRUE, TRUE);
    }

  return gimp_procedure_get_return_values (procedure, success,
                                           error ? *error : NULL);
}

static GValueArray *
selection_grow_invoker (GimpProcedure      *procedure,
                        Gimp               *gimp,
                        GimpContext        *context,
                        GimpProgress       *progress,
                        const GValueArray  *args,
                        GError            **error)
{
  gboolean success = TRUE;
  GimpImage *image;
  gint32 steps;

  image = gimp_value_get_image (&args->values[0], gimp);
  steps = g_value_get_int (&args->values[1]);

  if (success)
    {
      gimp_channel_grow (gimp_image_get_mask (image),
                         steps, steps, TRUE);
    }

  return gimp_procedure_get_return_values (procedure, success,
                                           error ? *error : NULL);
}

static GValueArray *
selection_shrink_invoker (GimpProcedure      *procedure,
                          Gimp               *gimp,
                          GimpContext        *context,
                          GimpProgress       *progress,
                          const GValueArray  *args,
                          GError            **error)
{
  gboolean success = TRUE;
  GimpImage *image;
  gint32 steps;

  image = gimp_value_get_image (&args->values[0], gimp);
  steps = g_value_get_int (&args->values[1]);

  if (success)
    {
      gimp_channel_shrink (gimp_image_get_mask (image),
                           steps, steps, FALSE, TRUE);
    }

  return gimp_procedure_get_return_values (procedure, success,
                                           error ? *error : NULL);
}

static GValueArray *
selection_layer_alpha_invoker (GimpProcedure      *procedure,
                               Gimp               *gimp,
                               GimpContext        *context,
                               GimpProgress       *progress,
                               const GValueArray  *args,
                               GError            **error)
{
  gboolean success = TRUE;
  GimpLayer *layer;

  layer = gimp_value_get_layer (&args->values[0], gimp);

  if (success)
    {
      if (gimp_pdb_item_is_attached (GIMP_ITEM (layer), NULL, FALSE, error))
        gimp_item_to_selection (GIMP_ITEM (layer),
                                GIMP_CHANNEL_OP_REPLACE,
                                TRUE, FALSE, 0.0, 0.0);
      else
        success = FALSE;
    }

  return gimp_procedure_get_return_values (procedure, success,
                                           error ? *error : NULL);
}

static GValueArray *
selection_load_invoker (GimpProcedure      *procedure,
                        Gimp               *gimp,
                        GimpContext        *context,
                        GimpProgress       *progress,
                        const GValueArray  *args,
                        GError            **error)
{
  gboolean success = TRUE;
  GimpChannel *channel;

  channel = gimp_value_get_channel (&args->values[0], gimp);

  if (success)
    {
      if (gimp_pdb_item_is_attached (GIMP_ITEM (channel), NULL, FALSE, error))
        gimp_item_to_selection (GIMP_ITEM (channel),
                                GIMP_CHANNEL_OP_REPLACE,
                                TRUE, FALSE, 0.0, 0.0);
      else
        success = FALSE;
    }

  return gimp_procedure_get_return_values (procedure, success,
                                           error ? *error : NULL);
}

static GValueArray *
selection_save_invoker (GimpProcedure      *procedure,
                        Gimp               *gimp,
                        GimpContext        *context,
                        GimpProgress       *progress,
                        const GValueArray  *args,
                        GError            **error)
{
  gboolean success = TRUE;
  GValueArray *return_vals;
  GimpImage *image;
  GimpChannel *channel = NULL;

  image = gimp_value_get_image (&args->values[0], gimp);

  if (success)
    {
      channel = gimp_selection_save (GIMP_SELECTION (gimp_image_get_mask (image)));

      if (! channel)
        success = FALSE;
    }

  return_vals = gimp_procedure_get_return_values (procedure, success,
                                                  error ? *error : NULL);

  if (success)
    gimp_value_set_channel (&return_vals->values[1], channel);

  return return_vals;
}

static GValueArray *
selection_combine_invoker (GimpProcedure      *procedure,
                           Gimp               *gimp,
                           GimpContext        *context,
                           GimpProgress       *progress,
                           const GValueArray  *args,
                           GError            **error)
{
  gboolean success = TRUE;
  GimpChannel *channel;
  gint32 operation;

  channel = gimp_value_get_channel (&args->values[0], gimp);
  operation = g_value_get_enum (&args->values[1]);

  if (success)
    {
      if (gimp_pdb_item_is_attached (GIMP_ITEM (channel), NULL, FALSE, error))
        gimp_item_to_selection (GIMP_ITEM (channel),
                                operation,
                                TRUE, FALSE, 0.0, 0.0);
      else
        success = FALSE;
    }

  return gimp_procedure_get_return_values (procedure, success,
                                           error ? *error : NULL);
}

void
register_selection_procs (GimpPDB *pdb)
{
  GimpProcedure *procedure;

  /*
   * gimp-selection-bounds
   */
  procedure = gimp_procedure_new (selection_bounds_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-selection-bounds");
  gimp_procedure_set_static_strings (procedure,
                                     "gimp-selection-bounds",
                                     "Find the bounding box of the current selection.",
                                     "This procedure returns whether there is a selection for the specified image. If there is one, the upper left and lower right corners of the bounding box are returned. These coordinates are relative to the image. Please note that the pixel specified by the lower righthand coordinate of the bounding box is not part of the selection. The selection ends at the upper left corner of this pixel. This means the width of the selection can be calculated as (x2 - x1), its height as (y2 - y1).",
                                     "Spencer Kimball & Peter Mattis",
                                     "Spencer Kimball & Peter Mattis",
                                     "1995-1996",
                                     NULL);
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_image_id ("image",
                                                         "image",
                                                         "The image",
                                                         pdb->gimp, FALSE,
                                                         GIMP_PARAM_READWRITE));
  gimp_procedure_add_return_value (procedure,
                                   g_param_spec_boolean ("non-empty",
                                                         "non empty",
                                                         "TRUE if there is a selection",
                                                         FALSE,
                                                         GIMP_PARAM_READWRITE));
  gimp_procedure_add_return_value (procedure,
                                   gimp_param_spec_int32 ("x1",
                                                          "x1",
                                                          "x coordinate of upper left corner of selection bounds",
                                                          G_MININT32, G_MAXINT32, 0,
                                                          GIMP_PARAM_READWRITE));
  gimp_procedure_add_return_value (procedure,
                                   gimp_param_spec_int32 ("y1",
                                                          "y1",
                                                          "y coordinate of upper left corner of selection bounds",
                                                          G_MININT32, G_MAXINT32, 0,
                                                          GIMP_PARAM_READWRITE));
  gimp_procedure_add_return_value (procedure,
                                   gimp_param_spec_int32 ("x2",
                                                          "x2",
                                                          "x coordinate of lower right corner of selection bounds",
                                                          G_MININT32, G_MAXINT32, 0,
                                                          GIMP_PARAM_READWRITE));
  gimp_procedure_add_return_value (procedure,
                                   gimp_param_spec_int32 ("y2",
                                                          "y2",
                                                          "y coordinate of lower right corner of selection bounds",
                                                          G_MININT32, G_MAXINT32, 0,
                                                          GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-selection-value
   */
  procedure = gimp_procedure_new (selection_value_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-selection-value");
  gimp_procedure_set_static_strings (procedure,
                                     "gimp-selection-value",
                                     "Find the value of the selection at the specified coordinates.",
                                     "This procedure returns the value of the selection at the specified coordinates. If the coordinates lie out of bounds, 0 is returned.",
                                     "Spencer Kimball & Peter Mattis",
                                     "Spencer Kimball & Peter Mattis",
                                     "1995-1996",
                                     NULL);
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_image_id ("image",
                                                         "image",
                                                         "The image",
                                                         pdb->gimp, FALSE,
                                                         GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_int32 ("x",
                                                      "x",
                                                      "x coordinate of value",
                                                      G_MININT32, G_MAXINT32, 0,
                                                      GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_int32 ("y",
                                                      "y",
                                                      "y coordinate of value",
                                                      G_MININT32, G_MAXINT32, 0,
                                                      GIMP_PARAM_READWRITE));
  gimp_procedure_add_return_value (procedure,
                                   gimp_param_spec_int32 ("value",
                                                          "value",
                                                          "Value of the selection",
                                                          0, 255, 0,
                                                          GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-selection-is-empty
   */
  procedure = gimp_procedure_new (selection_is_empty_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-selection-is-empty");
  gimp_procedure_set_static_strings (procedure,
                                     "gimp-selection-is-empty",
                                     "Determine whether the selection is empty.",
                                     "This procedure returns TRUE if the selection for the specified image is empty.",
                                     "Spencer Kimball & Peter Mattis",
                                     "Spencer Kimball & Peter Mattis",
                                     "1995-1996",
                                     NULL);
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_image_id ("image",
                                                         "image",
                                                         "The image",
                                                         pdb->gimp, FALSE,
                                                         GIMP_PARAM_READWRITE));
  gimp_procedure_add_return_value (procedure,
                                   g_param_spec_boolean ("is-empty",
                                                         "is empty",
                                                         "Is the selection empty?",
                                                         FALSE,
                                                         GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-selection-translate
   */
  procedure = gimp_procedure_new (selection_translate_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-selection-translate");
  gimp_procedure_set_static_strings (procedure,
                                     "gimp-selection-translate",
                                     "Translate the selection by the specified offsets.",
                                     "This procedure actually translates the selection for the specified image by the specified offsets. Regions that are translated from beyond the bounds of the image are set to empty. Valid regions of the selection which are translated beyond the bounds of the image because of this call are lost.",
                                     "Spencer Kimball & Peter Mattis",
                                     "Spencer Kimball & Peter Mattis",
                                     "1995-1996",
                                     NULL);
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_image_id ("image",
                                                         "image",
                                                         "The image",
                                                         pdb->gimp, FALSE,
                                                         GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_int32 ("offx",
                                                      "offx",
                                                      "x offset for translation",
                                                      G_MININT32, G_MAXINT32, 0,
                                                      GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_int32 ("offy",
                                                      "offy",
                                                      "y offset for translation",
                                                      G_MININT32, G_MAXINT32, 0,
                                                      GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-selection-float
   */
  procedure = gimp_procedure_new (selection_float_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-selection-float");
  gimp_procedure_set_static_strings (procedure,
                                     "gimp-selection-float",
                                     "Float the selection from the specified drawable with initial offsets as specified.",
                                     "This procedure determines the region of the specified drawable that lies beneath the current selection. The region is then cut from the drawable and the resulting data is made into a new layer which is instantiated as a floating selection. The offsets allow initial positioning of the new floating selection.",
                                     "Spencer Kimball & Peter Mattis",
                                     "Spencer Kimball & Peter Mattis",
                                     "1995-1996",
                                     NULL);
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_drawable_id ("drawable",
                                                            "drawable",
                                                            "The drawable from which to float selection",
                                                            pdb->gimp, FALSE,
                                                            GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_int32 ("offx",
                                                      "offx",
                                                      "x offset for translation",
                                                      G_MININT32, G_MAXINT32, 0,
                                                      GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_int32 ("offy",
                                                      "offy",
                                                      "y offset for translation",
                                                      G_MININT32, G_MAXINT32, 0,
                                                      GIMP_PARAM_READWRITE));
  gimp_procedure_add_return_value (procedure,
                                   gimp_param_spec_layer_id ("layer",
                                                             "layer",
                                                             "The floated layer",
                                                             pdb->gimp, FALSE,
                                                             GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-selection-invert
   */
  procedure = gimp_procedure_new (selection_invert_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-selection-invert");
  gimp_procedure_set_static_strings (procedure,
                                     "gimp-selection-invert",
                                     "Invert the selection mask.",
                                     "This procedure inverts the selection mask. For every pixel in the selection channel, its new value is calculated as (255 - old-value).",
                                     "Spencer Kimball & Peter Mattis",
                                     "Spencer Kimball & Peter Mattis",
                                     "1995-1996",
                                     NULL);
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_image_id ("image",
                                                         "image",
                                                         "The image",
                                                         pdb->gimp, FALSE,
                                                         GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-selection-sharpen
   */
  procedure = gimp_procedure_new (selection_sharpen_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-selection-sharpen");
  gimp_procedure_set_static_strings (procedure,
                                     "gimp-selection-sharpen",
                                     "Sharpen the selection mask.",
                                     "This procedure sharpens the selection mask. For every pixel in the selection channel, if the value is > 127, the new pixel is assigned a value of 255. This removes any \"anti-aliasing\" that might exist in the selection mask's boundary.",
                                     "Spencer Kimball & Peter Mattis",
                                     "Spencer Kimball & Peter Mattis",
                                     "1995-1996",
                                     NULL);
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_image_id ("image",
                                                         "image",
                                                         "The image",
                                                         pdb->gimp, FALSE,
                                                         GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-selection-all
   */
  procedure = gimp_procedure_new (selection_all_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-selection-all");
  gimp_procedure_set_static_strings (procedure,
                                     "gimp-selection-all",
                                     "Select all of the image.",
                                     "This procedure sets the selection mask to completely encompass the image. Every pixel in the selection channel is set to 255.",
                                     "Spencer Kimball & Peter Mattis",
                                     "Spencer Kimball & Peter Mattis",
                                     "1995-1996",
                                     NULL);
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_image_id ("image",
                                                         "image",
                                                         "The image",
                                                         pdb->gimp, FALSE,
                                                         GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-selection-none
   */
  procedure = gimp_procedure_new (selection_none_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-selection-none");
  gimp_procedure_set_static_strings (procedure,
                                     "gimp-selection-none",
                                     "Deselect the entire image.",
                                     "This procedure deselects the entire image. Every pixel in the selection channel is set to 0.",
                                     "Spencer Kimball & Peter Mattis",
                                     "Spencer Kimball & Peter Mattis",
                                     "1995-1996",
                                     NULL);
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_image_id ("image",
                                                         "image",
                                                         "The image",
                                                         pdb->gimp, FALSE,
                                                         GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-selection-feather
   */
  procedure = gimp_procedure_new (selection_feather_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-selection-feather");
  gimp_procedure_set_static_strings (procedure,
                                     "gimp-selection-feather",
                                     "Feather the image's selection",
                                     "This procedure feathers the selection. Feathering is implemented using a gaussian blur.",
                                     "Spencer Kimball & Peter Mattis",
                                     "Spencer Kimball & Peter Mattis",
                                     "1995-1996",
                                     NULL);
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_image_id ("image",
                                                         "image",
                                                         "The image",
                                                         pdb->gimp, FALSE,
                                                         GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               g_param_spec_double ("radius",
                                                    "radius",
                                                    "Radius of feather (in pixels)",
                                                    0, G_MAXDOUBLE, 0,
                                                    GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-selection-border
   */
  procedure = gimp_procedure_new (selection_border_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-selection-border");
  gimp_procedure_set_static_strings (procedure,
                                     "gimp-selection-border",
                                     "Border the image's selection",
                                     "This procedure borders the selection. Bordering creates a new selection which is defined along the boundary of the previous selection at every point within the specified radius.",
                                     "Spencer Kimball & Peter Mattis",
                                     "Spencer Kimball & Peter Mattis",
                                     "1995-1996",
                                     NULL);
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_image_id ("image",
                                                         "image",
                                                         "The image",
                                                         pdb->gimp, FALSE,
                                                         GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_int32 ("radius",
                                                      "radius",
                                                      "Radius of border (in pixels)",
                                                      0, G_MAXINT32, 0,
                                                      GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-selection-grow
   */
  procedure = gimp_procedure_new (selection_grow_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-selection-grow");
  gimp_procedure_set_static_strings (procedure,
                                     "gimp-selection-grow",
                                     "Grow the image's selection",
                                     "This procedure grows the selection. Growing involves expanding the boundary in all directions by the specified pixel amount.",
                                     "Spencer Kimball & Peter Mattis",
                                     "Spencer Kimball & Peter Mattis",
                                     "1995-1996",
                                     NULL);
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_image_id ("image",
                                                         "image",
                                                         "The image",
                                                         pdb->gimp, FALSE,
                                                         GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_int32 ("steps",
                                                      "steps",
                                                      "Steps of grow (in pixels)",
                                                      0, G_MAXINT32, 0,
                                                      GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-selection-shrink
   */
  procedure = gimp_procedure_new (selection_shrink_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-selection-shrink");
  gimp_procedure_set_static_strings (procedure,
                                     "gimp-selection-shrink",
                                     "Shrink the image's selection",
                                     "This procedure shrinks the selection. Shrinking invovles trimming the existing selection boundary on all sides by the specified number of pixels.",
                                     "Spencer Kimball & Peter Mattis",
                                     "Spencer Kimball & Peter Mattis",
                                     "1995-1996",
                                     NULL);
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_image_id ("image",
                                                         "image",
                                                         "The image",
                                                         pdb->gimp, FALSE,
                                                         GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_int32 ("steps",
                                                      "steps",
                                                      "Steps of shrink (in pixels)",
                                                      0, G_MAXINT32, 0,
                                                      GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-selection-layer-alpha
   */
  procedure = gimp_procedure_new (selection_layer_alpha_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-selection-layer-alpha");
  gimp_procedure_set_static_strings (procedure,
                                     "gimp-selection-layer-alpha",
                                     "Deprecated: Use 'gimp-item-to-selection' instead.",
                                     "Deprecated: Use 'gimp-item-to-selection' instead.",
                                     "",
                                     "",
                                     "",
                                     "gimp-item-to-selection");
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_layer_id ("layer",
                                                         "layer",
                                                         "Layer with alpha",
                                                         pdb->gimp, FALSE,
                                                         GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-selection-load
   */
  procedure = gimp_procedure_new (selection_load_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-selection-load");
  gimp_procedure_set_static_strings (procedure,
                                     "gimp-selection-load",
                                     "Deprecated: Use 'gimp-item-to-selection' instead.",
                                     "Deprecated: Use 'gimp-item-to-selection' instead.",
                                     "",
                                     "",
                                     "",
                                     "gimp-item-to-selection");
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_channel_id ("channel",
                                                           "channel",
                                                           "The channel",
                                                           pdb->gimp, FALSE,
                                                           GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-selection-save
   */
  procedure = gimp_procedure_new (selection_save_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-selection-save");
  gimp_procedure_set_static_strings (procedure,
                                     "gimp-selection-save",
                                     "Copy the selection mask to a new channel.",
                                     "This procedure copies the selection mask and stores the content in a new channel. The new channel is automatically inserted into the image's list of channels.",
                                     "Spencer Kimball & Peter Mattis",
                                     "Spencer Kimball & Peter Mattis",
                                     "1995-1996",
                                     NULL);
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_image_id ("image",
                                                         "image",
                                                         "The image",
                                                         pdb->gimp, FALSE,
                                                         GIMP_PARAM_READWRITE));
  gimp_procedure_add_return_value (procedure,
                                   gimp_param_spec_channel_id ("channel",
                                                               "channel",
                                                               "The new channel",
                                                               pdb->gimp, FALSE,
                                                               GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-selection-combine
   */
  procedure = gimp_procedure_new (selection_combine_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-selection-combine");
  gimp_procedure_set_static_strings (procedure,
                                     "gimp-selection-combine",
                                     "Deprecated: Use 'gimp-item-to-selection' instead.",
                                     "Deprecated: Use 'gimp-item-to-selection' instead.",
                                     "",
                                     "",
                                     "",
                                     "gimp-item-to-selection");
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_channel_id ("channel",
                                                           "channel",
                                                           "The channel",
                                                           pdb->gimp, FALSE,
                                                           GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               g_param_spec_enum ("operation",
                                                  "operation",
                                                  "The selection operation",
                                                  GIMP_TYPE_CHANNEL_OPS,
                                                  GIMP_CHANNEL_OP_ADD,
                                                  GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);
}
