/* GIMP - The GNU Image Manipulation Program
 * Copyright (C) 1995-2003 Spencer Kimball and Peter Mattis
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/* NOTE: This file is auto-generated by pdbgen.pl. */

#include "config.h"

#include <gegl.h>

#include "pdb-types.h"

#include "core/gimp.h"
#include "core/gimpdatafactory.h"
#include "core/gimpparamspecs.h"

#include "gimppdb.h"
#include "gimpprocedure.h"
#include "internal-procs.h"


static GValueArray *
mypaint_brushes_popup_invoker (GimpProcedure      *procedure,
                               Gimp               *gimp,
                               GimpContext        *context,
                               GimpProgress       *progress,
                               const GValueArray  *args,
                               GError            **error)
{
  gboolean success = TRUE;
  const gchar *mypaint_brush_callback;
  const gchar *popup_title;
  const gchar *initial_brush;

  mypaint_brush_callback = g_value_get_string (&args->values[0]);
  popup_title = g_value_get_string (&args->values[1]);
  initial_brush = g_value_get_string (&args->values[2]);

  if (success)
    {
      if (gimp->no_interface ||
          ! gimp_pdb_lookup_procedure (gimp->pdb, mypaint_brush_callback) ||
          ! gimp_pdb_dialog_new (gimp, context, progress,
                                 gimp_data_factory_get_container (gimp->mypaint_brush_factory),
                                 popup_title, mypaint_brush_callback, initial_brush,
                                 NULL))
        success = FALSE;
    }

  return gimp_procedure_get_return_values (procedure, success,
                                           error ? *error : NULL);
}

static GValueArray *
mypaint_brushes_close_popup_invoker (GimpProcedure      *procedure,
                                     Gimp               *gimp,
                                     GimpContext        *context,
                                     GimpProgress       *progress,
                                     const GValueArray  *args,
                                     GError            **error)
{
  gboolean success = TRUE;
  const gchar *mypaint_brush_callback;

  mypaint_brush_callback = g_value_get_string (&args->values[0]);

  if (success)
    {
      if (gimp->no_interface ||
          ! gimp_pdb_lookup_procedure (gimp->pdb, mypaint_brush_callback) ||
          ! gimp_pdb_dialog_close (gimp, gimp_data_factory_get_container (gimp->mypaint_brush_factory),
                                   mypaint_brush_callback))
        success = FALSE;
    }

  return gimp_procedure_get_return_values (procedure, success,
                                           error ? *error : NULL);
}

static GValueArray *
mypaint_brushes_set_popup_invoker (GimpProcedure      *procedure,
                                   Gimp               *gimp,
                                   GimpContext        *context,
                                   GimpProgress       *progress,
                                   const GValueArray  *args,
                                   GError            **error)
{
  gboolean success = TRUE;
  const gchar *mypaint_brush_callback;
  const gchar *mypaint_brush_name;

  mypaint_brush_callback = g_value_get_string (&args->values[0]);
  mypaint_brush_name = g_value_get_string (&args->values[1]);

  if (success)
    {
      if (gimp->no_interface ||
          ! gimp_pdb_lookup_procedure (gimp->pdb, mypaint_brush_callback) ||
          ! gimp_pdb_dialog_set (gimp, gimp_data_factory_get_container (gimp->mypaint_brush_factory),
                                 mypaint_brush_callback, mypaint_brush_name,
                                 NULL))
        success = FALSE;
    }

  return gimp_procedure_get_return_values (procedure, success,
                                           error ? *error : NULL);
}

void
register_mypaint_brush_select_procs (GimpPDB *pdb)
{
  GimpProcedure *procedure;

  /*
   * gimp-mypaint-brushes-popup
   */
  procedure = gimp_procedure_new (mypaint_brushes_popup_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-mypaint-brushes-popup");
  gimp_procedure_set_static_strings (procedure,
                                     "gimp-mypaint-brushes-popup",
                                     "Invokes the Gimp mypaint brush selection.",
                                     "This procedure opens the mypaint brush selection dialog.",
                                     "Andy Thomas",
                                     "Andy Thomas",
                                     "2012",
                                     NULL);
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_string ("mypaint-brush-callback",
                                                       "mypaint brush callback",
                                                       "The callback PDB proc to call when mypaint brush selection is made",
                                                       FALSE, FALSE, TRUE,
                                                       NULL,
                                                       GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_string ("popup-title",
                                                       "popup title",
                                                       "Title of the mypaint brush selection dialog",
                                                       FALSE, FALSE, FALSE,
                                                       NULL,
                                                       GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_string ("initial-brush",
                                                       "initial brush",
                                                       "The name of the mypaint brush to set as the first selected",
                                                       FALSE, TRUE, FALSE,
                                                       NULL,
                                                       GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-mypaint-brushes-close-popup
   */
  procedure = gimp_procedure_new (mypaint_brushes_close_popup_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-mypaint-brushes-close-popup");
  gimp_procedure_set_static_strings (procedure,
                                     "gimp-mypaint-brushes-close-popup",
                                     "Close the mypaint brush selection dialog.",
                                     "This procedure closes an opened brush selection dialog.",
                                     "Andy Thomas",
                                     "Andy Thomas",
                                     "2012",
                                     NULL);
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_string ("mypaint-brush-callback",
                                                       "mypaint brush callback",
                                                       "The name of the callback registered for this pop-up",
                                                       FALSE, FALSE, TRUE,
                                                       NULL,
                                                       GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-mypaint-brushes-set-popup
   */
  procedure = gimp_procedure_new (mypaint_brushes_set_popup_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-mypaint-brushes-set-popup");
  gimp_procedure_set_static_strings (procedure,
                                     "gimp-mypaint-brushes-set-popup",
                                     "Sets the current mypaint brush in a mypaint brush selection dialog.",
                                     "Sets the current mypaint brush in a mypaint brush selection dialog.",
                                     "Andy Thomas",
                                     "Andy Thomas",
                                     "2012",
                                     NULL);
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_string ("mypaint-brush-callback",
                                                       "mypaint brush callback",
                                                       "The name of the callback registered for this pop-up",
                                                       FALSE, FALSE, TRUE,
                                                       NULL,
                                                       GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_string ("mypaint-brush-name",
                                                       "mypaint brush name",
                                                       "The name of the brush to set as selected",
                                                       FALSE, FALSE, FALSE,
                                                       NULL,
                                                       GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);
}
