/*
 * Decompiled with CFR 0.152.
 */
package org.ginkgo.gcov.builder;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.Launch;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IConsoleManager;
import org.eclipse.ui.console.MessageConsole;
import org.eclipse.ui.console.MessageConsoleStream;
import org.eclipse.ui.internal.Workbench;
import org.ginkgo.gcov.builder.IParser;

public class GcovParser
implements IParser {
    private Pattern funcPattern = Pattern.compile("Function `(.+)'");
    private Pattern filePattern = Pattern.compile("File `(.+)'");
    private Pattern coveragePattern = Pattern.compile("Lines executed:(.+)% of (.+)$");
    private String consoleName = "gcov console";

    private MessageConsole getConsole() {
        IConsoleManager manager = ConsolePlugin.getDefault().getConsoleManager();
        IConsole[] consoles = manager.getConsoles();
        MessageConsole messageConsole = null;
        IConsole[] iConsoleArray = consoles;
        int n = consoles.length;
        int n2 = 0;
        while (n2 < n) {
            IConsole console = iConsoleArray[n2];
            if (console.getName().equals(this.consoleName)) {
                messageConsole = (MessageConsole)console;
                break;
            }
            ++n2;
        }
        if (messageConsole == null) {
            messageConsole = new MessageConsole(this.consoleName, null);
            manager.addConsoles(new IConsole[]{messageConsole});
        }
        return messageConsole;
    }

    public void parse(IFile file) {
        String[] cmdLine = new String[]{"gcov", "-f", "-b", file.getName()};
        IPath workingDirectory = file.getParent().getLocation();
        File workingDir = null;
        if (workingDirectory != null) {
            workingDir = workingDirectory.toFile();
        }
        String[] envp = null;
        Process p = null;
        try {
            p = DebugPlugin.exec((String[])cmdLine, (File)workingDir, (String[])envp);
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        IProcess process = null;
        String programName = cmdLine[0];
        HashMap<String, String> processAttributes = new HashMap<String, String>();
        processAttributes.put(IProcess.ATTR_PROCESS_TYPE, programName);
        if (p != null && (process = DebugPlugin.newProcess((ILaunch)new Launch(null, "run", null), (Process)p, (String)programName, processAttributes)) == null) {
            p.destroy();
        }
        while (!process.isTerminated()) {
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException interruptedException) {}
        }
        try {
            file.getProject().refreshLocal(2, null);
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        MessageConsole console = this.getConsole();
        String cmd = this.generateCommandLine(cmdLine);
        process.setAttribute(IProcess.ATTR_CMDLINE, cmd);
        this.printCommand(console, cmd);
        String errorText = process.getStreamsProxy().getErrorStreamMonitor().getContents();
        this.printError(console, errorText);
        String outputText = process.getStreamsProxy().getOutputStreamMonitor().getContents();
        this.printOutput(console, outputText);
        this.parseString(outputText, file.getProject());
    }

    private void printOutput(MessageConsole console, String outputText) {
        MessageConsoleStream outputStream = console.newMessageStream();
        outputStream.setActivateOnWrite(false);
        outputStream.println(outputText);
    }

    private void printError(MessageConsole console, String errorText) {
        MessageConsoleStream errorStream = console.newMessageStream();
        errorStream.setActivateOnWrite(true);
        if (errorText != null && !errorText.equals("")) {
            errorStream.println(errorText);
        }
    }

    private void printCommand(MessageConsole console, String cmd) {
        MessageConsoleStream commandStream = console.newMessageStream();
        commandStream.setActivateOnWrite(false);
        commandStream.setColor(new Color((Device)Workbench.getInstance().getDisplay(), 0, 0, 255));
        commandStream.print(">");
        commandStream.println(cmd);
    }

    private void parseString(String outputText, IProject project) {
        BufferedReader in = new BufferedReader(new StringReader(outputText));
        String line = null;
        String element = null;
        String elementName = null;
        String persent = null;
        String totalLine = null;
        try {
            while ((line = in.readLine()) != null) {
                Matcher matcher = this.funcPattern.matcher(line);
                if (matcher.find()) {
                    element = "Function";
                    elementName = matcher.group(1);
                    continue;
                }
                matcher = this.filePattern.matcher(line);
                if (matcher.find()) {
                    element = "File";
                    String[] ps = matcher.group(1).split("\\\\");
                    elementName = ps[ps.length - 1];
                    continue;
                }
                matcher = this.coveragePattern.matcher(line);
                if (matcher.find()) {
                    persent = matcher.group(1);
                    totalLine = matcher.group(2);
                    continue;
                }
                if (!line.equals("")) continue;
                if (element.equals("File")) {
                    project.setPersistentProperty(new QualifiedName(elementName, "persent"), persent);
                    project.setPersistentProperty(new QualifiedName(elementName, "totalLine"), totalLine);
                    continue;
                }
                if (!element.equals("Function")) continue;
                project.setPersistentProperty(new QualifiedName(elementName, "persent"), persent);
                project.setPersistentProperty(new QualifiedName(elementName, "totalLine"), totalLine);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        try {
            project.refreshLocal(2, null);
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    private String generateCommandLine(String[] commandLine) {
        if (commandLine.length < 1) {
            return "";
        }
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (i < commandLine.length) {
            buf.append(' ');
            char[] characters = commandLine[i].toCharArray();
            StringBuffer command = new StringBuffer();
            boolean containsSpace = false;
            int j = 0;
            while (j < characters.length) {
                char character = characters[j];
                if (character == '\"') {
                    command.append('\\');
                } else if (character == ' ') {
                    containsSpace = true;
                }
                command.append(character);
                ++j;
            }
            if (containsSpace) {
                buf.append('\"');
                buf.append(command);
                buf.append('\"');
            } else {
                buf.append(command);
            }
            ++i;
        }
        return buf.toString();
    }
}

