/*
 * Decompiled with CFR 0.152.
 */
package org.ginkgo.gcov.builder;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.HashMap;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IConsoleManager;
import org.eclipse.ui.console.MessageConsole;
import org.eclipse.ui.texteditor.MarkerUtilities;
import org.ginkgo.gcov.builder.IParser;

public class CoverageParser
implements IParser {
    public static final String UNCOVER_MARKER_TYPE = "org.ginkgo.gcov.lineUnCoverMarker";
    public static final String COVER_MARKER_TYPE = "org.ginkgo.gcov.lineCoverMarker";
    public static final String COVERAGE_MARKER_TYPE = "org.ginkgo.gcov.CoverageMarker";
    private String consoleName = "onsole";

    private MessageConsole getConsole() {
        IConsoleManager manager = ConsolePlugin.getDefault().getConsoleManager();
        IConsole[] consoles = manager.getConsoles();
        MessageConsole messageConsole = null;
        IConsole[] iConsoleArray = consoles;
        int n = consoles.length;
        int n2 = 0;
        while (n2 < n) {
            IConsole console = iConsoleArray[n2];
            if (console.getName().equals(this.consoleName)) {
                messageConsole = (MessageConsole)console;
                break;
            }
            ++n2;
        }
        if (messageConsole == null) {
            messageConsole = new MessageConsole(this.consoleName, null);
        }
        manager.addConsoles(new IConsole[]{messageConsole});
        return messageConsole;
    }

    public void parse(IFile file) {
        String lineNum = null;
        String execCount = null;
        String line = null;
        IProject project = file.getProject();
        IFile sourceFile = (IFile)project.findMember(file.getName().replaceAll("\\.gcov", ""));
        CoverageParser.deleteMarkers(sourceFile);
        try {
            BufferedReader in = new BufferedReader(new InputStreamReader(file.getContents()));
            while ((line = in.readLine()) != null) {
                HashMap attributes;
                String[] s = line.split(":");
                if (s.length != 3) continue;
                execCount = s[0].trim();
                lineNum = s[1].trim();
                if (execCount.equals("#####")) {
                    attributes = new HashMap();
                    MarkerUtilities.setMessage(attributes, (String)"Not Covered");
                    MarkerUtilities.setLineNumber(attributes, (int)Integer.parseInt(lineNum));
                    MarkerUtilities.createMarker((IResource)sourceFile, attributes, (String)UNCOVER_MARKER_TYPE);
                    continue;
                }
                if (execCount.equals("-")) continue;
                attributes = new HashMap();
                MarkerUtilities.setMessage(attributes, (String)execCount);
                MarkerUtilities.setLineNumber(attributes, (int)Integer.parseInt(lineNum));
                MarkerUtilities.createMarker((IResource)sourceFile, attributes, (String)COVER_MARKER_TYPE);
            }
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    static void deleteMarkers(IFile file) {
        try {
            file.deleteMarkers(COVER_MARKER_TYPE, true, 0);
            file.deleteMarkers(UNCOVER_MARKER_TYPE, true, 0);
        }
        catch (CoreException coreException) {}
    }
}

