#ifndef GINTENLIB_INCLUDED_IGNORE_HPP_
#define GINTENLIB_INCLUDED_IGNORE_HPP_

/*

      <gintenlib/ignore.hpp>

  ignore ： あらゆる代入を無視する変数

  宣言：
    using boost::fusion::ignore;

  機能：
    あらゆる代入操作を受け付けない変数 ignore を定義します。

  使用例：
    struct vector
    {
      double x, y;
      
      vector( double x_, double y_ ) : x(x_), y(y_) {}
      
      template<typename X, typename Y>
      void get_xy( X& x_, Y& y_ ){ x_ = x; y_ = y; }
      
    };
    
    vector v( 1, 2 );
    double x;
    v.get_xy( x, gintenlib::ignore );

  補足：
    ・あんまり使わないかも

*/

#include <boost/fusion/container/generation/ignore.hpp>

namespace gintenlib
{
    using boost::fusion::ignore;

} // namespace gintenlib

#endif  // #ifndef GINTENLIB_INCLUDED_IGNORE_HPP_
