#ifndef GINTENLIB_INCLUDED_IS_SAME_CLASS_HPP_
#define GINTENLIB_INCLUDED_IS_SAME_CLASS_HPP_

/*
      <gintenlib/is_same_class.hpp>

  is_same_class ： const, volatile を除いた状態での型の比較
  
  宣言：
    template< typename T1, typename T2 >
    class is_same_class
    {
      static bool const value;
    };
    template< typename T1, typename T2, typename T = void >
    class enable_if_same_class
      : enable_if< is_same_class<T1, T2>, T > {};

  機能：
    下の定義を見れば一目瞭然。remove_cv して is_same 比較します。
    比較的多い操作なので、短く使えるように。

*/

#include "enable_if.hpp"

#include <boost/type_traits/remove_cv.hpp>
#include <boost/type_traits/is_same.hpp>

namespace gintenlib
{
  // CV 修飾を除いて同じクラスか否か
  template<typename T1, typename T2>
  struct is_same_class
    : boost::is_same< typename boost::remove_cv<T1>::type, 
      typename boost::remove_cv<T2>::type > {};
  
  // CV 修飾を除いて同じなら有効になる
  template<typename T1, typename T2, typename T = void>
  struct enable_if_same_class
    : enable_if< is_same_class<T1, T2>, T > {};
  
}   // namespace gintenlib

#endif  // #ifndef GINTENLIB_INCLUDED_IS_SAME_CLASS_HPP_ 
